*************************************
*              Div32x16             *
*************************************
* Written By:           Gordon Doughman
* Application Note:     AN1064
* Slightly Modified by: Roger Schaefer
**************************************************
*
* This subroutine performs a 32 by 16 bit unsigned
* devide and produces a 32 bit quotient and a 
* 16 bit remainder.  both the divisor and dividend
* are passed to the subroutine on the stack.  The
* 32 bit quotient and 16 bit remainder are returned
* on the stack in place of the divisor and dividend.
* This allows the calling routine to easily pull
* the answer from the stack and store the result.
*
* The divisor is pushed onto the stack first, 
* followed by the lower 16 bits of the dividend
* and finally the upper 16 bits of the dividend.
* A typical callilng sequence would be:
*
*       ldd     Divisor
*       pshd
*       ldd     Dividend+2
*       pshd
*       ldd     Dividend
*       pshd
*       jsr     Div32x16
*       puld
*       std     Quotient
*       puld
*       std     Quotient+2
*       puld   
*       std     Remainder
*
*
* This subroutine has two local variables.
* A 32 bit variable for partial quotient
* results that is treated as two 16 bit 
* variables and a 16 bit variable for 
* intermediate remaindder results.
*
* NOTE:  This routine was written assuming that
* the previous stack frame pointer is the 
* X-index register.  HOWEVER, because the X-index
* register is required by the integer and 
* fractional divide instructions, the y-index
* register is used as the stack frame pointer
* WITHIN the Div32x16 subroutine.
*
* Declare locals
*
Quo0    equ     0       ;upper 16 bits of quotient
Quo2    equ     2       ;lower 16 bits of quotient
Rem     equ     4       ;declare remainder
LocSize@ equ    6       ;number of bytes of local
                        ;...storage
Num0    equ     LocSize@+6  ;upper 16 bits of dividend
Num2    equ     LocSize@+8  ;lower 16 bits of dividend
Denm    equ     LocSize@+10 ;16 bit divisor
*
Div32x16:
        pshy
        pshx
        clra            ;clear the d-accumulator
        clrb
        pshb            ;allocate & initialize
        psha            ;...locals
        pshb
        psha
        pshb
        psha
        tsy             ;initialize y as the new
                        ;...stack frame pointer
        ldd     Num0,y  ;load the upper 16 bits
                        ;...of the dividend
        cpd     Denm,y  ;is the divisor>the upper
                        ;...16 bits of the
                        ;...dividend?
        blo     Div32x16a    ;yes.  Use fractional
                        ;...devide on the initial
                        ;...value
        ldx     Denm,y  ;load the divisor into X
        idiv            ;divide the upper 16 bits
                        ;...by the divisor
        stx     Quo0,y  ;save the partial quotient
Div32x16a:
        ldx     Denm,y  ;load the divisor into X
        fdiv            ;resolve the remainder
                        ;...into a 16 bit
                        ;fractional part
        stx     Quo2,y  ;save the partical result
        std     Rem,y   ;save the remainder of the
                        ;...fractional devide
                        ;...(partial remainder)
        ldd     Num2,y  ;get the lower 16 bits
                        ;...of the dividend
        ldx     Denm,y  ;get the denominator again
        idiv            ;resolve the remaining
                        ;...quotient
        addd    Rem,y   ;add the previous remain-
                        ;...der to this remainder
        std     Rem,y   ;save total remainder
        xgdx            ;put the last partial
                        ;...quotient into the
                        ;...d-accumulator and
                        ;...save the total remain-
                        ;...der in X
        addd    Quo2,y  ;add partial quoient to the
                        ;...lower 16 bits of the
                        ;...quoient
        std     Num2,y  ;save the result
        ldd     Quo0,y  ;get the upper 16 bits of
                        ;...the quotient
        adcb    #0      ;add the possible carry
                        ;...to the lower 8 bits
        adca    #0      ;add the possible carry
                        ;...to the upper 8 bits
        std     Num0,y  ;save the result
        xgdx            ;get the total remainder
                        ;back into D
        cmpd    Denm,y  ;is the total fractional
                        ;...remainder > the
                        ;...divisor?
        blo     Div32x16b       ;no we're finished
        subd    Denm,y  ;yes.  It will be < than
                        ;...2*Divisor
        std     Rem,y   ;save the final remainder
        ldd     Num2,y  ;now we must add 1 to the
                        ;...32 bit quotient
        addd    #1      ;add 1 to the lower 16 bit
        std     Num2,y  ;save the result
        ldd     Num0,y  ;get the upper 16 bits
        adcb    #0      ;add the possible carry to
                        ;...the lower 8 bits
        adca    #0      ;add the possilble carry
                        ;...to the upper 8 bits
        std     Num0,y  ;save the result
Div32x16b:
        ldd     Rem,y   ;get the final remainder
        std     Denm,y  ;overwrite the devisor
        tsx             ;need to do this for rtd
                        ;...to work correctly
                        ;...deallocate locals and
                        ;...return
        ldab    #LocSize@       ;number of bytes
                                ;...to deallocate
        abx             ;add it to the current
                        ;...stack frame pointer
        txs             ;deallocate storage by 
                        ;...updating the stack
                        ;...pointer
        pulx            ;restore X
        puly            ;restore Y
        rts             ;return to the calling
                        ;...routine
        END     
                                                                


