*
        IFND RATE96     ;Default to 8 MHz
RATE96  EQU  $30        ;Set to $30 if XTL=8 MHz
        ENDIF
*
*********
*  INCHAR() - Reads input until character sent.
*    Echoes char and returns with a = char.
**********
*
INCHAR   EQU    *
         JSR  INPUT
         TSTA
         BEQ  INCHAR            ;jump if no input
         JSR  OUTPUT            ;echo
         RTS
*
*
**********
*  INPUT() - Read device. Returns a=char or 0.
*    This routine also disarms the cop.
**********
INPUT    EQU  *
         JSR    COPRESET
INPUT1   JSR    INSCI           ;read sci
         RTS
*
*
**********
*   OUTPUT() - Output character in A.
* chrcnt indicates the current column on the
* output display.  It is incremented every time
* a character is outputted, and cleared whenever
* the subroutine outcrlf is called.
**********

OUTPUT   EQU  *
         PSHA                   ;save registers
         PSHB
         PSHX
         JSR  OUTSCI            ;write sci
OUTPUT4  PULX
         PULB
         PULA
         INC  CHRCNT            ;increment column count
         RTS
*
*
**********
*   INIT() - Initialize device specified by iodev.
**********
*
INIT     EQU  *
         PSHA                   ;save registers
         PSHX
         JSR  ONSCI             ;initialize sci
         PULX                   ;restore registers
         PULA
         RTS
*
**********
*   ONSCI() - Initialize the SCI for 9600
*                 baud.
**********
ONSCI    LDX  #REGBS
         LDAA #RATE96           ;set to 9600 baud rate
         STAA BAUD,X            ;baud register
         LDAA #$00
         STAA SCCR1,X
         LDAA #$0C
         STAA SCCR2,X           ;enable
         RTS
*
**********
*   INSCI() - Read from SCI.  Return a=char or 0.
**********
INSCI    LDAA SCSR+REGBS        ;read status reg
         ANDA #$20
         BEQ  INSCI1            ;jump if rdrf=0
         LDAA SCDAT+REGBS       ;read data register
*         ANDA #$7F               ;mask parity
INSCI1   RTS
*
*
**********
*  OUTSCI() - Output A to sci. IF autolf = 1,
*               cr and lf sent as crlf.
**********
OUTSCI   EQU    *
         LDX  #REGBS
*        BSR  EVEN  parity
*         LDAB IO,X
*         ORB  #RTS              ;turn on RTS
*         STAB IO,X
         TST  AUTOLF
         BEQ  OUTSCI2           ;jump if autolf=0
         BSR  OUTSCI2
         CMPA #$0D
         BNE  OUTSCI1
         LDAA #$0A              ;if cr, send lf
         BRA  OUTSCI2
OUTSCI1  CMPA #$0A
         BNE  OUTSCI3
         LDAA #$0D              ;if lf, send cr
OUTSCI2  LDAB SCSR,X            ;read status
         BITB #$80
         BEQ  OUTSCI2           ;loop until tdre=1
*        ANDA #$7F              ;mask parity
         STAA SCDAT,X           ;send character
OUTSCI3  RTS
*
        END
