*************************************
*              Mul16x16             *
*************************************
* Written By:           Gordon Doughman
* Application Note:     AN1064
* Slightly Modified by: Roger Schaefer
**************************************************
*
* Declare locals
*
Prd0    equ     0       ;ms byte of partial product
Prd1    equ     1       ;ms byte of next procuct
Prd2    equ     2       ;ls byte of next product
Prd3    equ     3       ;ls byte of partial product
LocSize equ     4       ;number of bytes of local
*
* Offsets to parameters
*
Fact1   equ     LocSize+4
Fact2   equ     LocSize+6
*
Mul16x16:
        pshx            ;save the previous stack
                        ;..frame pointer
        ldx     #0
        pshx            ;allocate space
        pshx            ;    "      "
        tsx             ;initialize new stack frame
        ldaa    Fact1+1,X     ;ls byte of factor 1
        ldab    Fact2+1,X     ;ls byte of factor 2
        mul                   ;multiply them
        std     Prd2,X  ;save the first term of
                        ;..the partial product
        ldaa    Fact1,X ;get ms byte of factor 1
        ldab    Fact2+1,X     ;get ls byte of fac 2
        mul
        addd    Prd1,X  ;add result into the
                        ;..partial product
        std     Prd1,X  ;save the result
        ldaa    Fact1+1,X     ;get ls byte of fac 1
        ldab    Fact2,X       ;get ms byte of fac 2
        mul
        addd    Prd1,X  ;add result into the
                        ;..partial product
        std     Prd1,X  ;save the result
        bcc     Mul16   ;was there a carry into Prd0?
        inc     Prd0,X  ;yes 'add' it in
Mul16   ldaa    Fact1,X ;get ms byte of factor 1
        ldab    Fact2,X ;get ms byte of factor 2
        mul
        addd    Prd0,X  ;add it to the 
                        ;..partial product
        std     Fact1,X ;overwrite the two para-
                        ;..meters with the result
        ldd     Prd2,X
        std     Fact2,X
                        ;return and deallocate
                        ;..the locals
        ldab    #LocSize
        abx             ;add to current stack
                        ;..frame pointer
        txs             ;deallocate storage by up-
                        ;..dating the stack pointer
        pulx
        rts
        END

