*
*********************************         
*       CLOCK DEMO              *   
*                               *
* Demo of the DS1302 clock chip *
* and Junian Date & day-of-week *
* software.                     *
*********************************
*
*
* The following Equates are for IF statements
* in the source file
*                       
*F        EQU     1      ;(D or E or F; only one)
*
*       Real Time Clock is
*DS1302  EQU     0       ;from Dallas is installed 
*PCF8593 EQU     0       ;from Philips is installed
*
***************
*   EQUATES   *
***************
*
REGBS   EQU  $1000      ;start of registers

ROMBS   EQU  $f800      ;start of eeprom
*
        INCLUDE "register.i"
*
* BAUD Rate Constants for different rates and XTLs
        IFD  XTL7
RATE96  EQU  $12        ;Set to $12 if XTL=7.3728
        ENDIF
        IFD  XTL9       ;Set to $22 if XTL=9.8304
RATE96  EQU  $22
        ENDIF
        IFND RATE96     ;Default to 8 MHz
RATE96  EQU  $30        ;Set to $30 if XTL=8 MHz
        ENDIF
*
* PORT A ASSIGMENTS
*               
;       EQU     IC3     ;CS3100                 PA0 
;       EQU     IC2     ;                       PA1
;       EQU     IC1     ;                       PA2 
;       EQU     I4O5    ;                       PA3
;       EQU     0C4     ;                       PA4 
RST     EQU     OC3     ;Enable DS1302          PA5
;       EQU     OC2     ;                       PA6
;       EQU     OC1     ;                       PA7
*
* PORT D ASSIGNMENTS
*
I_O     EQU     %00001000       ;DS1302 I/O    PD3
SCLK    EQU     %00010000       ;DS1302 CLOCK  PD4
*
***************************************************
        IFD  F
STACK   EQU  $3FF               ;should be $3ff for F1
        ENDIF          
        IFND  STACK
STACK   EQU  $FF
        ENDIF
*****************
        RAM     *
*****************
	ORG  	$0                 ;for F or E
*
YEAR    RMB     1
FLG     RMB     1 
* FLG BITS
*                               
LeapYr  EQU     %00000001       ;is this a Leap Year
QFULL   EQU     %00000010       ;input queue is full
ECHO    EQU     %00000100       ;echo input character?
*
*
AUTOLF  RMB     1       ;auto lf flag for i/o
IODEV   RMB     1       ;0=sci,  1=acia, 2=duartA
                        ;3=duartB,       4=MAX3100
                        ;5=bit-bang 38,400 baud
EXTDEV  RMB     1       ;0=none, 1=acia, 2=duart
HOSTDEV RMB     1       ;0=sci,  1=acia, 3=duartB
COUNT   RMB     1       ;# characters read
CHRCNT  RMB     1       ;# characters output on
                        ;..current line
*
*** Buffalo variables - used by:  ***
*                       
PTR0    RMB     2       ;main,readbuff,incbuff,AS
PTR1    RMB     2       ;main,BR,DU,MO,AS
PTR2    RMB     2       ;DU,GO,MO,AS
PTR3    RMB     2       ;HO,MO,AS
*
DBUFR   RMB     9       ;Decimal result buffer
                        ;(8 bytes ASCII)
* Some routines use only first 5 bytes of DBUFR
HTEMP   RMB     3       ;Temp for H6TOD8 (3 bytes)
***********************
*
        CODE
        ORG     ROMBS
*
***********************
START   LDS     #STACK
        CLR     EXTDEV
        CLR     IODEV
        CLR     HOSTDEV
        JSR     INIT            ;initialize IO; set baud
        JSR     SET_LYr
*
        JSR     SHOW_TIME
        JSR     OUTCRLF
        JSR     SHOW_DATE
        JSR     OUTCRLF
        JSR     PRTJULIAN
        JSR     OUTCRLF
        BRA     *
************************************************************
*
************************************************************
*
PRTJULIAN       EQU *
        LDX     #MSG79          ;"The JULIAN Date...
        JSR     OUTSTRG0
        JSR     JULIAN_BIN
        LDX     #PTR3
PRTJ1   JSR     HTOD            ;make ASCII
        LDX     #DBUFR+2        ;100's digit
        LDAA    #EOS
        STAA    DBUFR+5
        JSR     OUTSTRG0
        RTS
*
*
* JULIAN IN BINARY -- Find the Julian day and
*                       return is binary value
*                       in PRT3; used by both
*                       JULIAN and WEEK
JULIAN_BIN      EQU *        
        JSR     Get_Month
        TAB
        ANDA    #$F             ;mask off 10's
        ANDB    #$F0            ;save just 10's
        BEQ     JUL1
        ADDA    #10
JUL1    TAB
        BRSET   FLG, LeapYr, JUL2
        LDY     #MonthTbl
        BRA     JUL3
JUL2    LDY     #MonthTbl_L
JUL3    ASLB                    ;times two
        ABY
        LDD     ,Y              ;get number days
        STD     PTR3
        JSR     Get_Date
        BSR     BCDTOB          ;convert to binary
        TAB                     ;move to B
        CLRA
        ADDD    PTR3            ;add to months
        STD     PTR3
        RTS
*
*
*
* BCDTOB (A)  Enter with a two digit BCD number in
*               reg A; return with binary in A.
*               Does no error checking.
*
BCDTOB  PSHB
        TAB
        LSRB
        LSRB
        LSRB
        LSRB            ;10's in B
        ANDA    #$F     ;1's  in A
        PSHA
        LDAA    #10
        MUL             ;result in B
        PULA
        ABA             ;combine
        PULB
        RTS
*
*
* TIME -- Display real time clock using the same
*         format as DOS
*
SHOW_TIME        EQU     *
        LDX     #MSG20                  ;"Current ...
        JSR     OUTSTRG0
        JSR     Get_Hour
        PSHA
        ANDA    #$30
        LSRA
        LSRA
        LSRA
        LSRA
        BNE     SET_T0
        LDAA    #$F0
SET_T0  EQU     *
        JSR     OUTRHLF
        PULA
        ANDA    #$F
        JSR     OUTRHLF
        LDAA    #':
        JSR     OUTPUT
        JSR     Get_Minutes
        PSHA
        LSRA
        LSRA
        LSRA
        LSRA
        JSR     OUTRHLF
        PULA
        ANDA    #$F
        JSR     OUTRHLF
        LDAA    #':
        JSR     OUTPUT
        JSR     Get_Seconds
        PSHA
        ANDA    #$7F
        LSRA
        LSRA
        LSRA
        LSRA
        JSR     OUTRHLF
        PULA
        ANDA    #$F
        JSR     OUTRHLF
        JSR     OUTSPAC
        JSR     Get_Hour
        TSTA
        BPL     SET_T9
        BITA    #%00010000
        BEQ     PM
        LDAA    #'a
SET_T1  JSR     OUTPUT
        LDAA    #'m
        JSR     OUTPUT
*       LDX     #MSG21          ;"Enter new ...
*       JSR     OUTSTRG
SET_T9  RTS
PM      LDAA    #'p
        BRA     SET_T1
*
*
* DATE -- Show the real time clock
*
*
SHOW_DATE        EQU     *
        LDX     #MSG22          ;"Current ..
        JSR     OUTSTRG0
        JSR     Show_day_of_week 
*------------------------------------------------
        JSR     Get_Month
        PSHA
        BITA    #%00010000
        BNE     SET_D1
        LDAA    #SPACE
SET_D0  JSR     OUTPUT
        PULA
        ANDA    #$F
        JSR     OUTRHLF
        LDAA    #'-
        JSR     OUTPUT
*-------------------------------------------------
        JSR     Get_Date
        PSHA
        LSRA
        LSRA
        LSRA
        LSRA
        JSR     OUTRHLF
        PULA
        ANDA    #$F
        JSR     OUTRHLF
        LDAA    #'-
        JSR     OUTPUT
*-------------------------------------------------
        JSR     SET_LYr         ;get year
        PSHA
        CMPA    #$94
        BLS     SET_D2
        BSR     OUT19
SET_D3  LSRA
        LSRA
        LSRA
        LSRA
        JSR     OUTRHLF
        PULA
        ANDA    #$F
        JSR     OUTRHLF
*       LDX     #MSG23
*       JSR     OUTSTRG
        RTS
*
OUT19   PSHA
        LDAA    #'1
        JSR     OUTPUT
        LDAA    #'9
        JSR     OUTPUT
        PULA
        RTS
OUT20   PSHA
        LDAA    #'2
        JSR     OUTPUT
        LDAA    #'0
        JSR     OUTPUT
        PULA
        RTS
        RTS
SET_D1  LDAA    #'1
        BRA     SET_D0
SET_D2  BSR     OUT20
        BRA     SET_D3
*
*
* SET LEAP YEAR - returns with year in A and
*                 sets the leap year flag
*
SET_LYr: 
        JSR     Get_Year        ;from RTC in BCD
        PSHA
        JSR     BCDTOB          ;convert to binary
                                ;added ver 0.83
        STAA    YEAR                                
        LSRA
        BCS     NOT_LYr
        LSRA
        BCS     NOT_LYr
        BSET    FLG, LeapYr     ;is leap year
        PULA
        RTS
NOT_LYr BCLR    FLG, LeapYr     ;isn't leap year
        PULA
        RTS
*
*
Get_Full_Year:
        jsr     Get_Year        ;from RTC in BCD
        jsr     BCDTOB
        tab
        clra
        cmpb    #94             ;compare to 1994
        bls     Get_Full_Year1
        addd    #1900
        bra     Get_Full_Year2 
Get_Full_Year1:
        addd    #2000
Get_Full_Year2:
        rts
*
Show_day_of_week:
        bsr     Get_day_of_week
        tab
        andb    #%00000111
        lslb                    ;times two
        ldx     #Days_of_Week
        abx
        ldx     0,x
        jsr     OUTSTRG0
        rts
*         
Get_day_of_week:
        jsr     Get_Date        ;return 1 to 31
        jsr     BCDTOB
        tab
        clra
        pshb
        psha
*
        jsr     Get_Month
        jsr     BCDTOB
        tab
        clra
        pshb
        psha 
*
        jsr     Get_Full_Year
        pshb
        psha    
*
        jsr     Compute_Day     ;day returned in A
        pulx                    ;clean stack
        pulx                    ;   "
        pulx                    ;   "
        rts
*        
*
*
COPRESET PSHA
         LDAA #$55              ;reset cop
         STAA COPRST+REGBS
         LDAA #$AA
         STAA COPRST+REGBS
         PULA
         RTS
*
*
*
* MONTH TABLE - A list of the number of days in
*               each month
*
MonthTbl FDB    0
         FDB    0
         FDB    31      ;January
         FDB    59      ;Febuary
         FDB    90      ;March
         FDB    120     ;April
         FDB    151     ;May
         FDB    181     ;June
         FDB    212     ;July
         FDB    243     ;August
         FDB    273     ;September
         FDB    304     ;October
         FDB    334     ;November
Dec      FDB    365     ;December
*
* MONTH TABLE - YEAP YEAR
*
MonthTbl_L      EQU *
        FDB     0
        FDB     0
        FDB     31      
        FDB     60      ;Feb+1
        FDB     91      ;March+1
        FDB     121     ;April+1
        FDB     152     ;May+1
        FDB     182     ;June+1
        FDB     213     ;July+1
        FDB     244     ;Aug+1
        FDB     274     ;Sept+1
        FDB     305     ;Oct+1
        FDB     335     ;Nov+1
DecYLr  FDB     366     ;Dec+1
*
*
Days_of_Week:
        FDB     MSG63           ;SUNDAY
        FDB     MSG64
        FDB     MSG65
        FDB     MSG66
        FDB     MSG67
        FDB     MSG68
        FDB     MSG69
        FDB     MSG9
*
*
Compute_Day:    ;using the Zeller Congrence
        INCLUDE "Zeller.i"
        INCLUDE "Mul16x16.i"
        INCLUDE "Div32x16.i"
        INCLUDE "HTOD.I"
        INCLUDE "utility.i"
        INCLUDE "IO.I"
*********************************************************
* If we have a DS1302 chip installed then load driver   *
* else                                                  *
* simulate to demostrate the rest of the software.      *
*********************************************************
        IFD     DS1302
        INCLUDE "DS1202.I"
        ELSE
Get_Seconds: 
        lda     #$00
        rts
Get_Minutes:
        lda     #$00
        rts
Get_Hour:
        lda     #%10000111
        rts
Get_Date:
        lda     #$21
        rts
Get_Month:
        lda     #$07
        rts
Get_Year:
        lda     #$03
        rts
        ENDIF
************************************************************
*
*************************
*     MESSAGE SCREEN    *
*************************
*
MSG9    FCC     'Bad argument'
        FCB     EOT
*
MSG20   FCC     'Current time is '
        FCB     EOT
MSG21   FCC     'Enter new time: '
        FCB     EOT
MSG22   FCC     'Current date is '
        FCB     EOT
MSG23   FCC     'Enter new date (mm-dd-yy) '
        FCB     EOT
*
MSG63   FCC     'SUNDAY '
        FCB     EOT
MSG64   FCC     'MONDAY '
        FCB     EOT
MSG65   FCC     'TUESDAY '
        FCB     EOT
MSG66   FCC     'WEDNESDAY '
        FCB     EOT
MSG67   FCC     'THURSDAY '
        FCB     EOT
MSG68   FCC     'FRIDAY '
        FCB     EOT
MSG69   FCC     'SATURDAY '
        FCB     EOT
MSG79   FCC     'The JULIAN Date is '
        FCB     EOT
******************************   
	org	$FFFE
RESET	FDB	START
