*
***
* HTOD - Subroutine to convert a 16-bit hex
*         number to a 5 digit decimal number.
*
* Uses 5 byte variable "DBUFR" for decimal ASCII
* result.  On entry X points to hex value to be
* converted & displayed.  All registers are
* unchanged upon return.
***
*
HTOD    PSHX            ;Save registers
        PSHB
        PSHA
        LDD     0,X     ;D=hex value to be converted
        LDX     #10000
        IDIV            ;10,000 -> X; r -> D
        XGDX            ;Save r in X;
                        ;10,000s digit in D (A:B)
        ADDB    #$30    ;Convert to ASCII
        STAB    DBUFR   ;Store in decimal buffer
        XGDX            ;r back to D
        LDX     #1000
        IDIV            ;1,000 -> X; r -> D
        XGDX            ;Save r in X;
                        ;1,000s digit in D (A:B)
        ADDB    #$30    ;Convert to ASCII
        STAB    DBUFR+1 ;Store in decimal buffer
        XGDX            ;r back to D
        LDX     #100
        IDIV            ;r 100 -> X; r -> D
        XGDX            ;Save r in X;
                        ;100s digit in D (A:B)
        ADDB    #$30    ;Convert to ASCII
        STAB    DBUFR+2 ;Store in decimal buffer
        XGDX            ;r back to D
        LDX     #10
        IDIV            ;r 10 -> X;
                        ;r in D (B is units digit)
        ADDB    #$30    ;Convert to ASCII
        STAB    DBUFR+4 ;Store to units digit
        XGDX            ;10s digit to D (A:B)
        ADDB    #$30    ;Convert to ASCII
        STAB    DBUFR+3 ;Store in decimal buffer
        PULA            ;Restore registers
        PULB
        PULX
        RTS             ;** Return **
**************************************************
*
*
***
* H6TOD8 - Subroutine to convert a 24-bit hex
*          number to an 8 digit decimal number.
*
* Uses 3 byte variable "HTEMP" for hex working
* value.  Uses 8 byte variable "DBUFR" for
* decimal ASCII result.
*
* On entry X points to hex value to be converted &
* displayed.  All registers are unchanged upon
* return.
***

H6TOD8  PSHY            ;Save registers
        PSHX
        PSHB
        PSHA
        LDD     1,X     ;Move hex to HTEMP
        STD     HTEMP+1 ;Two lower bytes moved
        LDAA    0,X     ;Upper byte
        STAA    HTEMP
        LDY     #DBUFR  ;Point at MS digit of buffer
        LDX     #CON10M ;Point at first 24-bit
                        ;constant
HTDLP   CLRA            ;A keeps track of # of
                        ;subtractions
HLPIN   INCA            ;Inner loop; once per
                        ;subtraction
        LDAB    HTEMP+2 ;Start 24-bit subtract
        SUBB    2,X
        STAB    HTEMP+2 ;Update low byte
        LDAB    HTEMP+1 ;Middle byte
        SBCB    1,X     ;Sub with carry
        STAB    HTEMP+1 ;Update middle byte
        LDAB    HTEMP   ;High byte
        SBCB    0,X
        STAB    HTEMP   ;Update high byte
        BCC     HLPIN   ;If no borrow;
                        ;subtract again
        LDAB    HTEMP+2 ;Last subtract too far;
                        ;add back
        ADDB    2,X     
        STAB    HTEMP+2 ;Update low byte
        LDAB    HTEMP+1 ;Middle byte
        ADCB    1,X     ;Sub with carry
        STAB    HTEMP+1 ;Update middle byte
        LDAB    HTEMP   ;High byte
        ADCB    0,X
        STAB    HTEMP   ;Update high byte

        ADDA    #$2F    ;Convert digit to ASCII
        STAA    0,Y     ;Store to decimal buffer
        INY             ;Point to next decimal digit
        INX             ;Point to next 24-bit const
        INX
        INX
        CPX     #CONEND ;See if done yet
        BNE     HTDLP   ;If not done, do nxt digit

        LDAA    HTEMP+2 ;Get 1s digit
        ADDA    #$30    ;Convert to ASCII
        STAA    0,Y     ;Store to last decimal digit
        
        PULA            ;Restore registers
        PULB
        PULX
        PULY
        RTS             ;** Return from H6TOD8 **
*
CON10M  FCB     $98,$96,$80 ; 24-bit     10,000,000
        FCB     $0F,$42,$40 ; 24-bit      1,000,000
        FCB     $01,$86,$A0 ; 24-bit        100,000
        FCB     $00,$27,$10 ; 24-bit         10,000
        FCB     $00,$03,$E8 ; 24-bit equiv of 1,000
        FCB     $00,$00,$64 ; 24-bit equiv of   100
        FCB     $00,$00,$0A ; 24-bit equiv of    10
CONEND  EQU     *           ; Don't need 1s const
*
**************************************************
*        
        END
