*
*******************************
*** I/O UTILITY SUBROUTINES ***
*******************************
*
*  These subroutines perform the neccesary
*  data I/O operations.
*
* OUTLHLF-Convert left 4 bits of A from binary
*           to ASCII and output.
* OUTRHLF-Convert right 4 bits of A from binary
*           to ASCII and output.
* OUT1BYT-Convert byte addresed by X from binary
*           to ASCII and output.
* OUT1BSP-Convert byte addressed by X from binary
*           to ASCII and output followed by a
*           space.
* OUT2BSP-Convert 2 bytes addressed by X from binary
*           to ASCII and  output followed by a space.
* OUTSPAC-Output a space.
*
* OUTCRLF-Output a line feed and carriage return.
*
* OUTSTRG-Output the string of ASCII bytes addressed
*           by X until $04.
* OUTA-Output the ASCII character in A.
*
******************************
*
***********
*  OUTRHLF(), OUTLHLF(), OUTA()
* Convert A from binary to ASCII and output.
* Contents of A are destroyed..
**********
OUTLHLF  LSRA            ;shift data to right
         LSRA
         LSRA
         LSRA
OUTRHLF  ANDA #$0F       ;mask top half
         ADDA #$30       ;convert to ascii
         CMPA #$39
         BLE  OUTA       ;jump if 0-9
         ADDA #$07       ;convert to hex A-F
OUTA     JSR  OUTPUT     ;output character
         RTS
*
**********
*  OUT1BYT(x) - Convert the byte at X to two
* ASCII characters and output. Return X pointing
* to next byte.
**********
*
OUT1BYT  PSHA
         LDAA 0,X        ;get data in a
         PSHA            ;save copy
         BSR  OUTLHLF    ;output left half
         PULA            ;retrieve copy
         BSR  OUTRHLF    ;output right half
         PULA
         INX
         RTS
*
**********
*  OUT1BSP(x), OUT2BSP(x) - Output 1 or 2 bytes
* at x followed by a space.  Returns x pointing to
* next byte.
**********
OUT2BSP  JSR  OUT1BYT      ;do first byte
OUT1BSP  JSR  OUT1BYT      ;do next byte
OUTSPAC  LDAA #$20         ;output a space
         JSR  OUTPUT
         RTS
*
**********
*  OUTCRLF() - Output a Carriage return and
* a line feed.  Returns a = cr.
**********
OUTCRLF  LDAA #$0D      ;cr
         JSR  OUTPUT    ;output a
         LDAA #$00
         JSR  OUTPUT    ;output padding
         LDAA #$0D
         CLR  CHRCNT    ;zero the column counter
         RTS
*
**********
*  OUTSTRG(x) - Output string of ASCII bytes
* starting at x until end of text ($04).  Can
* be paused by control w (any char restarts).
**********
OUTSTRG  JSR  OUTCRLF
OUTSTRG0 PSHA
OUTSTRG1 LDAA 0,X          ;read char into a
         CMPA #EOT
         BEQ  OUTSTRG3     ;jump if eot
         JSR  OUTPUT       ;output character
         INX
         JSR  INPUT
         BEQ  OUTSTRG1     ;jump if no input
         CMPA #CTLW
         BNE  OUTSTRG1     ;jump if not cntlw
OUTSTRG2 JSR  INPUT
         BEQ  OUTSTRG2     ;jump if any input
         BRA  OUTSTRG1
OUTSTRG3 PULA
         JSR    COPRESET
         RTS
	end
