#include "all03.h"

#define PROGNAME	"TEST PROGRAM  V1.00"

int PROMA3 = 1;

/*=========================================================*/
void showvals( void )
{
	struct text_info ti;

	gettextinfo( &ti );

	textattr( ( BLUE << 4 ) + WHITE ); clscrn( 0,40, 9,79 );
	_window( 3,40, 9,79 );
	
	_window( 6,69, 9,79 );
	locate( 7,71 ); cprintf( "COUNTER" );
	locate( 8,71 ); cprintf( " 00000 " );

	locate( 4,54 ); cprintf( "PARAMETERS" );
	locate( 5,50 ); cprintf( "I/O addr.:  %04X", idport );

	locate( 0,40 ); cprintf( "*VCC :%4.1fV", VCC / 10.0 );
	locate( 1,40 ); cprintf( "*VHH :%4.1fV", VHH / 10.0 );
	locate( 2,40 ); cprintf( "*VOP :%4.1fV", VOP / 10.0 );

	locate( 0,62 ); cprintf( "*GND PIN:%s",
		( getport( OTHERENID, 0 ) & 1 ) ? "P11&30" : "P20" );

	textattr( ti.attribute );
	gotoxy( ti.curx, ti.cury );
}

/*==============================================================*/
void power_menu( void )
{
	textattr( ( CYAN << 4 ) + WHITE ); _window( 10,40, 23,79 );

	locate(11,41 ); cprintf( "Measure the following points by DVM,  " );
	locate(12,41 ); cprintf( "values have to be within the specified" );
	if( PROMA3 ) {
	locate(13,41 ); cprintf( "limits.     Ground point is P10 of CN3" );

	locate(15,41 ); cprintf( "  CN3            MIN.    TYP.    MAX. " );
	locate(16,41 ); cprintf( "P1,P20           4.8V    5.0V    5.2V " );
	locate(17,41 ); cprintf( "P3,P18          10.8V   12.0V   13.2V " );
	locate(18,41 ); cprintf( "(Coll.TR1)      27.5V   30.5V   33.5V " );
	locate(19,41 ); cprintf( "(Coll.TR2)      17.3V   19.2V   21.2V " );
	locate(20,41 ); cprintf( "U26 P3(723C)     7.2V    8.0V    8.8V " );
	} else {
	locate(13,41 ); cprintf( "limits.       Ground point is P1 of J2" );

	locate(15,41 ); cprintf( "   J2            MIN.    TYP.    MAX. " );
	locate(16,41 ); cprintf( "P2,P39           4.8V    5.0V    5.2V " );
	locate(17,41 ); cprintf( "P3,P38          10.8V   12.0V   13.2V " );
	locate(18,41 ); cprintf( "(Coll.Q5)       27.5V   30.5V   33.5V " );
	locate(19,41 ); cprintf( "(Coll.Q1)       17.3V   19.2V   21.2V " );
	locate(20,41 ); cprintf( "U38 P3(723C)     7.2V    8.0V    8.8V " );
	}	

	locate(22,41 ); cprintf( "Press any key back to main menu" );

	textattr( ( BLUE << 4 ) + WHITE );
	locate(10,43 ); cprintf( " POWER SUPPLY TEST " );

	getch();
}

/*==============================================================*/
void adj_menu( void )
{
	textattr( ( CYAN << 4 ) + WHITE ); _window( 10,40, 23,79 );
	
	locate(11,41 ); cprintf( "Measure and adjust the following      " );
	locate(12,41 ); cprintf( "points on connector J2 by DVM, the    " );
	locate(13,41 ); cprintf( "values have to be in the specified    " );

	if( PROMA3 ) {
	locate(14,41 ); cprintf( "limits.    Ground point is P10 of CN4 " );

	locate(16,41 ); cprintf( " CN4        MIN.   TYP.   MAX.   ADJ. " );
	locate(17,41 ); cprintf( "P9,P12      7.9V   8.0V   8.1V   VR3  " );
	locate(18,41 ); cprintf( "P8,P13     15.2V  15.3V  15.4V   VR2  " );
	locate(19,41 ); cprintf( "P7,P14     25.4V  25.5V  25.6V   VR1  " );
	} else {
	locate(14,41 ); cprintf( "limits.    Ground point is P20 of J2  " );

	locate(16,41 ); cprintf( "  J2        MIN.   TYP.   MAX.   ADJ. " );
	locate(17,41 ); cprintf( "P17,P24     7.9V   8.0V   8.1V   VR3  " );
	locate(18,41 ); cprintf( "P18,P23    15.2V  15.3V  15.4V   VR2  " );
	locate(19,41 ); cprintf( "P19,P22    25.4V  25.5V  25.6V   VR1  " );
	}

	locate(22,41 ); cprintf( "Press any key back to main menu" );

	setdac_raw( VOPID, 255 );		/* VOP = 25.50V nom. */
	setdac_raw( VHHID, 153 );		/* VHH = 15.30V nom. */
	setdac_raw( VCCID,  80 );		/* VCC =  8.00V nom. */
	showvals();

	textattr( ( BLUE << 4 ) + WHITE );
	locate(10,43 ); cprintf( " VOLTAGE ADJUSTMENT " );

	getch();
}

/*==============================================================*/
void gndtest( void )
{
	int ch, step = 0;

	textattr( ( CYAN << 4 ) + WHITE ); _window( 10,40, 23,79 );

	locate(11,41 ); cprintf( "There are 3 GND pins on test-socket   " );
	locate(12,41 ); cprintf( "that have to be tested by DVM, the    " );
	locate(13,41 ); cprintf( "values have to be within the specified" );
	if( PROMA3 ) {
	locate(14,41 ); cprintf( "limits.     Ground point is P10 of CN4" );
	} else {	
	locate(14,41 ); cprintf( "limits.      Ground point is P20 of J2" );
	}
	locate(16,41 ); cprintf( "    Test-socket    MIN.   TYP.   MAX. " );
	locate(17,41 ); cprintf( " STEP              0.0V   0.1V   0.2V " );
	locate(18,41 ); cprintf( " all other pins    4.9V   5.0V   5.1V " );

	locate(20,41 ); cprintf( "Press 'S' key to change testing step  " );
	locate(21,41 ); cprintf( "Press <CR> back to main menu          " );

	textattr( ( BLUE << 4 ) + WHITE );
	locate(10,43 ); cprintf( " GND PIN TEST " );

	setdac( VCCID, 50 );
	showvals();

	textattr( ( CYAN << 4 ) + WHITE );

	while( TRUE )
	{
		if( step == 0 )
		{
			setother( 0, 0 );
			locate( 17, 47 );
			cprintf( "1: P20    " );
		}
		else
		{
			setother( 0, 1 );
			locate( 17, 47 );
			cprintf( "2: P11,P30" );
		}

		locate( 21,70 );
		step ^= 1;

		while( (ch=getch()) == 0 )
			getch();

		if( ch==CR || ch==LF || ch==ESC )
			break;
	}
}

/*==============================================================*/
void vcctest( void )
{
	int ch, step=0;
	static char pins[] = { 1,5,7,9,26,27,28,29,30,31,32,34,36,40, 0 };

	textattr( ( CYAN << 4 ) + WHITE ); _window( 10,40, 23,79 );

    locate(11,41); cprintf( "There are 14 VCC pins on testsocket" );
	locate(12,41); cprintf( "that must be tested by DVM, the values" );
    locate(13,41); cprintf( "have to be within the specified limits" );
    locate(14,41); cprintf( "Ground point is P20 of test-socket" );
    locate(15,41); cprintf( "(except for P20: Ground is P11,P30)" );

	locate(17,41 ); cprintf( "    Test-socket   MIN.   TYP.   MAX." );
	locate(18,41 ); cprintf( " STEP             4.9V   5.0V   5.1V" );

    locate(20,41); cprintf( "Press 'S' key to change testing step" );
    locate(21,41); cprintf( "Press <CR> back to main menu" );

	textattr( ( BLUE << 4 ) + WHITE );
	locate(10,43); cprintf( " VCC PIN TEST " );

	textattr( ( CYAN << 4 ) + WHITE );

	setdac( VCCID, 50 ); 				/* vcc 5V output */
	showvals();

	while( TRUE )
	{
		setpin(  pins[step], TTLID, 1 );
		setpin(  pins[step], VCCENID, 1 );
		
		locate( 18, 47 ); cprintf( "%2d: P%d ", step+1, pins[step] );
		locate( 21, 70 );

		while( (ch=getch()) == 0 )
			getch();

		initio();

		if( ch==CR || ch==LF || ch==ESC )
			break;

		if( ( ch=toupper(ch) ) == 'S' )
			if( pins[++step] == 0 )
				step = 0;
	}
}

/*==============================================================*/
void vhhtest( void )
{
	int ch, step = 0;

	textattr( ( CYAN << 4 ) + WHITE ); _window( 10,40, 23,79 );

	locate(11,41 ); cprintf( "There are 23 VHH pins on test-socket" );
	locate(12,41 ); cprintf( "that must be tested by DVM, the values" );
	locate(13,41 ); cprintf( "have to be within the specified limits" );
    locate(14,41); cprintf( "Ground point is P20 of test-socket" );
    locate(15,41); cprintf( "(except for P20: Ground is P11,P30)" );

	locate(17,41 ); cprintf( "    Test-socket   MIN.   TYP.   MAX." );
	locate(18,41 ); cprintf( " STEP 1:         11.7V  12.0V  12.3V" );
	locate(19,41 ); cprintf( " all other Pins   4.9V   5.0V   5.1V" );
 
    locate(21,41 ); cprintf( "Press 'S' key to change testing step" );
    locate(22,41 ); cprintf( "Press <CR> back to main menu" );

	textattr( ( BLUE << 4 ) + WHITE );
	locate( 10,43 ); cprintf( " VHH PIN TEST " );

	textattr( ( CYAN << 4 ) + WHITE );

	setdac( VCCID, 50 );			/* VCC 5V output */
	setdac( VHHID, 120 );			/* VHH 12V output */
	showvals();

	while( TRUE )
	{
		setother( 0, ( step == 20-9 ) ? 1:0 );		/* Pin20 -> Pin30=GND */
		setpin( step + 9, VHHENID, 1 );

		locate( 18, 47 ); cprintf( "%2d: P%d ", step+1, step+9 );
		locate( 22, 70 );

		while( (ch=getch()) == 0 )
			getch();

		initio();

		if( ch==CR || ch==LF || ch==ESC )
			break;

		if( ( ch = toupper(ch) ) == 'S' )
			if( ++step == 24 )
				step = 0;
	}
}

/*==============================================================*/
void voptest( void )
{
	int ch, step=0;
	char pin[29] = {1,5,6,7,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
					26,27,28,29,30,31,32,36};

	textattr( ( CYAN << 4 ) + WHITE ); _window( 10,40, 23,79 );

	locate(11,41 ); cprintf( "There are %d VOP pins on test-socket", PROMA3 ? 29:28 );
	locate(12,41 ); cprintf( "that must be tested by DVM, the values" );
	locate(13,41 ); cprintf( "have to be within the specified limits" );
    locate(14,41 ); cprintf( "Ground point is P20 of test-socket" );
    locate(15,41 ); cprintf( "(except for P20: Ground is P11,P30)" );

	locate(17,41 ); cprintf( "    Test-socket   MIN.   TYP.   MAX." );
	locate(18,41 ); cprintf( " STEP 1:         20.5V  21.0V  21.5V" );
	locate(19,41 ); cprintf( " all other Pins   4.9V   5.0V   5.1V" );
 
    locate(21,41 ); cprintf( "Press 'S' key to change testing step" );
    locate(22,41 ); cprintf( "Press <CR> back to main menu" );

	textattr( ( BLUE << 4 ) + WHITE );
	locate( 10,43 ); cprintf( " VOP PIN TEST " );

	textattr( ( CYAN << 4 ) + WHITE );

	setdac( VCCID, 50 );		/* VCC 5V out put */
	setdac( VOPID, 210 );		/* VOP 21V output */
	showvals();

	while( TRUE )
	{
		setother( 0, ( pin[step] == 20 ) ? 1:0 );	/* Pin20 -> Pin30=GND */
		setpin( pin[step], VOPENID, 1 );

		locate( 18, 47 ); cprintf( "%2d: P%d ",
							step + ( ( PROMA3 | ( step < 2 ) ) ? 1:0 ),
							pin[step] );
		locate( 22, 70 );

		while( (ch=getch()) == 0 )
			getch();

		initio();

		if( ch==CR || ch==LF || ch==ESC )
			break;

		if( toupper(ch) == 'S' )
		{
			if( ++step == 29 )
				step = 0;
			else if( step == 2 && !PROMA3 )
				++step;
		}
	}
}

/*==============================================================*/
void iotest( void )
{
	int vcc = 25, ch, done = 0, step=1, i;

	for( i = 0; i < 5; ++i )
		setport( TTLID, i, 0x00 );	/* all pins to TTL low */

	textattr( ( CYAN << 4 ) + WHITE ); clscrn( 0,0, 24,79 );

	textattr( ( BLUE << 4 ) + WHITE );
	locate( 0,3 ); cprintf( " I/O PIN TEST ");
	textattr( ( CYAN << 4 ) + WHITE );

	locate( 2,1 ); cprintf( "Measure all 40 I/O pins on test-socket." );
	locate( 3,1 ); cprintf( "The values have to be within the specified" );
    locate( 4,1 ); cprintf( "limits. Ground point is P20 of test-socket." );
	locate( 5,1 ); cprintf( "(except for P20: Ground is P11,P30)" );

	locate( 8,1 ); cprintf( "Measure test-socket pin for" );
	locate( 9,1 ); cprintf( "           1 : 4.9V  to  5.1V" );
	locate(10,1 ); cprintf( "           0 : 0.0V  to  0.2V" );

	locate(12,1 ); cprintf( "O: software output to test-socket." );
	locate(13,1 ); cprintf( "I: readback from test-socket pin." );
	locate(14,1 ); cprintf( "   If there is a difference between" );
	locate(15,1 ); cprintf( "   OUTPUT and INPUT, the test fails !" );
 
	locate(17,1 ); cprintf( "Press 'S' key to change testing step" );
	locate(18,1 ); cprintf( "Press 'V' key to change test voltage" );
	locate(19,1 ); cprintf( "Press <CR> back to main menu" );

	_window( 2,56, 23,65 );

	for( i = 0; i < 40; ++i )
	{
		if( i < 20 )
			locate( 3 + i, 57 ), cprintf( "%d", i+1 );
		else
			locate( 42 - i,  63 ), cprintf( "%d", i+1 );
	}

	locate( 1,52 ); cprintf( "I O            O I" );

	locate( 2,60 );
	putch( 194 ); putch( 194 );

	while( !done )
	{
		setdac( VCCID, vcc );			/* VCC  output */

		locate( 9,15 );
		cprintf( " %d.%dV  to  %d.%dV",
			( 95 * vcc) / 1000, ( ( 95 * vcc) / 100 ) % 10,
			(105 * vcc) / 1000, ( (105 * vcc) / 100 ) % 10 );

		setother( 0, ( step == 20 ) ? 1:0 );	/* Pin20 -> Pin30=GND */
		setpin( step, TTLID, 1 );

		for( i = 1; i <= 40; ++i )
		{
			if( i < 21 )
			{
				locate( 2 + i,  52 );
				cprintf( "%d %d", getpin(i), i == step );
			}
			else
			{
				locate( 43 - i,  67 );
				cprintf( "%d %d", i == step, getpin(i) );
			}
		}

		if( step < 21 )
			locate( 2 + step,  57 );
		else
			locate( 43 - step, 64 );

		while( ( ch = toupper( getch() ) ) == 0 )
			getch();

		setpin( step, TTLID, 0 );

		switch( ch )
		{
		case CR:
		case LF:
		case ESC: done = 1; break;

		case 'S': if( ++step == 41 ) step = 1; break;
		case 'V':
			switch( vcc )
			{
			case 25:	vcc = 33; break; 
			case 33:	vcc = 50; break;
			case 50:	vcc = 65; break;
			case 65:	vcc = 25; break;
			}
		}
	}
}

/*==============================================================*/
void xtratest( void )
{
	int ch, step;

	textattr( ( CYAN << 4 ) + WHITE ); clscrn( 0,0, 24,79 );

	textattr( ( BLUE << 4 ) + WHITE );
	locate( 0,3 ); cprintf( " EXTRA PIN TEST ");
	textattr( ( CYAN << 4 ) + WHITE );

	locate( 1,1 ); cprintf( "Check values being within limits.      " );
	locate( 2,1 ); cprintf( "Ground point is P20 of test-socket     " );

	locate( 4,1 ); cprintf( "        Test-socket  MIN.   TYP.   MAX." );
	locate( 5,1 ); cprintf( " STEP 1    P32      11.7V  12.0V  12.3V" );
	locate( 6,1 ); cprintf( " STEP 2    P31      11.7V  12.0V  12.3V" );
	locate( 7,1 ); cprintf( " STEP 3    P30      11.7V  12.0V  12.3V" );
	locate( 8,1 ); cprintf( " STEP 4    P29      11.7V  12.0V  12.3V" );
	locate( 9,1 ); cprintf( " STEP 5    P28      11.7V  12.0V  12.3V" );
	locate(10,1 ); cprintf( " STEP 6    P1       20.5V  21.0V  21.5V" );
	locate(11,1 ); cprintf( " STEP 7    P5       20.5V  21.0V  21.5V" );
	locate(12,1 ); cprintf( " STEP 8    P7       20.5V  21.0V  21.5V" );
	locate(13,1 ); cprintf( " STEP 9    P7       17.0V  17.5V  18.0V" );
	locate(14,1 ); cprintf( " STEP 10   P25      17.0V  17.5V  18.0V" );
	if( PROMA3 ) {
	locate(15,1 ); cprintf( " STEP 11   P2          2.00 MHz OSC   " );
	locate(16,1 ); cprintf( " STEP 12   P19         2.00 MHz OSC   " );
	} else {
	locate(15,1 ); cprintf( " STEP 11   P2          2.21 MHz OSC   " );
	locate(16,1 ); cprintf( " STEP 12   P19         4.43 MHz OSC   " );
	}

	locate(18,1 ); cprintf( "all other pins are VCC (4.9V - 5.1V)" );
	locate(19,1 ); cprintf( "P3,P18 are HiZ in step 11,12 resp.     " );

	locate(21,1 ); cprintf( "Press 'S' key to change testing step" );
	locate(22,1 ); cprintf( "Press <CR> back to main menu" );

	step = 0;

	locate( 5,1 );

	setdac( VCCID,  50 );			/* VCC 5V output */
	setdac( VHHID, 120 );			/* VHH 12V output */
	setdac( VOPID, 210 );			/* VOP 21V output */

	while( TRUE )
	{
		showvals();

		switch( step )
		{
		case 0:	setpin( 32, VHHENCID, 1 ); break;
        case 1:	setpin( 31, VHHENCID, 1 ); break;
    	case 2:	setpin( 30, VHHENCID, 1 ); break;
	    case 3:	setpin( 29, VHHENCID, 1 ); break;
        case 4:	setpin( 28, VHHENCID, 1 ); break;
	    case 5:	setpin(  1, VOPENID, 1 ); break;
	    case 6:	setpin(  5, VOPENID, 1 ); break;
        case 7:	setpin(  7, VOPENID, 1 ); break;
    	case 8:	setport( OTHERENID, 0, 0x02 ); break;	// VOP-2.4V @ 7
    	case 9:	setport( OTHERENID, 0, 0x04 ); break;	// VOP-2.4V @ 25
	    case 10:setport( OTHERENID, 0, 0x08 ); break;	// 2MHz @ 2/3
        case 11:setport( OTHERENID, 0, 0x20 ); break;	// 4MHz @ 19/18
		}

		locate( 5+step,1 );

		while( (ch=getch()) == 0 )
			getch();

		initio();

		if( ch==CR || ch==LF || ch==ESC )
			break;

		if( ( ch=toupper(ch) ) == 'S' )
			if( ++step == 12 )
				step = 0;
	}
}

/*==============================================================*/
void muxtest( void )
{
	int done = 0, step = 0;

	textattr( ( CYAN << 4 ) + WHITE ); clscrn( 0,0, 24,79 );

	textattr( ( BLUE << 4 ) + WHITE );
	locate( 0,3 ); cprintf( " MULTIPLEXER TEST ");
	textattr( ( CYAN << 4 ) + WHITE );

	locate( 1,1 ); cprintf( " STEP       LATCH  REMARKS" );
	locate( 2,1 ); cprintf( "--------------------------------------" );
	locate( 3,1 ); cprintf( " STEP 1    TTL[0] (Pin 1-8)" );
	locate( 4,1 ); cprintf( " STEP 2    TTL[1] (Pin 9-16)" );
	locate( 5,1 ); cprintf( " STEP 3    TTL[2] (Pin 17-24)" );
	locate( 6,1 ); cprintf( " STEP 4    TTL[3] (Pin 25-32)" );
	locate( 7,1 ); cprintf( " STEP 5    TTL[4] (Pin 33-40)" );
	locate( 8,1 ); cprintf( " STEP 6    VOP[0] (Pin 1,5,7)" );
	locate( 9,1 ); cprintf( " STEP 7    VOP[1] (Pin 9-16)" );
	locate(10,1 ); cprintf( " STEP 8    VOP[2] (Pin 17-24)" );
	locate(11,1 ); cprintf( " STEP 9    VOP[3] (Pin 25-32)" );
	locate(12,1 ); cprintf( " STEP 10   VOP[4]" );		// PROMA-3 only !!
	locate(13,1 ); cprintf( " STEP 11   VHH[1] (Pin 9-16)" );
	locate(14,1 ); cprintf( " STEP 12   VHH[2] (Pin 17-24)" );
	locate(15,1 ); cprintf( " STEP 13   VHH[3] (Pin 25-32)" );
	locate(16,1 ); cprintf( " STEP 14  VHHC[0] (Pin 28-32)" );
	locate(17,1 ); cprintf( " STEP 15   VCC[0] (Pin 28-32,34,36,40)" );
	locate(18,1 ); cprintf( " STEP 16   VCC[1] (Pin 1,5,7,9,26,27)" );
	locate(19,1 ); cprintf( " STEP 17    OTHER" );
	locate(20,1 ); cprintf( " STEP 18     USER" );


	locate(23,1 ); cprintf( "Press 'S' key to change testing step" );
	locate(24,1 ); cprintf( "Press <CR> back to main menu" );

	while( !done )
	{
		locate( 3+step, 1 );

		switch( step )
		{
		case 0: setport( TTLID, 0, 0 ); break;
		case 1: setport( TTLID, 1, 0 ); break;
		case 2: setport( TTLID, 2, 0 ); break;
		case 3: setport( TTLID, 3, 0 ); break;
		case 4: setport( TTLID, 4, 0 ); break;

		case 5: setport( VOPENID, 0, 0 ); break;
		case 6: setport( VOPENID, 1, 0 ); break;
		case 7: setport( VOPENID, 2, 0 ); break;
		case 8: setport( VOPENID, 3, 0 ); break;
		case 9: setport( VOPENID, 4, 0 ); break;

		case 10:setport( VHHENID, 1, 0 ); break;
		case 11:setport( VHHENID, 2, 0 ); break;
		case 12:setport( VHHENID, 3, 0 ); break;

		case 13:setport( VHHENCID,0, 0 ); break;

		case 14:setport( VCCENID, 0, 0 ); break;
		case 15:setport( VCCENID, 1, 0 ); break;

		case 16:setport( OTHERENID, 0, 0 ); break;

		case 17:setport( USERBITS,0, 0 ); break;
		}

		if( kbhit() )
		{
			switch( toupper( getch() ) )
			{
			case 0: getch(); break;

			case CR:
			case LF:
			case ESC: done = 1; break;

			case 'S':
				if( ++step == 21 )
					step = 0;
				break;
			}
		}
	}
}

/*==============================================================*/
void bittest( void )
{
	int done = 0, step = 0;

	textattr( ( CYAN << 4 ) + WHITE ); clscrn( 0,0, 24,79 );

	textattr( ( BLUE << 4 ) + WHITE );
	locate( 0,3 ); cprintf( " BIT POSITION TEST ");
	textattr( ( CYAN << 4 ) + WHITE );

	locate( 1,1 ); cprintf( " STEP      OTHER-BIT" );
	locate( 2,1 ); cprintf( "--------------------------------------" );
	locate( 3,1 ); cprintf( " STEP %d   OTHER.%d (Pin )", step+1, step );


	locate(23,1 ); cprintf( "Press 'S' key to change testing step" );
	locate(24,1 ); cprintf( "Press <CR> back to main menu" );

	while( !done )
	{
		setport( OTHERENID, 0, 1<<step );

		if( kbhit() )
		{
			switch( toupper( getch() ) )
			{
			case 0: getch(); break;

			case CR:
			case LF:
			case ESC: done = 1; break;

			case 'S':
				if( ++step == 8 )
					step = 0;
				break;
			}
		}
	}
}

/*=========================================================*/
int main( void )
{
	int ch = 0, loop = 1;

	/*---------------------------------------------------------*/
	/* main program realy start here                           */
	/*---------------------------------------------------------*/
	while( TRUE )
	{
		init_hw();
		initdacs();

		textattr( ( LIGHTGRAY << 4 ) | YELLOW ); clscrn( 0,0, 24,79 );

		locate( 0,0 ); cprintf( "Universal    Programmer" );
		locate( 1,0 );
		if( PROMA3 == 1 )	cprintf( "MODEL: PROMA-3 " );
		else				cprintf( "MODEL: PC Based" );
		locate( 2,0 ); cprintf( PROGNAME );

		showvals();

		textattr( ( CYAN << 4 ) | WHITE ); clscrn( 3,0, 23,38 );

		locate( 3,0 ); cprintf( "------------  Main Menu  -------------" );
		locate( 4,0 ); cprintf( "A. Change I/O base address            " );
 		locate( 5,0 ); cprintf( "T. Change prgrammer type              " );
		locate( 6,0 ); cprintf( "                                      " );
		locate( 7,0 ); cprintf( "   Bottom board test program :        " );
		locate( 8,0 ); cprintf( "                                      " );
		locate( 9,0 ); cprintf( "P. Power supply    V. Voltage adjust  " );
		locate(10,0 ); cprintf( "                                      " );
		locate(11,0 ); cprintf( "   Test-socket test program :         " );
		locate(12,0 ); cprintf( "                                      " );
		locate(13,0 ); cprintf( "G. GND pin test    C. VCC pin test    " );
		locate(14,0 ); cprintf( "H. VHH pin test    O. VOP pin test    " );
		locate(15,0 ); cprintf( "I. I/O pin test    X. Extra pin test  " );
		locate(16,0 ); cprintf( "                                      " );
		locate(17,0 ); cprintf( "D. Demuxer test    B. OTHER Bit Test  " );
		locate(18,0 ); cprintf( "                                      " );
		locate(19,0 ); cprintf( "Q. Quit                               " );
		locate(20,0 ); cprintf( "--------------------------------------" );
		locate(21,0 ); cprintf( "WARNING : Don't place any device      " );
		locate(22,0 ); cprintf( "          into the test-socket !      " );

		for( loop = 1; loop; )
		{
			textattr( ( BLUE << 4 ) + WHITE ); clscrn( 24,0, 24,38 );

			locate( 24,0 ); cprintf( "Select function ?" );

			for(;;)
			{
				if( ( ch = getch() ) != 0 )
					break;
				getch();						 /* neglect extended code */
			}

			switch( ch = toupper(ch) )
			{
			case 'A': set_io_adr(); loop = 0; break;	// change i/o address

			case 'P': power_menu(); break;
			case 'V': adj_menu(); break;
			case 'T': PROMA3 ^= 1; loop = 0; break;

			case 'I': iotest(); break;
			case 'X': xtratest(); break;

			case 'D': muxtest(); break;
			case 'B': bittest(); break;
		   
			case 'G': gndtest(); break;
			case 'C': vcctest(); break;
			case 'H': vhhtest(); break;
			case 'O': voptest(); break;
			}

			initio();
			initdacs();

			if( ch == 'I' || ch == 'X' )
				break;

			if( ch == 'Q' )
				return( 0 );

			textattr( ( LIGHTGRAY << 4 ) | YELLOW ); clscrn( 10,40, 24,79 );
		}
	}
}
