#ifdef _WIN32
#include <windows.h>
#define huge
#define delay(a)	Sleep(a)
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>
#include <string.h>
#include <alloc.h>

typedef unsigned char  byte;
typedef unsigned short word;
typedef unsigned long  dword;

/*************************************/
/* ALL-03 Hardware I/O Configuration */
/*************************************/

#define TTLID		0xE0	/* 0xE0 .. 0xE4 select group for I/O */
							/* 0xE0 : Pin 1- 8 */
							/* 0xE1 : Pin 9-15 */
							/* 0xE2 : Pin16-23 */
							/* 0xE3 : Pin24-31 */
							/* 0xE4 : Pin32-40 */

#define VOPID		0xE5	/* 10.2V .. 25.50V @  0.10V/step (max. 400mA) */
#define VOPDROP		6		/*  0.6V = 6 steps */

#define VHHID		0xE6	/*  5.1V .. 15.30V @  0.06V/step (max. 400mA) */
#define VHHDROP		10		/*  0.6V = 10 steps */

#define VCCID		0xE7	/*  0.0V .. 10.24V @  0.04V/step (max. 1000mA) */
#define VCCDROP		15		/*  0.6V = 15 steps */

#define VOPENID		0xE8	/* select group for VOP (via 22 Ohm) */
							/* 0xE8 DATA.0-7 :  1,xx,xx,xx, 5,xx, 7,xx */
							/* 0xE9 DATA.0-7 :  9,10,11,12,13,14,15,16 */
							/* 0xEA DATA.0-7 : 17,18,19,20,21,22,23,24 */
							/* 0xEB DATA.0-7 : 25,26,27,28,29,30,31,32 */
							/* 0xEC DATA.0-7 : xx,xx,xx,36,xx,xx,xx,xx */

#define VCCENID		0xED	/* select group for VCC (directly) */
							/* 0xED DATA.0-7 : 40,36,34,32,31,30,29,28 */
							/* 0xEE DATA.0-7 : 27,26, 9, 7, 5, 1,xx,xx */

#define OTHERENID	0xEF	/* 0xEF.0 > A */							/* A B C Function */
							/* 0xEF.1 > 1:Pin7 =VOP(source-2.4V) */		/* 0 0 0 Pin20=GND */
							/* 0xEF.2 > 1:Pin25=VOP(source-2.4V) */		/* 1 0 0 Pin11=GND */
							/* 0xEF.3 > 1:Pin2 =OSC,Pin3 =!OSC */		/* 0 1 0 Pin1 =GND */
							/* 0xEF.4 > 1:Pin18=OSC,Pin19=!OSC */		/* 1 1 0 Pin22=GND */ 
							/* 0xEF.5 > 1:4MHz, 0:2MHz */				/* 0 0 1 Pin28=GND */ 
							/* 0xEF.6 > B */							/* 1 0 1 Pin40=GND */ 
							/* 0xEF.7 > C */							/* 0 1 1 Pin30=GND */ 
                                                                        /* 1 1 1 Pin29=GND */ 
#define VHHENID		0xF0	/* select group for VHH (via 22 Ohm) */
							/* 0xF0 DATA.0-7 : xx,xx,xx,xx,xx,xx,xx,xx */
							/* 0xF1 DATA.0-7 :  9,10,11,12,13,14,15,16 */
							/* 0xF2 DATA.0-7 : 17,18,19,20,21,22,23,24 */
							/* 0xF3 DATA.0-7 : 25,26,27,28,29,30,31,32 */
							/* 0xF4 DATA.0-7 : xx,xx,xx,xx,xx,xx,xx,xx */

#define VHHENCID	0xF5	/* select group for VHH (directly) */ 
							/* 0xF5 DATA.0-7 : xx,xx,xx,32,31,30,29,28 */
							/* 0xF6 DATA.0-7 : xx,xx,xx,xx,xx,xx,xx,xx */

#define USERBITS	0xF7	/* BUSY / GOOD LED */
							/* 0xF7.3 > 1:'GOOD' LED on */

#define CODEID		0xF8	/* read programmer ID (4 LSBs only)*/

/* ASCII key code define */
#define BEL			'\x07'
#define BS			'\x08'
#define CR			'\x0d'
#define LF			'\x0a'
#define ESC			'\x1b'

#define TRUE		1
#define FALSE		0

#define VIDEO		0x10	/* INT 10H */

#ifdef ZEN_TIMER

extern void initclk(void);
extern void dly1u(void);
extern void dly10u(void);
extern void dly20u(void);
extern void dly50u(void);
extern void dly100u(void);
extern void dly200u(void);
extern void dly500u(void);
extern void dly1m(void);
extern void dly2m(void);
extern void dly5m(void);
extern void dly10m(void);
extern void dly20m(void);
extern void dly50m(void);

extern word FACT1U, FACT10U, FACT20U, FACT50U;
extern word FACT100U,FACT200U,FACT500U;
extern word FACT1M,  FACT2M,  FACT5M;
extern word FACT10M, FACT20M, FACT50M;

#else

#include "timer.h"
#define dly1u()		us_delay(1)
#define dly10u()	us_delay(10)
#define dly20u()	us_delay(20)
#define dly50u()	us_delay(50)
#define dly100u()	us_delay(100)
#define dly200u()	us_delay(200)
#define dly500u()	us_delay(500)
#define dly1m()		us_delay(1000)
#define dly2m()		us_delay(2000)
#define dly5m()		us_delay(5000)
#define dly10m()	us_delay(10000)
#define dly20m()	us_delay(20000)
#define dly50m()	{us_delay(25000); us_delay(25000);}

#endif

#define waitms(time)	delay(time)		/* time delay 1 ms resolution */

#ifdef _WIN32
extern void outp( word portaddr, byte value );
extern byte inp( word portaddr );
#endif

#define locate(y,x)		gotoxy((x)+1,(y)+1)
extern void clscrn ( int y1, int x1, int y2, int x2 );
extern int  dbl;
extern void _window ( int y1, int x1, int y2, int x2 );
extern void frame( int y1, int x1, int y2, int x2 );
extern int  getline( char *s, int lim );
extern void errbeep( void );
extern void bindsp2( int data );

extern void setport( int id, int off, int data );
extern int  getport( int id, int off );
extern void setdac ( int which, int data );
extern void setdac_raw ( int which, int data );
extern int  setpin ( int pin, int voltage, int state );
extern int  getpin ( int pin );
extern void setother( int bit, int state );

extern int VCC, VHH, VOP;

extern int idport;

extern void init_hw( void );
extern void initio( void );
extern void initdacs( void );
extern void set_io_adr( void );

extern word Chks;
extern dword read_bin( char *filename, dword addr );
extern dword read_intel( char *filename, dword addr );
extern dword read_motorola( char *filename, dword addr );

extern char path[260], oldpath[260];
extern int xgets( char *str );
extern int load_file( void );
extern void save_file( void );

extern long BufStart;
extern long BufEnd;
extern long bufsize;
extern unsigned char huge *buffer;
extern char buffile[80];

extern int mfrno, devno;
extern void ReadConfig( void );
extern void WriteConfig( void );

void dos_shell( char *cmd );
void edit_buffer( void );
void disp_buffer( void );
