#include "all03.h"

#define _RST	11
#define _RDY	13
#define _XTAL	15
#define _PROG	16
#define _GND	20
#define _VCC	30

in main( int ac, char *av[] )
{
	FILE *bin;
	unsigned addr = 0;
	int i;

	bin = fopen( av[1], "rb" );
	if( bin == NULL )
	{
		puts( "Cant open input" );
		return -1;
	}

	initclk();
	inithw();

	// we dont need VHH
	setdac( VHHID, 0 );						// VHH = 0V
	for( i = 0; i <= 4; ++i )
		setport( VHHENID, i, 0 );			// no VHH
	setport( VHHENCID,0, 0 );				// no VHHC
	setport( VHHENCID,1, 0 );				// no VHHC

	setport( OTHERENID, 0, 0 );				// Pin 20 = GND

	// Set all pins LOW
	for( i = 1; i <= 40; ++i )
		setpin( i, TTLID, 0 );

	setpin( _VCC, TTLID, 1 );				// apply Vcc
	setpin( _VCC, VCCENID, 1 );

	setdac( VCCID, voltage );				// Vcc = xV
	delay( 100 );							// wait to stabilize

	setdac( VOPID, 120 );					// Vpp = 12V

	setpin( _PROG, TTLID, 1 );				// PROG = H
	setpin( _RST, TTLID, 1 );				// RST = H

	delay( 1 );

	MODE = 

	while( ( val = getc( bin ) ) != -1 )
	{
		setport( TTLID, 2,
			( MODE & 7 ) | ( (MODE & 8) <<1 ) |		// Pins 17,18,19, 21=MODE
			( ( val & 7 ) << 5 ) );					// Pins 22,23,24=DATA0..2
		setport( TTLID, 3, ( val >> 3 ) | 32 ) );	// Pins 25..29=DATA3..7, 30=VCC

		setpin( _PROG, TTLID, 0 );			// PROG = L
		setpin( _PROG, TTLID, 1 );			// PROG = H

		while( !getpin( _RDY ) )			// while busy programming
			;								// 2ms typically

		setpin( _XTAL, TTLID, 1 );			// XTAL = H advance addr
		setpin( _XTAL, TTLID, 0 );			// XTAL = L
	}
