#include "all03.h"

long start = 0, end = 0, dest = 0;
static char cmd[80], *pos;
static FILE *f = NULL;

void dos_shell( char *cmd )
{
	textattr( LIGHTGRAY ); clrscr();
	printf( "Type EXIT to return to Programmer menu\n" );
	system( cmd );
}

static void displine( long addr )
{
	int i, c;
	unsigned char buf[16];

	if( buffer )
		memcpy( buf, (void far *)(buffer+addr), 16 );
	else
	{
		fseek( f, addr, SEEK_SET );
		fread( buf, 1, 16, f );
	}

	cprintf( "%05lX  ", addr );
		
	for( i = 0; i < 8; ++i )
		cprintf( "%02X ", buf[ i ] );

	cprintf( "--" );
		
	for( i = 8; i < 16; ++i )
		cprintf( "%02X ", buf[ i ] );

	for( i = 0; i < 16; ++i )
		putch( isprint( c = buf[ i ] ) ? c : '.' );

	cprintf( "\r\n" );
}

static void dispbuf( void )
{
	int c;

	cprintf( "Press <ESC> to terminate display\n\r\n" );
	delay( 500 );

	while( start <= end )
	{
		if( kbhit() )
		{
			if( ( c = getch() ) == 0x1B )
				break;
			else if( c == 0 )
				getch();
		}
		displine( start ); start += 16;
	}
}

void disp_buffer( void )
{
	textattr( ( CYAN << 4 ) + WHITE ); clrscr();

	start = 0; end = bufsize; dispbuf();

	cprintf( "Press any key to continue" );
	if( getch() == 0 ) getch();
}

static unsigned char xval( char c )
{
	if( ( c = toupper( c ) ) > '9' )
		return c - 'A' + 10;
	else
		return c - '0';
}

static void hexedit( void )
{
	int i, c, loop, changed = 0;
	long addr, top = start, lasttop = -1L;
	int ascii = 0, right = 0, curx = 0, cury = 0;

	textattr( ( CYAN << 4 ) + WHITE ); clrscr();

	for( ;; )
	{
		if( top != lasttop )
		{
			lasttop = top;
			changed = 0;

			locate( 0,0 );
			for( addr = top; addr < top + 24*16; addr += 16 )
				if( addr < start + bufsize )
					displine( addr );

			textattr( ( BLUE << 4 ) + WHITE ); clreol();
			cprintf( " [ESC]: Back to command prompt, [TAB]: Toggle entry mode, [ALT-G] Goto address" );
			textattr( ( CYAN << 4 ) + WHITE );
		}
		else if( changed )
		{
			changed = 0;
			c = !curx ? cury-1 : cury;		// check for wrap
			locate( c, 0 );
			displine( top + 16*c );
		}

		locate( cury, !ascii ? ( (curx<8) ? 7:9 ) + 3*curx + right : 57+curx );

		for( loop = 1; loop; )
		{
			switch( c = getch() )
			{
			case 0:
				switch( getch() )
				{
				case 34:	// ALT-G
					locate( 24,0 );
					textattr( ( BLUE << 4 ) + WHITE ); clreol();
					cprintf( "Enter Address:" );
					cmd[0] = 79; xgets( cmd );
					textattr( ( CYAN << 4 ) + WHITE );

					sscanf( cmd+2, "%X", &addr );
					if( addr >= start && addr < start + bufsize )
					{
						top = addr & 0xFFF00L;
						if( top > start + bufsize - 24*16 )
							top = start +bufsize - 24*16;
						if( top < 0 )
							top = 0;
						curx = (int)(addr & 0x0F); right = 0;
						cury = (int)((addr - top) >> 4);
						loop = 0;
						lasttop = -1L;
					}
					break;

				case 71:	// HOME
					curx = cury = 0;
					top = start;
					loop = 0;
					break;

				case 79:	// END
					curx = 15; cury = 23;
					top = start + bufsize - 24*16;
					if( top < 0 ) top = 0;
					loop = 0;
					break;

				case 75:	// LEFT
					if( !ascii && right )
					{
						right = 0;
						loop = 0;
						break;
					}
					right = 1;
					if( curx )
					{
						--curx;
						loop = 0;
						break;
					}
					curx = 15;
					loop = 0;
					
					// fall through

				case 72:	// UP
					if( cury == 0 )
					{
						if( top > start )
						{
							loop = 0;
							top -= 16;
						}
					}
					else
					{
						loop = 0;
						--cury;
					}
					break;

				case 77:	// RIGHT
Advance:			if( !ascii && !right )
					{					
						right = 1;
						loop = 0;
						break;
					}
					right = 0;
					if( curx < 15 )
					{
						++curx;
						loop = 0;
						break;
					}
					curx = 0;
					loop = 0;

					// fall through

				case 80:	// DOWN
					if( cury < 23 )
					{
						loop = 0;
						++cury;
					}
					else if( top < start + bufsize - 24*16 )
					{
						loop = 0;
						top += 16;
					}
					break;

				case 73:	// PGUP
					if( top >= start + 24*16 )
					{
						top -= 24*16;
						if( top < 0 ) top = 0;
						loop = 0;
					}
					else if( top != start )
					{
						loop = 0;
						top = start;
					}
					break;

				case 81:	// PGDN
					if( top + 24*16 <= start + bufsize - 24*16 )
					{
						top += 24*16;
						loop = 0;
					}
					else if( top != start + bufsize - 24*16 )
					{
						top = start + bufsize - 24*16;
						if( top < 0 ) top = 0;
						loop = 0;
					}
					break;
				}
				break;

			case 0x1B: locate( 24, 0 ); clreol(); return;

			case 0x09: ascii ^= 1; loop = 0; break;

			default:
				addr = top + 16*cury + curx;

				if( !ascii )
				{
					if( isxdigit( c ) )
					{
						loop = 0;
						changed = 1;
						if( !right )
						{
							right = 1;
							if( buffer )
								buffer[addr] = ( buffer[addr] & 0x0F ) | ( xval(c) << 4 );
							else
							{
								fseek( f, addr, SEEK_SET ); i = getc( f );
								i = ( i & 0x0F ) | ( xval(c) << 4 );
								fseek( f, addr, SEEK_SET ); putc( i, f );
							}
						}
						else
						{
							if( buffer )
								buffer[addr] = ( buffer[addr] & 0xF0 ) | xval(c);
							else
							{
								fseek( f, addr, SEEK_SET ); i = getc( f );
								i = ( i & 0xF0 ) | xval(c);
								fseek( f, addr, SEEK_SET ); putc( i, f );
							}
							goto Advance;
						}
					}
				}
				else
				{
					changed = 1;
					loop = 0;
					if( buffer )
						buffer[addr] = c;
					else
					{
						fseek( f, addr, SEEK_SET ); putc( c, f );
					}
					goto Advance;
				}
				break;
			}
		}
	}
}

static void split( void )
{
	end = dest = -1L;

	if( ( pos = strtok( pos, ", \t\n\r" ) ) != NULL )
		sscanf( pos, "%X", &start );
	if( ( pos = strtok( NULL, ", \t\n\r" ) ) != NULL )
		sscanf( pos, "%X", &end );
	if( ( pos = strtok( NULL, ", \t\n\r" ) ) != NULL )
		sscanf( pos, "%X", &dest );

	start &= 0xFFFF0L;
	if( end == -1L ) end = start + 0x7F;
}

void edit_buffer( void )
{
	int redraw, i, l;
	unsigned char str[16];
	unsigned Ck;
	long x;

	if( !buffer && ( f = fopen( buffile, "rb+" ) ) == NULL )
		return;

	textattr( ( CYAN << 4 ) + WHITE ); clrscr();

	for(;;)
	{
		cprintf( "\n\r            EDITING COMMAND SUMMARY\n\r" );
		cprintf( "D [start],[end]         <RETURN> : DUMP\n\r" );
		cprintf( "E start                 <RETURN> : EDIT\n\r" );
		cprintf( "M start,end,destination <RETURN> : MOVE BLOCK\n\r" );
		cprintf( "F start,end,data        <RETURN> : FILL BLOCK\n\r" );
		cprintf( "P start,end             <RETURN> : PRINT BLOCK\n\r" );
		cprintf( "C start,end             <RETURN> : CHECK SUM\n\r" );
		cprintf( "S start,end,ASCII data  <RETURN> : ASCII SEARCH MAX. 15 characters\n\r" );
		cprintf( "B start,end,BINARY data <RETURN> : BINARY SEARCH MAX. 7 BYTEs\n\r" );
		cprintf( ". filename [args]*      <RETURN> : SHELL\n\r" );
		cprintf( "?                       <RETURN> : HELP\n\r" );
		cprintf( "Q                       <RETURN> : QUIT\n\r" );
		cprintf( "=========================================\n\r" );

		for( redraw = 0; !redraw; )
		{
			cprintf( "\r\n\==" ); cmd[0] = 79; xgets( cmd ); cprintf( "\n\r" );

			if( cmd[1] == 0 )
				continue;

			i = toupper( cmd[2] );

			for( pos = cmd+3; isspace(*pos); ++pos );

			switch( i )
			{
			case 'Q':	if( !buffer )
						{
							fseek( f, bufsize, SEEK_SET );
							fclose( f );
						}
						return;
			case '?':	redraw = 1; break;
			case '.':	system( pos ); break;
			case 'D':	split(); if( end == -1L ) end = start + 0x7F;
						dispbuf();
						break;
			case 'E':	start = 0L; split(); hexedit(); break;
			case 'M':	split();
						if( start != -1L && end != -1L && dest != -1L )
						{
							if( buffer )
							{
								memcpy( (char far *)(buffer+dest),
										(char far *)(buffer+start),
										(unsigned)(end-start+1) );
							}
							else
							{
								for( x = 0; x <= end-start; ++x )
								{
									fseek( f, start+x, SEEK_SET ); i = getc(f);
									fseek( f, dest+x, SEEK_SET ); putc(i,f);
								}
							}
						}
						break;
			case 'F':	split();
						if( start != -1L && end != -1L && dest != -1L )
						{
							if( buffer )
							{
								memset( (char far *)(buffer+start),
										(unsigned char)(dest & 0xFF),
										(unsigned)(end-start+1) );
							}
							else
							{
								dest &= 0xFF;
								fseek( f, start+x, SEEK_SET );
								for( x = 0; x <= end-start; ++x )
									putc( dest, f );
							}
						}
						break;
			case 'C':	split();
						if( start != -1L && end != -1L )
						{
							Ck = 0;
							if( !buffer ) fseek( f, start+x, SEEK_SET );
							for( x = start; x <= end; ++x )
								Ck += ( buffer ? buffer[x] : getc(f) );
							cprintf( "%04X", Ck );
						}
						break;
			case 'S':	split();
						if( start != -1L && end != -1L && pos && buffer )
						{
							l = strlen( pos );
							cprintf( "%05lX-%05lX: '%s'\n\r", start, end, pos );
							for( x = start; x <= end-l+1; ++x )
							{
								if( !strncmpi( (char far *)(buffer+x), pos, l ) )
									cprintf( "%05lX\n\r", x );
							}
						}
						break;
			case 'B':	split();
						if( start != -1L && end != -1L && dest != -1 && buffer )
						{
							str[0] = dest; l = 1;
							while( ( pos = strtok( NULL, ", \t\n\r" ) ) != NULL )
								sscanf( pos, "%x", &str[l++] );
							cprintf( "%05lX-%05lX: ", start, end );
							for( i = 0; i < l; ++i )
								cprintf( "%02X ", str[i] );
							cprintf( "\n\r" );
							for( x = start; x <= end-l+1; ++x )
							{
								if( !memcmp( (char far *)(buffer+x), str, l ) )
									cprintf( "%05lX\n\r", x );
							}
						}
						break;
			}
		}
	}
}
