#include "all03.h"

void ReadConfig( void )
{
	FILE *f;
	char tmp[81];

	idport = 0x2E0;
	mfrno = devno = 0;

	strcpy( tmp, strrchr( _argv[0], '\\' ) + 1 );
	strcpy( strrchr( tmp, '.' ), ".DAT" );

	if( ( f = fopen( tmp, "r" ) ) == NULL )
		return;

	/*------------------------------------------------------------------*/
	if( fgets( tmp, 80, f ) )			// PORTADDR
	{
		sscanf( tmp, "%x", &idport );
		if( idport < 0 || idport > 15 )
			idport = 0x0E;
		idport = 0x200 | ( idport << 4 );
	}
	/*------------------------------------------------------------------*/
	if( fgets( tmp, 80, f ) )			// MFR
		sscanf( tmp, "%x", &mfrno );
	/*------------------------------------------------------------------*/
	if( fgets( tmp, 80, f ) )			// DEV
		sscanf( tmp, "%x", &devno );
	fclose( f );
}

void WriteConfig( void )
{
	FILE *f;
	char tmp[81];

	strcpy( tmp, strrchr( _argv[0], '\\' ) + 1 );
	strcpy( strrchr( tmp, '.' ), ".DAT" );

	if( ( f = fopen( tmp,"w" ) ) == NULL )
		return;

	fprintf( f, "%X\n", (idport >> 4) & 15 );	// IOBASE
	fprintf( f, "%d\n", mfrno );				// MFR
	fprintf( f, "%d\n", devno );				// DEV
	fprintf( f, "0\n" );						// ALGO
	fprintf( f, "0\n" );						// ??

	fclose( f );
}


