#include "all03.h"

int dbl = 0;

void clscrn( int y1, int x1, int y2, int x2 )
{
	window( x1+1, y1+1, x2+1, y2+1 );
	clrscr();
	window( 1,1, 80,25 );
}

/*--------------------------------------------------------------*/
void frame( int y1, int x1, int y2, int x2 )	/* window frame drawing */
{
	int i, ch;

	locate( y1,x1 ); putch( dbl ? 0xC9 : 0xDA );	/* uplf */
	locate( y1,x2 ); putch( dbl ? 0xBB : 0xBF );	/* uprt */
	locate( y2,x1 ); putch( dbl ? 0xC8 : 0xC0 );	/* lolf */
	locate( y2,x2 ); putch( dbl ? 0xBC : 0xD9 );	/* lort */

	locate( y1,x1+1 ); ch = dbl ? 0xCD : 0xC4;		/* horbar */
	for( i = x1+1; i < x2; ++i ) putch( ch );

	locate( y2,x1+1 ); ch = dbl ? 0xCD : 0xC4;		/* horbar */
	for( i = x1+1; i < x2; ++i ) putch( ch );

	ch = dbl ? 0xBA : 0xB3;							/* vrtbar */
	for( i = y1+1; i < y2; ++i )
	{
		locate( i,x1 ); putch( ch );
		locate( i,x2 ); putch( ch );
	}
}

/*--------------------------------------------------------------*/
void _window( int y1, int x1, int y2, int x2 )	/* window drawing */
{
	clscrn( y1, x1, y2, x2 );
	frame( y1, x1, y2, x2 );
}

/*-------------------------*/
/* get 1 line from console */
int getline( char *s,		/* return length, NULL len=1 */
			 int lim )		/* max key include newline */
{
	int ch, i = 0;

	while( ( ch = getch() ) != CR && ch != ESC )
	{
		if( !ch )					/* extended key neglect next code */
			getch();
		else if( ch == BS && i )
		{
			--i;
			putch(ch);
			putch(' ');
			putch(ch);
		}
		else if( !iscntrl(ch) )
		{
			if( i < lim-1 )			/* non control key */
				putch( s[i++] = ch );
			else
				putch( BEL );
		}
	}

	if( ch == ESC )
	{
		s[0] = ch;
		i = 1;
	}

	s[i] = 0;
	return( i );
}

/*--------------------------------------------------------------*/
void errbeep( void )				/* error 3 beep */
{
	int i;

	for( i = 0; i < 3; ++i )
	{
		putch( BEL ); waitms( 63 );
	}
}

/*--------------------------------------------------------------*/
void bindsp2( int data )
{
	unsigned char i = 1;

	while( i )
	{
		cprintf( ( data & i ) ? "1  " : "0  " );
		i <<= 1;
	}
}

