#include <stdio.h>

enum ACCGRP { EPROM=1,EEPROM=2,SERPROM=3,BPROM=4,MPU=5,PLD=6 };

typedef struct {
	int AccGrp;			/* device type group (see above) */
	int AccPrg;			/* name of programmmer EXE to use */
	int AccMfgr;		/* offset of manufacturer in the list (0 based) */
	int ProgMfgr;		/* manufacturer # within Programmer EXE */
	char Name[16];		/* device name */
	int ProgType;		/* device type # within Programmer EXE */
	int Algo;			/* programming algorithm */
	int AccVpp;			/* Vpp (in 0.25V steps) for display by ACCESS */
	char Adp[20];		/* name of adapter to use (0 if none) */
} DEV;

/* DEVICE.DAT structure */

int NumExes;			/* Number of EXEs */
int NumMfgrs;			/* Number of Manufacturers */
int NumDevs;			/* Number of devices */
int Unk1;				/* ??? */
int Unk2;				/* ??? */
int Unk3;				/* ??? */
char *exes[NumExes];	/* i.e. 'EPP1024W=1.00' is exename and version */
char *mfrs[NumMfgrs];	/* i.e. 'ATMEL' */
DEV devs[NumDevs];		/* i.e. '1,97,9,2,AT32C16,0,4,0,0' means */
						/* 1: device group 1 -> EPROM */
						/* 97:98th entry in exes[] */
						/* 9: 10th entry in mfrs[] */
						/* 2: EPP1024W.DAT line 2 = 2 (mfr# for EXE) */
						/* 'AT32C16' device name */
						/* 0: EPP1024W.DAT line 3 = 0 (dev# for EXE) */
						/* 4: EPP1024W.DAT line 4 = 4 (algo# for EXE) */
						/* 0: VPP (0 -> not shown in ACCESS) */
						/* 0: no adapter needed */

/* in DEVs following sort order applies: */
/* ------------------------------------- */
/* 1st: devicegroup */
/* 2nd: manufacturer */
/* 3rd: devicename (alphanumerical) */

/* xxxxx.DAT structure */
char addr;				/* 0..F : 0x200 + addr*16 (device base address) */
int mfg;				/* mfr# within exe */
int dev;				/* dev# within exe */
int algo;				/* algorithm # within exe */

