#include "all03.h"

static int pwron = FALSE;
static int cardok= FALSE;

int idport = 0x2E0;

/*==============================================================*/
void initio( void )
{
	int i;

	for( i = 0; i < 5; ++i )
	{
		setport( TTLID, i, 0xFF );		/* TTL high level on all pins */ 
		setport( VOPENID, i, 0 );		/* no VOP */
		setport( VHHENID, i, 0 );		/* no VHH */
	}

	for( i = 0; i < 2; ++i )
	{
		setport( VCCENID, i, 0 );		/* no VCC */
		setport( VHHENCID, i, 0 );		/* no VHHC */
	}

	setport( OTHERENID, 0, 0 );			/* no specials */
}

/*==============================================================*/
void initdacs( void )
{
	setdac( VOPID, 0 );
	setdac( VHHID, 0 );
	setdac( VCCID, 0 );
}

/*==============================================================*/
int chkid( int count, int value )
{
	int i;

	setport( VCCID, 0, 0x00 );
	setport( VCCID, 0, 0x01 );			/* B0 : reset code */

	setport( VCCID, 0, 0x00 );
	setport( VCCID, 0, 0x02 );			/* B1 : enable clock */

	for( i = 0; i < count; ++i )
	{
		setport( VCCID, 0, 0x03 );		/* B0 : clock */
		setport( VCCID, 0, 0x02 );
	}

	setport( VCCID, 0, 0x00 );

	return( ( getport( CODEID, 0 ) & 0x0F ) != ( value & 0x0F ) );
}

/*==============================================================*/
void set_io_adr( void )
{
	int ioadrno = ( idport - 0x200 ) / 16; // 0-f: 200-2f0 io base of SAC-101
	int i,ch;

	textattr( ( CYAN << 4 ) + WHITE ); _window( 10,40, 23,79 );

	for( i = 0; i < 8; ++i )
	{
		locate( 11+i, 42 ); cprintf( "%X. %3X", i,   0x200 + 16*i );
		locate( 11+i, 60 ); cprintf( "%X. %3X", i+8, 0x200 + 16*(i+8) );
	}

	locate( 19, 42 ); cprintf( "<CR> back to main menu." );

	locate( 10,43 );
	textattr( ( BLUE << 4 ) + WHITE ); cprintf( " CHANGE I/O BASE ADDRESS " );

	while( TRUE )
	{
		textattr( ( CYAN << 4 ) + WHITE ); clscrn( 20,41, 22,78 );
		
		locate( 20,41 ); cprintf( "Current I/O base-addr.: %hX", idport );

		locate( 21,42 );
		if( cardok == TRUE )
		{
			textattr( ( CYAN << 4 ) + WHITE );
			cprintf( "   --- Programmer   exists ---   " );
		}
		else
		{
			textattr( ( RED << 4 ) + WHITE );
			cprintf( "--- Programmer does not exist ---" );
		}
		
		textattr( ( CYAN << 4 ) + WHITE );
	
		locate( 22,41 ); cprintf( "Select number ? " );

		while( (ch=getch()) == '\0' )
			getch();

		if( ch==CR || ch==LF || ch==ESC )
		{
			clscrn( 10,40, 23,79 );
			break;
		}

		if( ( ch = toupper(ch) ) >= '0' && ch <= '9' )
			ioadrno = ch - '0';
		else if( ch >= 'A' && ch <= 'F' )
			ioadrno = ch - 'A' + 10;

		idport = 0x200 + 16 * ioadrno;
		
		initio();

		if(	chkid( 31, 0x07 ) ||
			chkid( 23, 0x02 ) ||
			chkid(  3, 0x0b ) ||
			chkid( 22, 0x09 ) ||
			chkid( 11, 0x08 ) )
			cardok = FALSE;
		else
			cardok = TRUE;
	}
}

/*==============================================================*/
void init_hw( void )
{
	int ch;

	if( pwron == FALSE )
	{
		initclk();				/* check system clk */
	
		initio();
  
		if(	chkid( 31, 0x07 ) ||
			chkid( 23, 0x02 ) ||
			chkid(  3, 0x0b ) ||
			chkid( 22, 0x09 ) ||
			chkid( 11, 0x08 ) )
		{
			textattr( LIGHTRED ); clscrn( 0,0, 24,79 );

			locate(10,0 ); cprintf( "Error identifying hardware!" );

			locate(12,0 ); cprintf( "(May be a mismatch between DIPSW position on" );
			locate(13,0 ); cprintf( "the IF card and I/O baseadr. in the software)" );
			locate(14,0 ); cprintf( "Press <Q> to Quit or" );
			locate(15,0 ); cprintf( "press <CR> to continue ..." );
    
			for(;;)
			{
				while( ( ch = getch() ) == 0 )
					getch();

				if( ch == 'q' || ch == 'Q' )
					exit(0);
				if( ch == CR || ch == LF )
				{
					pwron = TRUE;
					return;
				}
			}
		}
		else
		{
			pwron = TRUE;
			cardok = TRUE;			/* card exist*/
		}
	}
}
