
#include "all03.h"

#define _RST	9
#define _RDY	10
#define _GND	20
#define _PSEN	29
#define _PROG	30
#define _VPP	31
#define _VCC	40

void Usage( void )
{
	puts(	"PGM89S8253 v1.0 (c)2006 A-Z-E\n"
			"Usage: PGM89S825 [-e] {binfile}\n"
			"where:\n"
			"-e  erase before programming" );
	
	exit( -1 );
}

int main( int ac, char *av[] )
{
	FILE *bin;
	unsigned addr = 0;
	int i, val, do_erase = 0;
	char *parm, *binfile = NULL;

	while( --ac )
	{
		if( *( parm = *++av ) == '-' || *parm == '/' )
		{
			switch( parm[1] )
			{
			case 'e':
			case 'E':
				do_erase = 1;
				break;
			}
		}
		else if( binfile == NULL )
			binfile = parm;
		else
			Usage();
	}

	if( binfile && ( bin = fopen( binfile, "rb" ) ) == NULL )
	{
		printf( "Cant open input file %s", binfile );
		return -1;
	}

	init_hw();
	initdacs();

	setport( USERBITS, 0, 0 );

	// we dont need VHH
	setdac( VHHID, 0 );						// VHH = 0V
	for( i = 0; i <= 4; ++i )
		setport( VHHENID, i, 0 );			// no VHH
	setport( VHHENCID,0, 0 );				// no VHHC
	setport( VHHENCID,1, 0 );				// no VHHC

	setport( OTHERENID, 0, 0 );				// Pin 20 = GND

	// Set all pins LOW
	for( i = 1; i <= 40; ++i )
		setpin( i, TTLID, 0 );

	setdac( VCCID, 50 );					// Vcc = 5V
	setdac( VOPID, 120 );					// Vpp(EA) = 12V
	delay( 100 );							// wait to stabilize

	setpin( _VCC, TTLID, 1 );				// apply Vcc
	setpin( _VCC, VCCENID, 1 );

	dly20u();

	setpin( _RST, TTLID, 1 );				// RST = H

	dly20u();

	setpin( _VPP, VOPID, 1 );				// VPP(EA) = VPP
	setpin( _PROG, TTLID, 1 );				// PROG(ALE) = H
	setport( TTLID, 3, 0xFF );				// P0.0-7 -> D0..7 = float

	dly20u();

	if( do_erase )
	{
		puts( "Erasing..." );
		
		setport( TTLID, 1, 0x28 | 1 );				// P3.3-7 -> mode, P3.0 -> rdy/-bsy

		setpin( _PROG, TTLID, 0 );					// PROG = L
		dly1u();									// min. 1us
		setpin( _PROG, TTLID, 1 );					// PROG = H

		dly20m();									// 8ms typically
	}

	if( !bin )
		return 0;
	
	addr = 0;
	puts( "Programming..." );

	while( addr < 0x3000 )
	{
		printf( "\rPGM %04X", addr );
		
		for( i = 0; i < 64 && ( val = getc( bin ) ) != -1; ++i )
		{
			setport( TTLID, 0, addr & 0xFF );		// P1.0-7 -> A0..7
			setport( TTLID, 2, addr >> 8 );			// P2.0-5 -> A8..13
			setport( TTLID, 1, 0xF0 | 1 );			// P3.3-7 -> PAGE_WRITE, P3.0 -> rdy/-bsy
			setport( TTLID, 3, val );				// P0.0-7 -> D0..7

			setpin( _PROG, TTLID, 0 );				// PROG = L
			dly1u();								// min. 1us
			setpin( _PROG, TTLID, 1 );				// PROG = H

			++addr;
		}
		
		dly200u();									// pgm starts 150us after last write

		while( !getpin( _RDY ) )					// while busy programming
			;										// 8ms typically
	}

	puts( "All done...!" );
	fclose( bin );
	return 0;
}

