#include "all03.h"

typedef struct {
	char offs;
	byte mask;
} PINDEF;

static PINDEF TTLPINS[40] = {			/* all pins allowed */
	{ 0, 0x01 },			/* Pin 1 */
	{ 0, 0x02 },			/* Pin 2 */
	{ 0, 0x04 },			/* Pin 3 */
	{ 0, 0x08 },			/* Pin 4 */
	{ 0, 0x10 },			/* Pin 5 */
	{ 0, 0x20 },			/* Pin 6 */
	{ 0, 0x40 },			/* Pin 7 */
	{ 0, 0x80 },			/* Pin 8 */

	{ 1, 0x01 },			/* Pin 9 */
	{ 1, 0x02 },			/* Pin 10 */
	{ 1, 0x04 },			/* Pin 11 */
	{ 1, 0x08 },			/* Pin 12 */
	{ 1, 0x10 },			/* Pin 13 */
	{ 1, 0x20 },			/* Pin 14 */
	{ 1, 0x40 },			/* Pin 15 */
	{ 1, 0x80 },			/* Pin 16 */

	{ 2, 0x01 },			/* Pin 17 */
	{ 2, 0x02 },			/* Pin 18 */
	{ 2, 0x04 },			/* Pin 19 */
	{ 2, 0x08 },			/* Pin 20 */
	{ 2, 0x10 },			/* Pin 21 */
	{ 2, 0x20 },			/* Pin 22 */
	{ 2, 0x40 },			/* Pin 23 */
	{ 2, 0x80 },			/* Pin 24 */

	{ 3, 0x01 },			/* Pin 25 */
	{ 3, 0x02 },			/* Pin 26 */
	{ 3, 0x04 },			/* Pin 27 */
	{ 3, 0x08 },			/* Pin 28 */
	{ 3, 0x10 },			/* Pin 29 */
	{ 3, 0x20 },			/* Pin 30 */
	{ 3, 0x40 },			/* Pin 31 */
	{ 3, 0x80 },			/* Pin 32 */

	{ 4, 0x01 },			/* Pin 33 */
	{ 4, 0x02 },			/* Pin 34 */
	{ 4, 0x04 },			/* Pin 35 */
	{ 4, 0x08 },			/* Pin 36 */
	{ 4, 0x10 },			/* Pin 37 */
	{ 4, 0x20 },			/* Pin 38 */
	{ 4, 0x40 },			/* Pin 39 */
	{ 4, 0x80 }				/* Pin 40 */
};

static PINDEF VOPPINS[40] = {			/* 1, 5, 7, 9-32, 36 */
	{ 0, 0x01 },			/* Pin 1 */
	{-1, 0x02 },			/* Pin 2 */
	{-1, 0x04 },			/* Pin 3 */
	{-1, 0x08 },			/* Pin 4 */
	{ 0, 0x10 },			/* Pin 5 */
	{-1, 0x20 },			/* Pin 6 */
	{ 0, 0x40 },			/* Pin 7 */
	{-1, 0x80 },			/* Pin 8 */

	{ 1, 0x01 },			/* Pin 9 */
	{ 1, 0x02 },			/* Pin 10 */
	{ 1, 0x04 },			/* Pin 11 */
	{ 1, 0x08 },			/* Pin 12 */
	{ 1, 0x10 },			/* Pin 13 */
	{ 1, 0x20 },			/* Pin 14 */
	{ 1, 0x40 },			/* Pin 15 */
	{ 1, 0x80 },			/* Pin 16 */

	{ 2, 0x01 },			/* Pin 17 */
	{ 2, 0x02 },			/* Pin 18 */
	{ 2, 0x04 },			/* Pin 19 */
	{ 2, 0x08 },			/* Pin 20 */
	{ 2, 0x10 },			/* Pin 21 */
	{ 2, 0x20 },			/* Pin 22 */
	{ 2, 0x40 },			/* Pin 23 */
	{ 2, 0x80 },			/* Pin 24 */

	{ 3, 0x01 },			/* Pin 25 */
	{ 3, 0x02 },			/* Pin 26 */
	{ 3, 0x04 },			/* Pin 27 */
	{ 3, 0x08 },			/* Pin 28 */
	{ 3, 0x10 },			/* Pin 29 */
	{ 3, 0x20 },			/* Pin 30 */
	{ 3, 0x40 },			/* Pin 31 */
	{ 3, 0x80 },			/* Pin 32 */

	{-1, 0x01 },			/* Pin 33 */
	{-1, 0x02 },			/* Pin 34 */
	{-1, 0x04 },			/* Pin 35 */
	{ 4, 0x08 },			/* Pin 36 PROMA-3 only ? */
	{-1, 0x10 },			/* Pin 37 */
	{-1, 0x20 },			/* Pin 38 */
	{-1, 0x40 },			/* Pin 39 */
	{-1, 0x80 }				/* Pin 40 */
};

static PINDEF VHHPINS[40] = {			/* 9-32 */
	{-1, 0x01 },			/* Pin 1 */
	{-1, 0x02 },			/* Pin 2 */
	{-1, 0x04 },			/* Pin 3 */
	{-1, 0x08 },			/* Pin 4 */
	{-1, 0x10 },			/* Pin 5 */
	{-1, 0x20 },			/* Pin 6 */
	{-1, 0x40 },			/* Pin 7 */
	{-1, 0x80 },			/* Pin 8 */

	{ 1, 0x01 },			/* Pin 9 */
	{ 1, 0x02 },			/* Pin 10 */
	{ 1, 0x04 },			/* Pin 11 */
	{ 1, 0x08 },			/* Pin 12 */
	{ 1, 0x10 },			/* Pin 13 */
	{ 1, 0x20 },			/* Pin 14 */
	{ 1, 0x40 },			/* Pin 15 */
	{ 1, 0x80 },			/* Pin 16 */

	{ 2, 0x01 },			/* Pin 17 */
	{ 2, 0x02 },			/* Pin 18 */
	{ 2, 0x04 },			/* Pin 19 */
	{ 2, 0x08 },			/* Pin 20 */
	{ 2, 0x10 },			/* Pin 21 */
	{ 2, 0x20 },			/* Pin 22 */
	{ 2, 0x40 },			/* Pin 23 */
	{ 2, 0x80 },			/* Pin 24 */

	{ 3, 0x01 },			/* Pin 25 */
	{ 3, 0x02 },			/* Pin 26 */
	{ 3, 0x04 },			/* Pin 27 */
	{ 3, 0x08 },			/* Pin 28 */
	{ 3, 0x10 },			/* Pin 29 */
	{ 3, 0x20 },			/* Pin 30 */
	{ 3, 0x40 },			/* Pin 31 */
	{ 3, 0x80 },			/* Pin 32 */

	{-1, 0x01 },			/* Pin 33 */
	{-1, 0x02 },			/* Pin 34 */
	{-1, 0x04 },			/* Pin 35 */
	{-1, 0x08 },			/* Pin 36 */
	{-1, 0x10 },			/* Pin 37 */
	{-1, 0x20 },			/* Pin 38 */
	{-1, 0x40 },			/* Pin 39 */
	{-1, 0x80 }				/* Pin 40 */
};

static PINDEF VHHCPINS[40] = {			/* 28-32 */
	{-1, 0x00 },			/* Pin 1 */
	{-1, 0x00 },			/* Pin 2 */
	{-1, 0x00 },			/* Pin 3 */
	{-1, 0x00 },			/* Pin 4 */
	{-1, 0x00 },			/* Pin 5 */
	{-1, 0x00 },			/* Pin 6 */
	{-1, 0x00 },			/* Pin 7 */
	{-1, 0x00 },			/* Pin 8 */

	{-1, 0x00 },			/* Pin 9 */
	{-1, 0x00 },			/* Pin 10 */
	{-1, 0x00 },			/* Pin 11 */
	{-1, 0x00 },			/* Pin 12 */
	{-1, 0x00 },			/* Pin 13 */
	{-1, 0x00 },			/* Pin 14 */
	{-1, 0x00 },			/* Pin 15 */
	{-1, 0x00 },			/* Pin 16 */

	{-1, 0x00 },			/* Pin 17 */
	{-1, 0x00 },			/* Pin 18 */
	{-1, 0x00 },			/* Pin 19 */
	{-1, 0x00 },			/* Pin 20 */
	{-1, 0x00 },			/* Pin 21 */
	{-1, 0x00 },			/* Pin 22 */
	{-1, 0x00 },			/* Pin 23 */
	{-1, 0x00 },			/* Pin 24 */

	{-1, 0x00 },			/* Pin 25 */
	{-1, 0x00 },			/* Pin 26 */
	{-1, 0x00 },			/* Pin 27 */
	{ 0, 0x80 },			/* Pin 28 */
	{ 0, 0x40 },			/* Pin 29 */
	{ 0, 0x20 },			/* Pin 30 */
	{ 0, 0x10 },			/* Pin 31 */
	{ 0, 0x08 },			/* Pin 32 */

	{-1, 0x00 },			/* Pin 33 */
	{-1, 0x00 },			/* Pin 34 */
	{-1, 0x00 },			/* Pin 35 */
	{-1, 0x00 },			/* Pin 36 */
	{-1, 0x00 },			/* Pin 37 */
	{-1, 0x00 },			/* Pin 38 */
	{-1, 0x00 },			/* Pin 39 */
	{-1, 0x00 }				/* Pin 40 */
};

static PINDEF VCCPINS[40] = {			/* 1, 5, 7, 9, 26-32, 34, 36, 40 */
	{ 1, 0x20 },			/* Pin 1 */
	{-1, 0x00 },			/* Pin 2 */
	{-1, 0x00 },			/* Pin 3 */
	{-1, 0x00 },			/* Pin 4 */
	{ 1, 0x10 },			/* Pin 5 */
	{-1, 0x00 },			/* Pin 6 */
	{ 1, 0x08 },			/* Pin 7 */
	{-1, 0x80 },			/* Pin 8 */

	{ 1, 0x04 },			/* Pin 9 */
	{-1, 0x00 },			/* Pin 10 */
	{-1, 0x00 },			/* Pin 11 */
	{-1, 0x00 },			/* Pin 12 */
	{-1, 0x00 },			/* Pin 13 */
	{-1, 0x00 },			/* Pin 14 */
	{-1, 0x00 },			/* Pin 15 */
	{-1, 0x00 },			/* Pin 16 */

	{-1, 0x00 },			/* Pin 17 */
	{-1, 0x00 },			/* Pin 18 */
	{-1, 0x00 },			/* Pin 19 */
	{-1, 0x00 },			/* Pin 20 */
	{-1, 0x00 },			/* Pin 21 */
	{-1, 0x00 },			/* Pin 22 */
	{-1, 0x00 },			/* Pin 23 */
	{-1, 0x00 },			/* Pin 24 */

	{-1, 0x00 },			/* Pin 25 */
	{ 1, 0x02 },			/* Pin 26 */
	{ 1, 0x01 },			/* Pin 27 */
	{ 0, 0x80 },			/* Pin 28 */
	{ 0, 0x40 },			/* Pin 29 */
	{ 0, 0x20 },			/* Pin 30 */
	{ 0, 0x10 },			/* Pin 31 */
	{ 0, 0x08 },			/* Pin 32 */

	{-1, 0x00 },			/* Pin 33 */
	{ 0, 0x04 },			/* Pin 34 */
	{-1, 0x00 },			/* Pin 35 */
	{ 0, 0x02 },			/* Pin 36 */
	{-1, 0x00 },			/* Pin 37 */
	{-1, 0x00 },			/* Pin 38 */
	{-1, 0x00 },			/* Pin 39 */
	{ 0, 0x01 }				/* Pin 40 */
};

int VCC,VHH,VOP;

/* remember last states */

static byte ttlen[5], vopen[5], vhhen[5];
static byte vccen[2], vhhenc[2];
static byte otheren;

/*-------------------------------------------------------------*/
void setport( int id, int off, int data )
{
	outp( idport, id+off );

	switch( id )
	{
	case TTLID:		ttlen[ off ] = data; break;
	case VOPENID:	vopen[ off ] = data; break;
	case VHHENID:	vhhen[ off ] = data; break;
	case VHHENCID:	vhhenc[off ] = data; break;
	case VCCENID:	vccen[ off ] = data; break;
	case OTHERENID:	otheren		 = data; break;
	}

	outp( idport+2, data );
}

/*-------------------------------------------------------------*/
int getport( int id, int off )
{
	switch( id )
	{
	case VOPENID:	return vopen[ off ];
	case VHHENID:	return vhhen[ off ];
	case VHHENCID:	return vhhenc[off ];
	case VCCENID:	return vccen[ off ];
	case OTHERENID:	return otheren;
	default:		outp( idport, id+off ); return inp( idport+2 );
	}
}

int getpin( int pin )
{
	if( --pin < 0 || pin > 39 )
		return 0;
	return ( getport( TTLID, pin / 8 ) >> ( pin % 8 ) ) & 1;
}

void setdac( int which, int data )
{
	outp( idport, which );

	switch( which )
	{
	case VOPID: outp( idport+2,		 (VOP = data)	  + VOPDROP ); break;
	case VHHID: outp( idport+2, 10 * (VHH = data) / 6 + VHHDROP ); break;
	case VCCID: outp( idport+2, 10 * (VCC = data) / 4 + VCCDROP ); break;
	}
}

void setdac_raw( int which, int data )	// for direct measurement
{
	outp( idport, which );

	switch( which )
	{
	case VOPID: outp( idport+2,		 (VOP = data)     ); break;
	case VHHID: outp( idport+2, 10 * (VHH = data) / 6 ); break;
	case VCCID: outp( idport+2, 10 * (VCC = data) / 4 ); break;
	}
}

void setother( int bit, int state )
{
	if( state )
		setport( OTHERENID, 0, otheren | (1<<bit) );
	else
		setport( OTHERENID, 0, otheren & ~(1<<bit) );
}

int setpin( int pin, int voltage, int state )
{
	int off;

	if( --pin < 0 || pin > 39 )
		return 0;

	/* if we try to set a pin to a current source, first make sure to set TTL to H,
	 * and that all other sources for this pin are switched off before ! */
	if( voltage != TTLID && state != 0 )
	{
		off = TTLPINS[pin].offs;
		setport( TTLID, off, ttlen[off] |  TTLPINS[pin].mask );

		if( voltage != VOPENID && ( off = VOPPINS[pin].offs ) != -1 )
			setport( VOPENID, off, vopen[off] & ~VOPPINS[pin].mask );
		if( voltage != VHHENID && ( off = VHHPINS[pin].offs ) != -1 )
			setport( VHHENID, off, vhhen[off] & ~VHHPINS[pin].mask );
		if( voltage != VHHENCID && ( off = VHHCPINS[pin].offs ) != -1 )
			setport( VHHENCID, off, vhhenc[off] & ~VHHCPINS[pin].mask );
		if( voltage != VCCENID && ( off = VCCPINS[pin].offs ) != -1 )
			setport( VCCENID, off, vccen[off] & ~VCCPINS[pin].mask );
	}
	
	/* if we set TTL to L, make sure all current sources are switched off before */
	if( voltage == TTLID && state == 0 )
	{
		if( ( off = VOPPINS[pin].offs ) != -1 )
			setport( VOPENID, off, vopen[off] & ~VOPPINS[pin].mask );
		if( ( off = VHHPINS[pin].offs ) != -1 )
			setport( VHHENID, off, vhhen[off] & ~VHHPINS[pin].mask );
		if( ( off = VHHCPINS[pin].offs ) != -1 )
			setport( VHHENCID, off, vhhenc[off] & ~VHHCPINS[pin].mask );
		if( ( off = VCCPINS[pin].offs ) != -1 )
			setport( VCCENID, off, vccen[off] & ~VCCPINS[pin].mask );
	}
	
	switch( voltage )
	{
	case TTLID:
		off = TTLPINS[pin].offs;	/* no need to check, all pins allowed... */

		if( state )
			setport( TTLID, off, ttlen[off] |  TTLPINS[pin].mask );
		else
			setport( TTLID, off, ttlen[off] & ~TTLPINS[pin].mask );
		break;

	case VOPENID:
		if( ( off = VOPPINS[pin].offs ) == -1 )
			return 0;

		if( state )
			setport( VOPENID, off, vopen[off] |  VOPPINS[pin].mask );
		else
			setport( VOPENID, off, vopen[off] & ~VOPPINS[pin].mask );
		break;

	case VHHENID:
		if( ( off = VHHPINS[pin].offs ) == -1 )
			return 0;

		if( state )
			setport( VHHENID, off, vhhen[off] |  VHHPINS[pin].mask );
		else
			setport( VHHENID, off, vhhen[off] & ~VHHPINS[pin].mask );
		break;

	case VHHENCID:
		if( ( off = VHHCPINS[pin].offs ) == -1 )
			return 0;

		if( state )
			setport( VHHENCID, off, vhhenc[off] |  VHHCPINS[pin].mask );
		else
			setport( VHHENCID, off, vhhenc[off] & ~VHHCPINS[pin].mask );
		break;

	case VCCENID:
		if( ( off = VCCPINS[pin].offs ) == -1 )
			return 0;

		if( state )
			setport( VCCENID, off, vccen[off] |  VCCPINS[pin].mask );
		else
			setport( VCCENID, off, vccen[off] & ~VCCPINS[pin].mask );
		break;
	}
	return 1;
}
