TITLE		DELAYS for IBM PC/XT/AT

	ifdef _WIN32
			.386p
			model flat
	endif

;***********************************************
;	REV: V1.0 5/30/1988
;	REV: V1.1 11/20/2000 AZ
;	REV: V1.2 10/06/2003 AZ
;	EXPRO-40 ASSEMBLY SUBROUTINES
;***********************************************

PUBLIC		_initclk

PUBLIC		_dly50m, _dly20m, _dly10m
PUBLIC		_dly5m,  _dly2m,  _dly1m
PUBLIC		_dly500u,_dly200u,_dly100u
PUBLIC		_dly50u, _dly20u, _dly10u
PUBLIC		_dly1u

PUBLIC		_FACT1U
PUBLIC		_FACT10U, _FACT20U, _FACT50U
PUBLIC		_FACT100U,_FACT200U,_FACT500U
PUBLIC		_FACT1M,  _FACT2M,  _FACT5M
PUBLIC		_FACT10M, _FACT20M, _FACT50M

DGROUP		GROUP	_DATA

	ifdef _WIN32
_DATA		SEGMENT	DWORD PUBLIC USE32 'DATA'
	else
_DATA		SEGMENT	WORD PUBLIC 'DATA'
	endif

			ASSUME	DS:DGROUP

_FACT1U		DW		?
_FACT10U	DW		?
_FACT20U	DW		?
_FACT50U	DW		?
_FACT100U	DW		?
_FACT200U	DW		?
_FACT500U	DW		?
_FACT1M		DW		?
_FACT2M		DW		?
_FACT5M		DW		?
_FACT10M	DW		?
_FACT20M	DW		?
_FACT50M	DW		?

TMHI		DW		?
TMLO		DW		?

_DATA		ENDS

;==============================================

	ifdef _WIN32
_TEXT		SEGMENT	DWORD PUBLIC USE32 'CODE'

PUBLIC _inp, _outp
; void outp( unsigned short portaddr, unsigned char value )
_outp		PROC	NEAR

			PUSH	EBP
			MOV		EBP,ESP

			MOV		DX,WORD PTR [EBP+8]
			MOV		AL,BYTE PTR [EBP+12]
			OUT		DX,AL

			POP		EBP
			RET

_outp		ENDP

; unsigned char inp( unsigned short portaddr )
_inp		PROC	NEAR

			PUSH	EBP
			MOV		EBP,ESP

			MOV		DX,WORD PTR [EBP+8]
			XOR		EAX,EAX
			IN		AL,DX

			POP		EBP
			RET

_inp		ENDP

_?SCOPE		EQU		NEAR

	else

_TEXT		SEGMENT	BYTE PUBLIC 'CODE'
			ASSUME	CS:_TEXT

_?SCOPE		EQU		FAR

	endif

; CHECK SYSTEM OSC BY CHECKING LOOP COUNT IN
; BETWEEN TWO TIMER INTERRUPTS (~18.2HZ)
;
; TIMER OSC 14.31818 MHZ/12 = 1.193166 MHZ = 0.838US 
; TIMER INT 18.206507 HZ    = 54925.4 US
;

_initclk	PROC	_?SCOPE

			XOR		AH,AH
			INT		1AH					; READ TIMER
			MOV		DGROUP:TMHI,CX		; store current value
			MOV		DGROUP:TMLO,DX

WAITINT:	XOR		AH,AH
			INT		1AH					; READ TIMER
			CMP		DX,DGROUP:TMLO		; compare with previous
			JNZ		CHKCK1
			CMP		CX,DGROUP:TMHI
			JZ		WAITINT

			; TIMER has advanced

CHKCK1:		MOV		DGROUP:TMHI,CX		; store current value
			MOV		DGROUP:TMLO,DX
			XOR		BX,BX

CHKCK2:		XOR		AH,AH
			INT		1AH					; READ TIMER
			CMP		DX,DGROUP:TMLO
			JNZ		CHKCK3
			CMP		CX,DGROUP:TMHI
			JNZ		CHKCK3
			NOP
			NOP
			INC		BX
			JMP		SHORT CHKCK2

CHKCK3:		MOV		AX,BX
			PUSH	AX
			MOV		DGROUP:_FACT50M,AX		;50ms
			XOR		DX,DX
			MOV		BX,10
			DIV		BX
			MOV		DGROUP:_FACT5M,AX		;5ms
			XOR		DX,DX
			MOV		BX,10
			DIV		BX
			MOV		DGROUP:_FACT500U,AX		;500us
			XOR		DX,DX
			MOV		BX,10
			DIV		BX
			MOV		DGROUP:_FACT50U,AX		;50us

			POP		AX
			PUSH	AX
			XOR		DX,DX
			MOV		BX,5
			DIV		BX
			MOV		DGROUP:_FACT10M,AX		;10ms
			XOR		DX,DX
			MOV		BX,10
			DIV		BX
			MOV		DGROUP:_FACT1M,AX		;1ms
			XOR		DX,DX
			MOV		BX,10
			DIV		BX
			MOV		DGROUP:_FACT100U,AX		;100us
			XOR		DX,DX
			MOV		BX,10
			DIV		BX
			MOV		DGROUP:_FACT10U,AX		;10us
			XOR		DX,DX
			MOV		BX,10
			DIV		BX
			MOV		DGROUP:_FACT1U,AX		;1us
			
			POP		AX
			MOV		BX,2
			MUL		BX
			MOV		BX,5
			DIV		BX
			MOV		DGROUP:_FACT20M,AX		;20ms
			XOR		DX,DX
			MOV		BX,10
			DIV		BX
			MOV		DGROUP:_FACT2M,AX		;2ms
			XOR		DX,DX
			MOV		BX,10
			DIV		BX
			MOV		DGROUP:_FACT200U,AX		;200us
			XOR		DX,DX
			MOV		BX,10
			DIV		BX
			MOV		DGROUP:_FACT20U,AX		;20us

			RET

_initclk	ENDP

;-------------------------------------------
; ALL DELAY LOOP
;
_dly50m		PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT50M
			JMP		SHORT TMDLY
_dly50m		ENDP

_dly20m		PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT20M
			JMP		SHORT TMDLY
_dly20m		ENDP

_dly10m		PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT10M
			JMP		SHORT TMDLY
_dly10m		ENDP

_dly5m		PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT5M
			JMP		SHORT TMDLY
_dly5m		ENDP

_dly2m		PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT2M
			JMP		SHORT TMDLY
_dly2m		ENDP

_dly1m		PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT1M
			JMP		SHORT TMDLY
_dly1m		ENDP

_dly500u	PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT500U
			JMP		SHORT TMDLY
_dly500u	ENDP

_dly200u	PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT200U
			JMP		SHORT TMDLY
_dly200u	ENDP

_dly100u	PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT100U
			JMP		SHORT TMDLY
_dly100u	ENDP

_dly50u		PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT50U
			JMP		SHORT TMDLY
_dly50u		ENDP

_dly20u		PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT20U
			JMP		SHORT TMDLY
_dly20u		ENDP

_dly10u		PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT10U
			JMP		SHORT TMDLY
_dly10u		ENDP

_dly1u		PROC	_?SCOPE
			MOV		BX,DGROUP:_FACT1U
			JMP		SHORT TMDLY
_dly1u		ENDP

TMDLY		PROC	_?SCOPE
			INC		BX
TMDLY1:		NOP
			NOP
			DEC		BX
			JZ		TMWAITQ
			XOR		AH,AH
			INT		1AH
			CMP		CX,DGROUP:TMHI
			NOP
			CMP		DX,DGROUP:TMLO
			JMP		SHORT TMDLY1
TMWAITQ:	RET

TMDLY		ENDP

_TEXT		ENDS

			END
