{$A+,B-,E-,G+,I-,N-,O-,P-,Q-,R-,S-,T-,V+,X+,Y-}
{$M 60000,0,0}

program driversupp;

uses
  crt, dos;

type
  TEXEHeader = record
                 signature,
                 bytes_in_last_block,
                 blocks_in_file,
                 num_relocs,
                 header_paragraphs,
                 min_extra_paragraphs,
                 max_extra_paragraphs,
                 ss_offset,
                 init_sp,
                 checksum,
                 init_ip,
                 cs_offset,
                 reloc_table_offset,
                 overlay_number:       word;
  end;

  WOL        = record
                 lo,
                 hi: word;
  end;

const
  OpenDriver: array[0..$2f] of byte =
                ($1e,         { PUSH DS      Original DS sichern      }
                 $0e,         { PUSH CS                               }
                 $1f,         { POP  DS      DS = CS setzen           }
                 $e8,$0b,$00, { CALL $+11    String bersringen       }
                 $5c,$5c,$2e,$5c,$45,$58,$50,$52,$4f,0,0, { \\.\EXPRO }
                 $5a,         { POP  DX      Offset auf String holen  }
                 $b8,$00,$3d, { MOV  AX,3D00 Datei ffnen Name= DS:DX }
                 $cd,$21,     { INT  21                               }
                 $72,$06,     { JC   $+6     Bei Fehler               }
                 $89,$c3,     { MOV  BX,AX   Dateihandle              }
                 $b4,$3e,     { MOV  AH,3E   Datei schliessen         }
                 $cd,$21,     { INT  21                               }
                 $1f,         { POP  DS      Original DS wiederherst. }
                 $8c,$d8,     { MOV  AX,DS                            }
                 $05,0,0,     { ADD  AX,???? Original Segmentoffset   }
                 $50,         { PUSH AX      Startsegment             }
                 $68,0,0,     { PUSH ????    Original Startoffset=IP  }
                 $31,$c0,     { XOR  AX,AX   Original Startwerte AX   }
                 $31,$db,     { XOR  BX,BX                       BX   }
                 $31,$d2,     { XOR  DX,DX                       DX   }
                 $cb);        { RETF         Altes Original ansprigen }


var
  prg_file:  file;
  prg_name:  string;
  groesse,
  check,
  new_init:  longint;
  EXEHeader: TEXEHeader;
  orgattr,
  anzahl:    word;

{}

function gross (const instr:string):string;
var
  index : byte;

begin
  gross := instr;
  index := 1;
  while (index <= length(instr)) and (instr[index] <> ';') do
  begin
    case instr[index] of
 '': gross[index] := '';
 '': gross[index] := '';
 '': gross[index] := '';
    else
      gross[index] := upcase(instr[index]);
    end;
    inc(index);
  end;
end;

{}

function IsNotAlreadyPatched: boolean;
var
  puffer: array[0..pred(sizeof(OpenDriver))] of byte;
  chkidx: byte;

begin
  IsNotAlreadyPatched := false;
  seek(prg_file, groesse - sizeof(puffer));
  blockread(prg_file, puffer, sizeof(puffer), anzahl);
  if anzahl < sizeof(puffer) then exit;
  {}
  for chkidx := $06 to $10 do
  begin
    if puffer[chkidx] <> OpenDriver[chkidx] then
    begin
      IsNotAlreadyPatched := true;
      exit;
    end;
  end;
end;

{}

begin
  checkbreak  := false;
  checksnow   := false;
  directvideo := true;
  filemode    := 2;
  {}
  prg_name := gross(paramstr(1));
  if prg_name > '' then
  begin
    assign(prg_file, prg_name);
    getfattr(prg_file, orgattr);
    setfattr(prg_file, 0);
    {}
    reset(prg_file, 1);
    if ioresult = 0 then
    begin
      groesse := filesize(prg_file);
      if groesse > sizeof(EXEHeader) then
      begin
        blockread(prg_file, EXEHeader, sizeof(EXEHeader), anzahl);
        if anzahl = sizeof(EXEHeader) then
        begin
          check := EXEHeader.blocks_in_file;
          if wordbool(EXEHeader.bytes_in_last_block) then dec(check);
          check := (check shl 9) or EXEHeader.bytes_in_last_block;
          if groesse >= check then
          begin
            if EXEHeader.cs_offset < $8000 then
            begin
              groesse := check; { Immer auf korrekte Lnge setzen            }
              if IsNotAlreadyPatched{} then
              begin
                {}
                inc(EXEHeader.bytes_in_last_block, sizeof(OpenDriver));
                if EXEHeader.bytes_in_last_block >= 512 then
                begin
                  dec(EXEHeader.bytes_in_last_block, 512);
                  inc(EXEHeader.blocks_in_file);
                end;
                {}
                inc(EXEHeader.cs_offset, $10);
                OpenDriver[$23] := lo(EXEHeader.cs_offset);
                OpenDriver[$24] := hi(EXEHeader.cs_offset);
                {}
                OpenDriver[$27] := lo(EXEHeader.init_ip);
                OpenDriver[$28] := hi(EXEHeader.init_ip);
                {}
                new_init := EXEHeader.header_paragraphs;
                new_init := groesse - (new_init shl 4);
                EXEHeader.init_ip   := new_init and $0f;
                EXEHeader.cs_offset := new_init shr 4;
                {}
                seek(prg_file, groesse);
                blockwrite(prg_file, OpenDriver, sizeof(OpenDriver), anzahl);
                if anzahl = sizeof(OpenDriver) then
                begin
                  EXEHeader.checksum := 0;
                  seek(prg_file, 0);
                  blockwrite(prg_file, EXEHeader, sizeof(EXEHeader), anzahl);
                  if anzahl < sizeof(EXEHeader) then
                    writeln('Error while writing updated EXE-Header');
                end
                else writeln('Error while writing additional code');
              end
              else writeln('EXE-File is already patched');
            end
            else writeln('Don'#39't patch a compressed EXE-File');
          end
          else writeln('EXE-Header wrong');
        end
        else writeln('Error while reading EXE-Header');
      end
      else writeln('EXE-Header missing');
      {}
      close(prg_file);
      setfattr(prg_file, orgattr);
    end
    else writeln('EXE-File not found');
  end
  else writeln('Useage: DRV_SUPP EXE-File');
end.
