    'HEATHDSP.BAS  Display 16-channel timing data from file, by John Vermeulen
    '           All data displayed.5    CLS                                                'Clear screen
5    SCREEN 12						'Video mode hex 12
     KEY OFF						'No function key display
     DEFINT A-Z 					'Define integers
     DIM l(15)						'Up/down storage
     DIM CRS%(671)					'Line save area
     LOCATE 27, 3					'Set cursor
     INPUT "Enter Pathname of input  file                 ", i$
'    I$ = "DEMO.NDL"
     s% = 0						'Sample number
'10   LOCATE 28, 3                                       'Set cursor
'     PRINT "Do you want expand display?   (y/N)       "
'15   A$ = INKEY$: IF A$ = "" THEN 15                    'Wait for keyboard input
'     IF ((A$ = "y") OR (A$ = "Y")) THEN GOTO 20 ELSE p% = 1: GOTO 50
     p% = 1						'No expansion yet
     b% = 0						'XXXXXXXX
     GOTO 50

20   LOCATE 28, 3					'Set cursor
     COLOR 12: PRINT "Enter expansion factor (1,2,4,8 or 16)";
     COLOR 15: INPUT " ", p%
     IF p% = 1 THEN GOTO 50				'Check for legal entry
     IF p% = 2 THEN GOTO 50				'Check for legal entry
     IF p% = 4 THEN GOTO 50				'Check for legal entry
     IF p% = 8 THEN GOTO 50				'Check for legal entry
     IF p% = 16 THEN GOTO 50				'Check for legal entry
     BEEP						'Oops, illegal entry
     LOCATE 27, 10					'Set cursor
     COLOR 12						'Red color
     PRINT "ILLEGAL ENTRY"
     PRINT "                                                          "
     COLOR 15						'White color
     GOTO 20

     b% = 0						'Starting sample
50   IF b% > 2047 - (512 \ p%) THEN b% = 2047 - (512 \ p%)
     CLS						'Clear screen
     OPEN i$ FOR BINARY ACCESS READ AS #1
     c$ = INPUT$(8, #1) 				'Load 8-byte header
     t% = ABS(CVI(MID$(c$, 3, 2)))			'Trigger point position
     A$ = INPUT$(b% * 2, #1)				'Skip data
     h% = 7						'Timing height

    'DRAW SAMPLING CURSOR

100  LINE (16, 360)-(527, 360)				'Horizontal line
     FOR i% = 0 TO 511 \ p%
      j% = 16 + i% * p% + p% \ 2
      LINE (j%, 360)-(j%, 356)				'Vertical marker
     NEXT i%

    'PRINT PROBE NUMBERS

     PRINT
     COLOR 12						'Red color
     PRINT "0"
     PRINT "1"
     PRINT "2"
     PRINT "3"
     PRINT
     PRINT "4"
     PRINT "5"
     PRINT "6"
     PRINT "7"
     PRINT
     PRINT
     PRINT "8"
     PRINT "9"
     PRINT "A"
     PRINT "B"
     PRINT
     PRINT "C"
     PRINT "D"
     PRINT "E"
     PRINT "F"
     COLOR 15						'White color

     FOR i% = 0 TO 15					'Initialize start
       l(i%) = 0
     NEXT i%

     FOR j% = 0 TO (512 \ p%) - 1
       x% = 16 + j% * p%
       A$ = INPUT$(1, #1)				'Read byte

       IF EOF(1) THEN l% = j%: GOTO 120 		    'EOF

       A = ASC(A$)					'Value

       y% = 20

    'DRAW 16 TIMING DIAGRAMS

       IF l(0) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 1) < 1 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(0) = 0
	   IF (A AND 1) >= 1 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(0) = 1

       y% = 36
       IF l(1) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 2) < 2 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(1) = 0
	   IF (A AND 2) >= 2 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(1) = 1

       y% = 52
       IF l(2) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 4) < 4 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(2) = 0
	   IF (A AND 4) >= 4 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(2) = 1

       y% = 68
       IF l(3) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 8) < 8 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(3) = 0
	   IF (A AND 8) >= 8 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(3) = 1

       y% = 100
       IF l(4) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 16) < 16 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(4) = 0
	   IF (A AND 16) >= 16 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(4) = 1

       y% = 116
       IF l(5) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 32) < 32 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(5) = 0
	   IF (A AND 32) >= 32 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(5) = 1

       y% = 132
       IF l(6) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 64) < 64 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(6) = 0
	   IF (A AND 64) >= 64 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(6) = 1

       y% = 148
       IF l(7) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 128) < 128 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(7) = 0
	   IF (A AND 128) >= 128 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(7) = 1

       A$ = INPUT$(1, #1)				'Read byte

       IF EOF(1) THEN l% = j%: GOTO 120 		'EOF

       A = ASC(A$)					'Value

       y% = 196

       IF l(8) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 1) < 1 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(8) = 0
	   IF (A AND 1) >= 1 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(8) = 1

       y% = 212
       IF l(9) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 2) < 2 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(9) = 0
	   IF (A AND 2) >= 2 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(9) = 1

       y% = 228
       IF l(10) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 4) < 4 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(10) = 0
	   IF (A AND 4) >= 4 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(10) = 1

       y% = 244
       IF l(11) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 8) < 8 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(11) = 0
	   IF (A AND 8) >= 8 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(11) = 1

       y% = 276
       IF l(12) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 16) < 16 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(12) = 0
	   IF (A AND 16) >= 16 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(12) = 1

       y% = 292
       IF l(13) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 32) < 32 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(13) = 0
	   IF (A AND 32) >= 32 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(13) = 1

       y% = 308
       IF l(14) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 64) < 64 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(14) = 0
	   IF (A AND 64) >= 64 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(14) = 1

       y% = 324
       IF l(15) = 0 THEN PRESET (x%, y% + h%) ELSE PRESET (x%, y%)
	   IF (A AND 128) < 128 THEN LINE -(x%, y% + h%): LINE -(x% + p%, y% + h%): l(15) = 0
	   IF (A AND 128) >= 128 THEN LINE -(x%, y%): LINE -(x% + p%, y%): l(15) = 1

     NEXT j%

120  l% = j%

     A$ = "0"
     s% = 0

    'PRINT MENU ITEMS AT THE BOTTOM

     COLOR 10
     LOCATE 24, 3: PRINT "PgDn"                         'Set cursor
     LOCATE 24, 19: PRINT "Home   ";
		    PRINT "ShTab   ";
		    PRINT CHR$(27); "   "; CHR$(26); "   ";
		    PRINT "Tab   ";
		    PRINT "End";
     LOCATE 24, 63: PRINT "PgUp"
     LOCATE 27, 3: PRINT "                  "
     COLOR 15
     LOCATE 28, 3: PRINT "e"; : COLOR 10: PRINT "X"; : COLOR 15: PRINT "pansion factor:";
     COLOR 12: PRINT p%: COLOR 15
     LOCATE 26, 63: COLOR 10: PRINT "Q"; : COLOR 15: PRINT "uit "; : COLOR 15: PRINT i$
     LOCATE 27, 63: COLOR 10: PRINT "L"; : COLOR 15: PRINT "oad"
     COLOR 15

    'ENTRY POINT FROM LATER KEYBOARD ENTRY

150 'FIRST TEST FOR UPPER LIMIT OF CURSOR POSITION

     IF (A$ = "M") AND ((s% + 1) * p%) > 511 THEN BEEP: GOTO 200   'Outside boundary
     IF (A$ = "K") AND (s% = 0) THEN BEEP: GOTO 200                'Outside boundary

     x% = s%
     y% = 0

     IF A$ = "M" THEN
       PUT (16 + x% * p% + p% \ 2, y% + 17), CRS%, PSET   'Restore screen data
       s% = s% + 1
     END IF
     IF A$ = "K" THEN
       PUT (16 + x% * p% + p% \ 2, y% + 17), CRS%, PSET   'Restore screen data
       s% = s% - 1
     END IF
     IF A$ = "G" THEN
       PUT (16 + x% * p% + p% \ 2, y% + 17), CRS%, PSET   'Restore screen data
       s% = 0
     END IF
     IF A$ = "O" THEN
       PUT (16 + x% * p% + p% \ 2, y% + 17), CRS%, PSET   'Restore screen data
       s% = 512 \ p - 1
     END IF
     IF A$ = CHR$(9) THEN
       PUT (16 + x% * p% + p% \ 2, y% + 17), CRS%, PSET   'Restore screen data
       s% = s% + 512 \ p% \ 16
     END IF
     IF A$ = CHR$(15) THEN
       PUT (16 + x% * p% + p% \ 2, y% + 17), CRS%, PSET   'Restore screen data
       s% = s% - 512 \ p% \ 16
     END IF

     COLOR 14:
     IF s% < 0 THEN BEEP: s% = 0			'Keep within boundary
     IF s% > 512 \ p% - 1 THEN BEEP: s% = 512 \ p% - 1	'Keep within boundary
     x% = s%
     y% = 0

     LOCATE 2, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 20) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 3, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 36) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 4, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 52) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 5, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 68) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 7, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 100) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 8, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 116) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 9, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 132) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 10, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 148) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 13, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 196) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 14, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 212) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 15, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 228) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 16, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 244) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 18, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 276) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 19, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 292) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 20, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 308) = 0 THEN PRINT "0" ELSE PRINT "1"
     LOCATE 21, 68					'Set cursor
     IF POINT(16 + x% * p% + p% \ 2, y% + 324) = 0 THEN PRINT "0" ELSE PRINT "1"

    'SAVE SCREEN DATA AND DRAW YELLOW CURSOR

     GET (16 + x% * p% + p% \ 2, y% + 17)-(16 + x% * p% + p% \ 2, y% + 334), CRS%  'Save screen data
     LINE (16 + x% * p% + p% \ 2, y% + 17)-(16 + x% * p% + p% \ 2, y% + 334), 14

    'DRAW RED TRIGGER LINE, IF WITHIN RANGE

     IF t% < (s% + b%) THEN GOTO 190			'Out if too far left
     IF t% >= (s% + b% + 512 \ p%) THEN GOTO 190	'Out if too far right
     LINE (16 + t% * p% - b% * p%, y% + 17)-(16 + t% * p% - b% * p%, y% + 334), 4   'Draw line

190  LOCATE 26, 3: PRINT "                  "
     LOCATE 26, 3: COLOR 10: PRINT "S"; : COLOR 15: PRINT "ample #:";
     COLOR 12: PRINT s% + b%
     LOCATE 27, 3: COLOR 15: PRINT "Range:   "; b%; "to"; b% + 512 \ p% - 1
     LOCATE 26, 25: PRINT "Trigger point:"; t%

'    COLOR 12
'    LOCATE 2, 70: PRINT CH0$                           'Print channel name
'    LOCATE 3, 70: PRINT CH1$                           'Print channel name
'    LOCATE 4, 70: PRINT CH2$                           'Print channel name
'    LOCATE 5, 70: PRINT CH3$                           'Print channel name
'    LOCATE 7, 70: PRINT CH4$                           'Print channel name
'    LOCATE 8, 70: PRINT CH5$                           'Print channel name
'    LOCATE 9, 70: PRINT CH6$                           'Print channel name
'    LOCATE 10, 70: PRINT CH7$                          'Print channel name
'    LOCATE 13, 70: PRINT CH8$                          'Print channel name
'    LOCATE 14, 70: PRINT CH9$                          'Print channel name
'    LOCATE 15, 70: PRINT CHA$                          'Print channel name
'    LOCATE 16, 70: PRINT CHB$                          'Print channel name
'    LOCATE 18, 70: PRINT CHC$                          'Print channel name
'    LOCATE 19, 70: PRINT CHD$                          'Print channel name
'    LOCATE 20, 70: PRINT CHE$                          'Print channel name
'    LOCATE 21, 70: PRINT CHF$                          'Print channel name
     COLOR 15

200  A$ = INKEY$: IF A$ = "" THEN 200                   'Wait for keyboard input
     LOCATE 28, 55					'Set cursor
     PRINT "                         "
     IF LEN(A$) = 2 THEN A$ = RIGHT$(A$, 1) ELSE GOTO 230
     IF A$ = "M" THEN GOTO 150                          'Right arrow
     IF A$ = "K" THEN GOTO 150                          'Left  arrow
     IF A$ = "G" THEN GOTO 150                          'Home
     IF A$ = "O" THEN GOTO 150                          'End
     IF A$ = CHR$(15) THEN GOTO 150			'Tab left
     IF A$ = "I" THEN GOTO 210                          'PgUp
     IF A$ = "Q" THEN GOTO 220                          'PgDn
     GOTO 235

210  CLOSE #1						'Close file
     b% = b% + (512 \ p%)				'Increment
     IF b% > 2047 - (512 \ p%) THEN BEEP: b% = 2047 - (512 \ p%)
     GOTO 50

220  CLOSE #1						'Close file
     b% = b% - (512 \ p%)				'Decrement
     IF b% < 0 THEN BEEP: b% = 0			'Oops, too far
     GOTO 50

230  IF (A$ = "X" OR A$ = "x") THEN CLOSE #1: GOTO 20   'Expansion requested
     IF (A$ = "S" OR A$ = "s") THEN CLOSE #1: GOTO 240  'Sample number selected
     IF (A$ = "L" OR A$ = "l") THEN CLOSE #1: GOTO 5    '`oad new file
     IF (A$ = "Q" OR A$ = "q") THEN CLOSE #1: END       'Quit program
     IF (A$ = "W" OR A$ = "w") THEN GOTO 300            'Write screen to file
     IF A$ = CHR$(9) THEN GOTO 150			'Tab right

235  BEEP						'Wrong key used
     LOCATE 28, 55					'Set cursor
     COLOR 12						'Red color
     PRINT "Key entry not recognized."
     COLOR 15						'White color
     GOTO 200

240  LOCATE 28, 3					'Set cursor
     COLOR 12						'Red color
     max% = 2047 - (512 \ p%)				'Highest sample
     PRINT "Enter starting sample number (0 to"; max%; ")";
     COLOR 15: INPUT " ", b%
     IF b% < 0 THEN BEEP: b% = 0			'Too low, set zero
     IF b% > max% THEN BEEP: b% = max%			'Too high, set max
     COLOR 15						'White color
     GOTO 50

300  LOCATE 28, 25
     COLOR 12
     INPUT "Enter file name for screen save ", s$
     COLOR 15
     LOCATE 28, 25
     PRINT "                                           ";
     LOCATE 29, 3:
     OPEN s$ FOR OUTPUT AS #2

    'WRITE HEADER

     FOR i = 1 TO 6
       PRINT #2, CHR$(0);				'6 zero's
     NEXT i
     PRINT #2, CHR$(224);				'Rows = 480
     PRINT #2, CHR$(1);
     PRINT #2, CHR$(128);				'Columns = 640
     PRINT #2, CHR$(2);
     FOR i = 1 TO 502
       PRINT #2, CHR$(0);				'502 zero's
     NEXT i

    'WRITE PIXELS IN B/W

     FOR j% = 0 TO 479
       FOR i% = 0 TO 639
	 IF (POINT(i%, j%) > 0) THEN PRINT #2, CHR$(0);  ELSE PRINT #2, CHR$(255); 'Invert for later printing
       NEXT i%
'      LOCATE 28, 30: PRINT j%;
     NEXT j%

     BEEP
     LOCATE 28, 25
     COLOR 12
     PRINT "Screen save completed";
     COLOR 15
     CLOSE #2
     GOTO 200

     LOCATE 23, 68
     IF LEN(HX$) = 1 THEN PRINT "000"; HX$
     IF LEN(HX$) = 2 THEN PRINT "00"; HX$
     IF LEN(HX$) = 3 THEN PRINT "0"; HX$
     PRINT HEX$(HX!)

