           .title "carillon"
           .vers  "st6225"
           .input "6225_reg.asm"
           .w_on

;
;
;
; La priode du signal rectangulaire est obtenue par deux boucles ( une par
; demi priode ) .
;
; La formule approximative permettant de dterminer cette priode est :
;
;   1       13                                FQuartz           1
;   -  =  ------- * ( 12 * N + 29 ) ,  soit ( ------- - 29 ) * --- = N
;   F     FQuartz                             13 * F            12
;
;                                    51282
;  soit, pour Fquartz = 8 MHz,   N # ----- - 2.4
;                                      F
;
;-----------------------------------------------------------------------------
;                          Definition des constantes
;-----------------------------------------------------------------------------

chien      .equ 0FEh            ; valeur du chien de garde
son        .equ 7               ; PC7 = sortie excitation sonore
tmz        .equ 7               ; mis a 1 quand Timer(TCR) passe a 0.
t          .equ 0               ; indicateur de dure de la note termine
timilli    .equ 63              ; 63 * 64 * 1,5E-6 # 6mS
bp         .equ 7               ; PA7 = entre bouton poussoir du carillon

; quivalence  "tempo" dont la valeur est significative d'une double croche.

tempo40    .equ    62           ; tempo de 40
tempo50    .equ    50           ; tempo de 50
tempo60    .equ    41           ; tempo de 60
tempo70    .equ    35           ; tempo de 70
tempo80    .equ    31           ; tempo de 80
tempo90    .equ    28           ; tempo de 90
tempo100   .equ    25           ; tempo de 100
tempo110   .equ    23           ; tempo de 110
tempo120   .equ    21           ; tempo de 120
tempo130   .equ    19           ; tempo de 130
tempo140   .equ    18           ; tempo de 140

; quivalence des notes .

l0         .equ  231            ; note  La    220   Hz
ld0        .equ  218            ; note  La    233   Hz
s0         .equ  205            ; note  Si    246,9 Hz
d1         .equ  194            ; note  Do    261,6 Hz
dd1        .equ  183            ; note  Do#   277,2 Hz
r1         .equ  172            ; note  R    293,7 Hz
rd1        .equ  162            ; note  R#   311,1 Hz
m1         .equ  153            ; note  Mi    329,6 Hz
f1         .equ  144            ; note  Fa    349,2 Hz
fd1        .equ  136            ; note  Fa#   370   Hz
sl1        .equ  128            ; note  Sol   392   Hz
sld1       .equ  121            ; note  Sol#  415,3 Hz
l1         .equ  114            ; note  La    440   Hz
ld1        .equ  108            ; note  La#   466,2 Hz
s1         .equ  101            ; note  Si    493,9 Hz
d2         .equ  96             ; note  Do    523,3 Hz
dd2        .equ  90             ; note  Do#   554,4 Hz
r2         .equ  85             ; note  R    587,3 Hz
rd2        .equ  80             ; note  R#   622,3 Hz
m2         .equ  75             ; note  Mi    659,3 Hz
f2         .equ  71             ; note  Fa    698,5 Hz
fd2        .equ  67             ; note  Fa#   740   Hz
sl2        .equ  63             ; note  Sol   784   Hz
sld2       .equ  59             ; note  Sol#  784   Hz
l2         .equ  56             ; note  La    880   Hz
ld2        .equ  53             ; note  La#   932,3 Hz
s2         .equ  50             ; note  Si    987,8 Hz
d3         .equ  47             ; note  Do   1046,5 Hz

fin        .equ 0               ; dlimiteur de mlodie
pose       .equ 0FFh            ; pose

;-----------------------------------------------------------------------------
;                  Definition des variables en ram $84  $BF
;-----------------------------------------------------------------------------


ram        .def 084h            ; Dbut de la zone RAM
note       .def ram             ; priode de la note courante
tempo      .def note+1          ; tempo de la mlodie
duree      .def tempo+1         ; dure de la note courante
controle   .def duree+1         ; registre d'tat du tempo
temporef   .def controle+1      ; rfrence tempo pour la mlodie courante
adrmesh    .def temporef+1      ; pointeur adresse mlodie en ROM
adrmesl    .def adrmesh+1
touches    .def adrmesl+1       ; mmorisation de la touche enfonce

;-----------------------------------------------------------------------------
;                             Debut du programme
;-----------------------------------------------------------------------------

           .org 080h

tbmelod    .byte  au_clair.w  , au_clair.d
           .byte  fontaine.w  , fontaine.d
           .byte  coqueli.w   , coqueli.d
           .byte  marionnet.w , marionnet.d
           .byte  jacques.w   , jacques.d
           .byte  maman.w     , maman.d
           .byte  le_furet.w  , le_furet.d
           .byte  meunier.w   , meunier.d


; au claire de la lune . . .

au_clair   .byte   tempo80 ,sl1,2,sl1,2,sl1,2,l1,2,s1,4,l1,4,sl1,2,s1,2
           .byte            l1,2,l1,2,sl1,8
           .byte            sl1,2,sl1,2,sl1,2,l1,2,s1,4,l1,4,sl1,2,s1,2
           .byte            l1,2,l1,2,sl1,8
           .byte            l1,2,l1,2,l1,2,l1,2,m1,4,m1,4
           .byte            l1,2,sl1,2,fd1,2,m1,2,r1,8
           .byte            sl1,2,sl1,2,sl1,2,l1,2,s1,4,l1,4,sl1,2,s1,2
           .byte            l1,2,l1,2,sl1,8
           .byte            fin

;  la claire fontaine . . .

fontaine   .byte   tempo90 ,f1,4,f1,2,l1,2,l1,2,sl1,2,l1,2,sl1,2
           .byte            f1,4,f1,2,l1,2,l1,2,sl1,2,l1,4
           .byte            l1,4,l1,2,sl1,2,f1,2,l1,2,d2,2,l1,2
           .byte            d2,4,d2,2,l1,2,f1,2,l1,2,sl1,8
           .byte            f1,4,f1,2,l1,2,l1,2,sl1,1,f1,1,l1,2,f1,2
           .byte            l1,4,l1,2,sl1,1,f1,1,l1,2,sl1,2,f1,8
           .byte            fin

; gentil coquelicot . . .

coqueli    .byte   tempo80 ,l1,2,l1,2,sl1,2,f1,4,l1,4,d2,2,d2,2,sl1,4,pose,2
           .byte            l1,2,l1,2,sl1,2,f1,4,l1,4,d2,2,d2,2,sl1,4,pose,2
           .byte            sl1,2,l1,2,ld1,2,d2,4,d2,4,ld1,2,l1,2,sl1,12
           .byte            sl1,3,f1,1,sl1,2,l1,2,f1,2,f1,2,f1,2,f1,2
           .byte            sl1,3,f1,1,sl1,2,l1,2,f1,2,f1,2,f1,4
           .byte            fin

; les petites marionnettes . . .

marionnet  .byte   tempo80 ,s1,2,s1,2,sl1,4,s1,4,r2,4,d2,2,s1,2,d2,2
           .byte            l1,2,sl1,2,fd1,2,sl1,2,r1,2
           .byte            s1,2,s1,2,sl1,4,s1,4,r2,4,d2,2,s1,2,d2,2
           .byte            l1,2,sl1,2,fd1,2,sl1,4
           .byte            fin

; frre jacques . . .

jacques    .byte  tempo90  ,f1,4,sl1,4,l1,4,f1,4,f1,4,sl1,4,l1,4,f1,4
           .byte            l1,4,ld1,4,d2,8,l1,4,ld1,4,d2,8
           .byte            d2,3,r2,1,d2,2,ld1,2,l1,4,f1,4
           .byte            d2,3,r2,1,d2,2,ld1,2,l1,4,f1,4
           .byte            f1,4,d1,4,f1,8,f1,4,d1,4,f1,8
           .byte            fin

; ah ! vous dirais-je maman . . .

maman      .byte  tempo120 ,d1,4,d1,4,sl1,4,sl1,4,l1,4,l1,4,sl1,8
           .byte            f1,4,f1,4,m1,4,m1,4,r1,4,r1,4,d1,8
           .byte            sl1,4,sl1,4,f1,4,f1,4,m1,4,m1,4,m1,4,r1,4
           .byte            sl1,4,sl1,4,f1,4,f1,4,m1,4,m1,4,m1,4,r1,4
           .byte            d1,4,d1,4,sl1,4,sl1,4,l1,4,l1,4,sl1,8
           .byte            f1,4,f1,4,m1,4,m1,4,r1,4,r1,4,d1,8
           .byte            fin

; le furet du bois joli

le_furet   .byte tempo120  ,d1,2,f1,2,sl1,2,l1,4,sl1,2,sl1,2,r1,4
           .byte            f1,2,m1,2,r1,2,d1,2,r1,2,m1,2,f1,2
           .byte            d1,2,f1,2,sl1,2,l1,4,sl1,2,sl1,2,r1,4
           .byte            f1,2,m1,2,r1,2,d1,2,r1,2,m1,2,f1,4
           .byte            f1,2,m1,2,r1,2,d1,2,r1,2,m1,2,f1,4
           .byte            f1,2,m1,2,r1,2,d1,2,r1,2,m1,2,f1,4,pose,4
           .byte            f1,4,l1,4,f1,8
           .byte            fin

; meunier tu dors

meunier    .byte  tempo100 ,d1,4,f1,12,l1,4,f1,12,sl1,3,sl1,1,sl1,4
           .byte            sl1,3,sl1,1,sl1,4,f1,3,sl1,1,l1,4,f1,4,pose,4
           .byte            d1,4,f1,12,l1,4,f1,12,sl1,3,sl1,1,sl1,4
           .byte            sl1,3,sl1,1,sl1,4,l1,3,sl1,1,f1,8,pose,4
           .byte            l1,3,l1,1,l1,4,l1,3,l1,1,l1,4,l1,3,l1,1,d2,4,d2,8
           .byte            sl1,3,sl1,1,sl1,4,sl1,3,sl1,1,sl1,4
           .byte            d2,3,d2,1,l1,8,pose,4
           .byte            l1,3,l1,1,l1,4,l1,3,l1,1,l1,4,l1,3,l1,1,d2,4,d2,8
           .byte            sl1,3,sl1,1,sl1,4,sl1,3,sl1,1,sl1,4
           .byte            d2,3,d2,1,f1,8
           .byte            fin




; initialisation  PC7       = sortie son tage push-pull, initialis a 0
;                 PC4 a PC6 = entree avec resistance de pull-up
;                 PA et PB  = entree avec resistance de pull-up

init_pgm   ldi wdr,chien          ; rarme le chien de garde
           ldi pcdir,10000000b    ;
           ldi pcopt,10000000b
           clr pc
           ldi tcr,timilli
           ldi tscr,01011110b     ; div. par 64 avec interruption autorise.
           ldi ior,00010000b      ; autorise interruptions masquables.
           reti                   ; revient au mode normal.
start      res t,controle         ; pas de note pour l'instant.

pas_touche jrs bp,pa,pas_touche   ; si bouton pas appuy, on attend
           ldi tempo,tempo140     ; lance tempo pour tre sur que ce n'est
           ldi duree,1            ; pas un rebond . . .
           set t,controle
attend     jrr bp,pa,bp_ok        ; teste si toujours enfonc
           res t,controle         ; non, on recommence la scrutation
           jp pas_touche
bp_ok      jrs t,controle,attend  ; pendant toute la temporisation
           ld a,pa                ; rcupre le numro de la mlodie.
           andi a,07h             ; seuls les bits PA0  PA2 ont une signif.
           sla a                  ; numro multipli par 2 car une adresse
           ldi drwr,tbmelod.w     ; est code sur deux octets dans TBMELOD
           ldi x,tbmelod.d
           add a,x
           ld x,a
           ld a,(x)               ; initialise pointeur de mlodie en ROM
           ld w,a
           inc x
           ld a,(x)
           ld x,a
           ld adrmesl,a
           ld a,w
           ld drwr,a
           ld adrmesh,a

           ld a,(x)               ; c'est parti ! on charge le "tempo"
           ld temporef,a
           ld tempo,a
boite_2    call incadr            ; incrmente l'adresse et rcupre le code
           ld a,(x)               ; de la note.
           jrnz boite_1
           jp start               ; ici, c'est fini . . .
boite_1    cpi a,pose             ; teste si c'est une pose . . .
           jrz pose_ok
           jp pas_pose
pose_ok    call incadr            ; c'est une pose, on attend.
           ld a,(x)
           ld duree,a
           set t,controle
boite_10   jrs t,controle,boite_10
           jp boite_2
pas_pose   ld note,a              ; ce n'est pas une pose, on rcupre
           call incadr            ; la dure de la note.
           ld a,(x)
           ld duree,a
           set t,controle
son_0      ld a,note            ; gnration d'un crneau carr en sortie
           set son,pc           ; "son" du port C
son_2      dec a
           jrnz son_2
           res son,pc
           ld a,note
son_3      dec a
           jrnz son_3
           jrs t,controle,son_0
           clr v                ; cette petite temporisation d'environ 10mS
boite_3    nop                  ; intercale entre chaque note permet de
           nop                  ; sparer les notes les unes des autres.
           nop
           nop
           nop
           nop
           nop
           nop
           nop
           nop
           dec v
           jrnz boite_3
           jp boite_2


; routine d'incrmentation du pointeur de note dans mlodie courante

incadr     inc adrmesl          ; passe au caractre suivant
           jrr 7,adrmesl,inc_1  ; teste si il faut incrmenter le pointeur de
           ldi adrmesl, 40h     ; la fentre en ROM.
           inc adrmesh          ; Si oui, initialise  6 bits de poids failes
inc_1      ld a,adrmesh         ; et incrmente les 6 bits de poids forts.
           ld drwr,a
           ld a,adrmesl
           ld x,a
           ret

; gestion du "tempo" par interruption TIMER :
; Le prdiviseur est initialis  64 et TCR  63 --> I.T. toutes les 6mS

gestim     res tmz,tscr         ; pour la prochaine interruption
           ldi tcr,timilli      ; recharge timer et le chien de garde.
           ldi wdr,chien
           jrs t,controle,tim_2 ; Note en cours d'excution ?
           reti                 ; non, on rentre.
tim_2      dec tempo            ; oui, on dcrmente.
           jrz tim_0
           reti
tim_0      ld v,a
           ld a,temporef
           ld tempo,a
           ld a,v
           dec duree
           jrz tim_4
           reti
tim_4      res t,controle       ; la dure de la note est termine: T = 0
           reti


;-----------------------------------------------------------------------------
;                         Vecteurs d'interruption
;-----------------------------------------------------------------------------

;  ***     CAN     ***
           .org 0FF0h
           reti

;  ***     TIMER   ***
           .ORG 0FF2h
           jp gestim

;  ***     PORTB,C ***
           .org 0FF4h
           reti

;  ***     PORTA   ***
           .org 0FF6h
           reti

;  ***     NMI     ***
           .org 0FFCh
           reti

;  ***     RESET   ***
           .org 0FFEh
           jp init_pgm

           .end
