            .title "COMPTEUR"
            .vers "st6225"
            .input "6225_reg.asm"
            .w_on

;-----------------------------------------------------------------------------
;                       Dfinition des constantes
;-----------------------------------------------------------------------------

chien       .equ 0FEh         ; valeur du chien de garde ( 24 mS environ )
busy        .equ 7            ; flag : busy=1 <=> HD44780 occup !
rs          .equ 6            ; slection instruction/donne ( HD 44780 )
rw          .equ 5            ; slection criture/lecture   ( HD 44780 )
e           .equ 4            ; validation criture/lecture  ( HD 44780 )
gauche      .equ 00011000b    ; dcalage affichage  gauche
droite      .equ 00011100b    ; dcalage affichage  droite
Impulse     .equ 0            ; Flag dtection impulsion (Registre d'tat)
Autoris     .equ 7            ; PB7 = 0  <=>  arrt comptage
Plus1       .equ 6            ; PB6 = 0  <=>  comptage 2 par 2
UpDown      .equ 5            ; PB5 = 0  <=>  dcomptage
LED         .equ 4            ; PB4 = LED connecte

;-----------------------------------------------------------------------------
;                Dfinition des variables en ram $84  $BF
;-----------------------------------------------------------------------------

BaseRam     .def 084h
CT0         .def BaseRam        ; registre compteur 16bits
CT1         .def CT0+1
CPL         .def CT1+1          ; registre de comparaison 16bits
CPH         .def CPL+1
CCT0        .def CPH+1          ; registre de recopie du compteur
CCT1        .def CCT0+1

ASCII0      .def CCT1+1         ; registres pour valeur ASCII du compteur
ASCII1      .def ASCII0+1
ASCII2      .def ASCII1+1
ASCII3      .def ASCII2+1
ASCII4      .def ASCII3+1

adrmesl     .def ASCII4+1       ; pointeurs de messages en EPROM
adrmesh     .def adrmesl+1
curseur     .def adrmesh+1      ; position curseur du caractre suivant
copypb      .def curseur+1      ; image RAM du port B ( diffrents modes )
copypc      .def copypb+1       ; image RAM du port C

RegEtat     .def copypc+1       ; registre d'tat du compteur.

;----------------------------------------------------------------------------
;                   Dfinition des macro-instructions
;----------------------------------------------------------------------------

; Macro d'initialisation des fonctions du micro-contrleur :
;   - mode de fonctionnement des ports parallles A, B et C
;   - mode de fonctionnement du TIMER
;   - mode de fonctionnement du convertisseur Analogique -> Numrique
;   - Validation/Autorisation des interruptions
;   - Mode de fonctionnement de l'afficheur LCD

            .MACRO RESET
            ldi pcdir,11111111b  ; initialisation des ports parallles
            ldi pcopt,01111111b  ; PC7     = sortie drain ouvert
            ldi copypc,00000000b ; PC4  6 = sorties symtriques
            ldi pc,00000000b     ; PA      = sorties symtriques
            ldi pbdir,00010000b  ; PB4     = sortie symtrique
            ldi pbopt,00010001b  ; PB0     = entre avec pull-up et I.T.
            ldi pb,00000000b     ; autres PBi = entres avec pull-up sans I.T.
            ldi copypb,00000000b
            ldi padir,0ffh
            ldi paopt,0ffh
            ldi pa,0
            ldi v,8             ; pose de 60 ms
            call tempo
            ldi a,00110000b     ; initialisation logicielle de l'afficheur
            call outinstr       ; LCD juste au cas o ....
            ldi v,8
            call tempo
            ldi a,00110000b
            call outinstr
            ldi v,8
            call tempo
            ldi a,00110000b
            call outinstr
            ldi v,8
            call tempo
            ldi a,00111000b     ; mode 2 lignes, fonte 5x7
            call ecrinstr
            ldi a,00001000b     ; cran teint
            call ecrinstr
            ldi a,00000110b     ; mode incrmentation curseur
            call ecrinstr
            ldi a,00000001b     ; efface cran + curseur position 00
            call ecrinstr
            clr curseur         ; raz rfrence curseur
            ldi a,00001100b     ; allume cran sans curseur apparent
            call ecrinstr
            clr CT0             ; RAZ compteur 16bits
            clr CT1
            clr RegEtat
            ldi adcr,0          ; pas de CAN
            ldi tscr,00000000b  ; pas de TIMER
            ldi ior,10h         ; autorise interruptions masquables
            reti                ; place le micro-contrleur en mode NORMAL
            .ENDM


; Macro d'effacement de l'cran, curseur en dbut de ligne

            .MACRO CLEARHOME
            ldi a,00000001b
            call ecrinstr
            clr curseur
            .ENDM

; Macro de retour curseur en dbut de ligne

            .MACRO HOME
            ldi a,00000010b
            call ecrinstr
            clr curseur
            .ENDM

; Macro d'envoi d'un message sur l'afficheur LCD  partir de la position
; courante du curseur.

            .MACRO PRINT msg_000 , ?lp5 , ?lp6
            ldi adrmesh,lp5.w
            ldi adrmesl,lp5.d
            call printmes
            jp lp6+1
lp5         .ascii msg_000
lp6         .byte 00
            .ENDM

; Macro d'envoi d'un message sur l'afficheur LCD.
; L'cran est effac et le curseur plac en dbut de ligne avant l'envoi
; du message.

            .MACRO PRINTCR msg_001 , ?lp7 , ?lp8
            ldi a,00000001b
            call ecrinstr
            clr curseur
            ldi adrmesh,lp7.w
            ldi adrmesl,lp7.d
            call printmes
            jp lp8+1
lp7         .ascii msg_001
lp8         .byte 00
            .ENDM

; Macro d'envoi sur l'cran LCD de la valeur ASCII du compteur

            .MACRO PRINTASCII 
            call AsciiOut
            .ENDM

; Macro de temporisation, l'argument est en millisecondes ( de 8ms  2048mS )

            .MACRO POSE pp1
            ldi v,pp1/8
            call tempo
            .ENDM

; Macro d'inhibition de l'affichage LCD

            .MACRO DISPOFF
            ldi a,00001000b
            call ecrinstr
            .ENDM

; Macro de validation de l'affichage LCD

            .MACRO DISPON
            ldi a,00001100b
            call ecrinstr
            .ENDM

; Macro de conversion binaire 16bits en dcimal cod ASCII 5 chiffres

            .MACRO  CONVASCII ?lp30
            ldi w,5
            ldi y,ASCII4
            ldi drwr,TABP10.w
            ldi x,TABP10.d
            ld a,CT0
            ld CCT0,a
            ld a,CT1
            ld CCT1,a
TestLoop    ld a,(x)
            ld CPL,a
            inc x
            ld a,(x)
            ld CPH,a
            inc x
            ldi a,30h
            ld (y),a
TestSuite   ld a,CCT1
            cp a,CPH
            jrz Test0
            jrnc TestSup
            jp TestInf
Test0       ld a,CCT0
            cp a,CPL
            jrnc TestSup
            jp TestInf
TestSup     clr v
            ld a,CCT0
            sub a,CPL
            ld CCT0,a
            jrnc Test1
            ldi v,0FFh
Test1       ld a,CCT1
            sub a,CPH
            add a,v
            ld CCT1,a
            inc(y)
            ldi wdr,chien
            jp TestSuite
TestInf     dec y
            dec w
            jrz lp30+2
lp30        jp TestLoop
            .ENDM


; Macro de comptage

            .MACRO COMPTAGE
            call Increment
            .ENDM

; Macro d'allumage de la LED

            .MACRO LEDON
            ld a, copypb
            set LED,a
            ld copypb,a
            ld pb,a
            .ENDM

; Macro d'extinction de la LED

            .MACRO LEDOFF
            ld a, copypb
            res LED,a
            ld copypb,a
            ld pb,a
            .ENDM



;-----------------------------------------------------------------------------
;[[[[[[[[[[[[[[[[[[[[[[[[[  *  PROGRAMME PRINCIPAL *  ]]]]]]]]]]]]]]]]]]]]]]]]
;-----------------------------------------------------------------------------

           .org 080h

TABP10     .equ $
           .word  10000  ; 10^4     
           .word  01000  ; 10^3
           .word  00100  ; 10^2
           .word  00010  ; 10^1
           .word  00001  ; 10^0

init_pgm   ldi wdr,chien                    ; lance un os au chien de garde
           RESET                            ; initialise tout !
Boucle     .equ $
           CONVASCII                        ; conversion de la valeur compteur
           HOME
           PRINT <"COMPTEUR = ">            ; affichage message
           PRINTASCII                       ; suivi de la valeur du compteur    
Attend     ldi wdr,chien                    ; Attend impulsion sur PB0
           jrr Impulse,RegEtat,Attend
           COMPTAGE                         ; Si impulsion alors comptage
           LEDON                            ; impulsion lumineuse de 20ms
           POSE 20
           LEDOFF
           POSE 70                          ; pose de 70ms
           res Impulse,RegEtat              ; prpare dtection nouv. impulsion
           jp Boucle                        ; c'est reparti pour un tour !

;-----------------------------------------------------------------------------
;[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
;-----------------------------------------------------------------------------

; routine de comptage ou dcomptage

Increment   jrs Autoris,pb,CT_0             ; Arrt comptage ?
            jp CT_F                         ; oui, fin.
                                              
CT_0        ldi v,1                         ; non, test valeur de l'incrment
            jrs Plus1,pb,CT_1               ; V=1 si incrment = 1
            inc v                           ; V=2 si incrment = 2
CT_1        jrs UpDown,pb,CT_2              ; Comptage ou dcomptage ?
            jp CT_3

CT_2        ld a,CT0                        ; comptage :
            add a,v                         ; addition sur 16 bits 
            ld CT0,a                        ; [CT1][CT0] + [00][V]
            jrc CT_4
            jp CT_F
CT_4        ld a,CT1
            addi a,1
            ld CT1,a
            jrnc CT_5
            ldi CT0,0FFh                    ; si rsultat > FFFFh
            ldi CT1,0FFh                    ; alors [CT1][CT0]=FFFFh
CT_5        jp CT_F
            
CT_3        ld a,CT0                        ; Dcomptage :
            sub a,v                         ; soustraction sur 16 bits
            ld CT0,a                        ; [CT1][CT0] - [00][V]
            jrc CT_6
            jp CT_F
CT_6        ld a,CT1
            subi a,1
            ld CT1,a
            jrnc CT_F                       ; si rsultat < 0000h
            ldi CT0,0                       ; alors [CT1][CT0]=0000h
            ldi CT1,0
CT_F        ret                             ; retour


; Impression valeur ASCII 5 chiffres

AsciiOut    ldi x,ASCII4                    ; transmet les 5 chiffres
            ldi y,5                         ; contenus dans ASCII0  ASCII4
AscOut0     ld a,(x)                        ; vers l'afficheur LCD.
            call ecridata                   ; ASCII4=MSB et ASCII0=LSB
            dec x
            dec y
            jrnz AscOut0
            ret                             ; retour

; Temporisation logicielle programmable de 8ms  256*8ms # 2S par bonds
; de 8 ms. Le nombre de 8 millisecondes doit tre charg dans V avant
; l'appel de la routine "tempo". ( valable pour Quartz 8MHz )

tempo       ldi w,224
temp0       ldi wdr,chien
            nop
            nop
            nop
            dec w
            jrnz temp0
            dec v
            jrnz tempo
            ret

; Test du bit d'tat BUSY de l'afficheur LCD
; L'tat de l'indicateur BUSY est renvoy dans la CARRY

testbusy    ldi wdr,chien
            clr padir            ; port A en entre car on effectue une lecture
            clr paopt
            ldi pa,255           ; sans rsistances de rappel ni interruption

            ld a,copypc          ; travaille sur image du port C
            res rs,a             ; impose RS = 0 car c'est une instruction
            res e,a              ; impose  E = 0 pour le moment
            set rw,a             ; impose RW = 1 ( lecture )
            ld copypc,a
            ld pc,a

            ld a,copypc
            set e,a              ; impose  E = 1 ( validation de la lecture )
            ld copypc,a
            ld pc,a              ; c'est envoy ...
            nop
            nop

            ld a,pa              ; lit l'tat du processeur graphique
            ld v,a               ; et le sauvegarde

            ld a, copypc         ; inhibe la lecture en cours
            res e,a
            ld copypc,a
            ld pc,a

            ld a, copypc         ; annule l'action de lecture en cours
            res rw,a
            ld copypc,a
            ld pc,a

            ldi padir,255        ; reconfigure port A en sortie symtrique
            ldi paopt,255
            clr pa
            ldi wdr,chien
            jrs busy,v,fintest   ; transfert : CARRY = BUSY
fintest     ret



; Routine d'criture d'une instruction  destination de l'afficheur LCD
; L'instruction  crire est contenu dans l'accu A
; ( initialement E = RW = RS = 0 , c'est l'tat par dfaut ! )
; REM : l'entre en OUTINSTR permet d'crire une instruction sans tenir
;       compte de l'tat de BUSY ( c'est le cas lors d'une initilisation
;       logicielle ).

ecrinstr    ld w,a               ; sauvegarde l'instruction  crire
ecr_0       call testbusy        ; test si le 44780 travaille
            jrc ecr_0            ; oui, on attend
            ld a,w               ; rcupre le code de l'instruction
outinstr    ld pa,a              ; non, impose l'instruction  crire
            ld a,copypc          ; travaille sur image du port C
            set e,a              ; impose  E = 1 pour valider l'criture
            ld copypc,a
            ld pc,a
            nop
            nop
            ld a,copypc          ; travaille sur image du port C
            res e,a              ; impose  E = 0 pour valider l'criture
            ld copypc,a          ; ( l'criture se fait sur front descendant )
            ld pc,a
            nop
            nop
            clr pa               ; annule l'instruction ( histoire de ...)
            ldi wdr,chien
            ret



; Routine d'criture d'une donne  destination de l'afficheur LCD
; La donne  crire est contenu dans l'accu A
; ( initialement E = RW = RS = 0 , c'est l'tat par dfaut ! )

ecridata    ldi wdr,chien
            ld w,a               ; sauvegarde la donne  crire
ecr_4       call testbusy
            jrc ecr_4
            ld a,w               ; rcupre la donne
            ld pa,a              ; impose la donne  crire
            ld a,copypc          ; travaille sur image du port C
            set rs,a             ; impose RS = 1 ( tranfert de donnes )
            ld copypc,a
            ld pc,a
            nop
            nop
            ld a,copypc          ; travaille sur image du port C
            set e,a              ; impose  E = 1 pour valider l'criture
            ld copypc,a
            ld pc,a
            nop
            nop
            ld a,copypc          ; travaille sur image du port C
            res e,a              ; impose  E = 0 pour valider l'criture
            ld copypc,a          ; ( l'criture se fait sur front descendant )
            ld pc,a
            nop
            nop
            ld a,copypc          ; travaille sur image du port C
            res rs,a             ; impose  RS = 0
            ld copypc,a
            ld pc,a
            nop
            nop
            inc curseur          ; incrmente position curseur
            ld a,curseur         ; non, teste si position curseur >= 8
            cpi a,8
            jrnz ecr_5
            ldi a,80h+40h        ; oui, saut  la 2ime partie de l'cran
            jp ecrinstr          ; le RET se fera en fin de routine ECRINSTR
ecr_5       clr pa               ; raz port A, juste pour le fun ...
            ret

; routine d'mission d'une chaine de caractres en zone ROM
; ADRMESH  doit contenir les 6 bits de poids forts de l'adresse du message
; ADRMESL  doit contenir les 6 bits de poids faibles de l'adresse du message
; Le message doit se terminer par le caractre nul 00h
; Les registres utiliss sont : A , X
; L'appel est de la forme :  LDI ADRMESH, @.W
;                            LDI ADRMESL, @.D
;                            CALL PRINTMES

printmes    ld a,adrmesl
            ld x,a
pmes_1      ld a,adrmesh         ; recupre adresse du caractere courant
            ld drwr,a
pmes_2      ld a,(x)             ; recupre caractre courant du message
            jrnz pmes_0          ; si fin de message on rentre  la maison !
            ret
pmes_0      call ecridata        ; envoit le caractre sur afficheur LCD
            inc x                ; passe au caractre suivant
            jrr 7,x,pmes_2       ; teste si il faut incrmenter le pointeur de
            ldi x,40h            ; la fentre en ROM.
            inc adrmesh          ; Si oui, initialise  6 bits de poids failes
            jp pmes_1            ; et incrmente les 6 bits de poids forts.

; routine d'interruption du port B

Detecte     jrr Impulse,RegEtat,detect0
            reti
detect0     set Impulse,RegEtat
            reti


;----------------------------------------------------------------------------
;                        Vecteurs d'interruption
;----------------------------------------------------------------------------

;  ***     CAN     ***
           .org 0FF0h
           nop
           reti

;  ***     TIMER   ***
           .ORG 0FF2h
           reti

;  ***     PORTB,C ***
           .org 0FF4h
           jp Detecte

;  ***     PORTA   ***
           .org 0FF6h
           nop
           reti

;  ***     NMI     ***
           .org 0FFCh
           nop
           reti

;  ***     RESET   ***
           .org 0FFEh
           jp init_pgm

           .end
