;****************************************************************************
;                 microcontroleur ST6 de SGS-THOMSON
;
;
; Prediviseur = 16 , TCR(timer) = timilli = 42 , donc l'interruption se
;                       12
; produit toutes les  ------- * 16 * 63 = 1,5 mS pour FQuartz = 8 Mhz.
;                     FQuartz
;
;****************************************************************************


           .title "animation limuneuse matricielle"
           .vers "st6225"
           .input "6225_reg.asm"
           .w_on

;------------------------------------------
;       definition des constantes
;------------------------------------------

chien      .equ 0FEh         ; valeur du chien de garde
tmz        .equ 7            ; mis a 1 quand Timer(TCR) passe a 0.
timilli    .equ 63           ; pour interruption Timer toutes les 1,5 mS
tempo      .equ 100
t          .equ 0            ; bit d'tat : fin de temporisation


;------------------------------------------
; definition des variables en ram $84  $BF
;------------------------------------------


colonne    .def 084h
image      .def colonne+1
image1     .def image+1
image2     .def image1+1
image3     .def image2+1
image4     .def image3+1
image5     .def image4+1
image6     .def image5+1
image7     .def image6+1
delai      .def image7+1
ct1        .def delai+1
ct2        .def ct1+1
status     .def ct2+1
sav_a      .def status+1
sav_x      .def sav_a+1
count0     .def sav_x+1
count1     .def count0+1
adrmesl    .def count1+1
adrmesh    .def adrmesl+1
blkmap     .def adrmesh+1
blkmap1    .def blkmap+1
blkmap2    .def blkmap1+1
blkmap3    .def blkmap2+1
blkmap4    .def blkmap3+1
blkmap5    .def blkmap4+1
blkmap6    .def blkmap5+1
blkmap7    .def blkmap6+1
cblink     .def blkmap7+1
blkdelai   .def cblink+1
int_a      .def blkdelai+1
int_x      .def int_a+1
int_y      .def int_x+1
int_v      .def int_y+1
ptpile     .def int_v+1
pile       .def ptpile+1

;------------------------------------------
;           Macro-instructions
;------------------------------------------

;utilisation : setxy  xx , yy

           .MACRO  setxy xx , yy
           ldi x,xx
           ldi y,yy
           call set_xy
           .ENDM



;utilisation : resxy  xx , yy

           .MACRO  resxy xx , yy
           ldi x,xx
           ldi y,yy
           call res_xy
           .ENDM

;utilisation : delay   dure

           .MACRO delay  dd , ?lab1
           ldi delai,dd
           set t,status
lab1       jrs t,status,lab1
           .ENDM



           .MACRO cligno dd
           ldi blkdelai,dd
           ldi ct2,dd
           .ENDM

           .MACRO setimage c1,c2,c3,c4,c5,c6,c7,c8
           ldi image,c1
           ldi image1,c2
           ldi image2,c3
           ldi image3,c4
           ldi image4,c5
           ldi image5,c6
           ldi image6,c7
           ldi image7,c8
           .ENDM


           .MACRO setblink c1,c2,c3,c4,c5,c6,c7,c8
           ldi blkmap,c1
           ldi blkmap1,c2
           ldi blkmap2,c3
           ldi blkmap3,c4
           ldi blkmap4,c5
           ldi blkmap5,c6
           ldi blkmap6,c7
           ldi blkmap7,c8
           .ENDM





;------------------------------------------
;           debut du programme
;------------------------------------------

           .org 080h

; --[ Definition de la table des bits de masquage ]--

maskbit1   .byte   1 , 2 , 4 , 8 , 16 , 32 , 64 , 128
maskbit0   .byte   0FEh , 0FDh , 0FBh , 0F7h , 0EFh , 0DFh , 0BFh , 7Fh

; --[ Initialisation du mode de fonctionnment et des variables ]--

init_pgm   ldi wdr,chien
           ldi padir,255
           ldi paopt,255
           clr pa
           clr pbdir
           clr pbopt
           clr pb
           ldi pcdir,7Fh          ; PC7 en entre, les autres en sortie
           ldi pcopt,7Fh          ; les sorties sont symtriques
           clr pc
           clr colonne
           setimage 0,0,0,0,0,0,0,0
           setblink 0,0,0,0,0,0,0,0
           clr status

           ldi ptpile,pile        ; init. pointeur pile utilisateur
           ldi cblink,0

           ldi tscr,01011100b     ;div par 16 avec interruption autorisee
           ldi ior,00010000b      ;autorise interruptions masquables
           reti                   ; ! retour au mode normal !!! ( autorise IT)


; --[  EXEMPLE D'ANIMATION LUMINEUSE ( corps du programme ) ]--

debut     .equ $

          ldi y,0
          call setliney
          ldi y,7
          call setliney
          ldi x,0
          call setlinex
          ldi x,7
          call setlinex
          delay 200
          cligno 180
          setblink 255,81h,81h,81h,81h,81h,81h,255
          delay 200
          setimage 0,0,0,0,0,0,0,0
          cligno 80
          setblink 0,0,0,0,255,255,255,255
          call inv_img
          delay 200
          setimage 0,0,0,0,0,0,0,0
          ldi y,0
          ldi count0,8
suite_5   call setliney
          delay 9
          call resliney
          inc y
          dec count0
          jrz suite_4
          jp suite_5
suite_4   setimage 33h,0cch,33h,0cch,33h,0cch,33h,0cch
          delay 50
          ldi count0,8
          ldi x,0
suite_7   call setlinex
          delay 9
          call reslinex
          inc x
          dec count0
          jrz suite_15
          jp suite_7
suite_15  setimage 0,0,0,0,0,0,0,0
          setxy 0,0
          delay 15
          setxy 2,7
          delay 15
          setxy 5,3
          delay 15
          setxy 7,7
          delay 15
          setxy 1,4
          delay 15
          setxy 4,3
          delay 15
          setxy 6,1
          delay 15
          setxy 5,5
          delay 15
          setimage 0,0,0,0,0,0,0,0
          ldi y,3
          call setliney
          ldi y,4
          call setliney
          ldi x,3
          call setlinex
          ldi x,4
          call setlinex
          delay 100
          cligno 120
          setblink 20h,60h,0A0h,0BFh,0A9h,0EAh,6Ch,28h
          setimage 20h,60h,0A0h,0BFh,0A9h,0EAh,6Ch,28h
          delay 150
          setimage 0,0,0,0,0,0,0,0
          setblink 0,0,0,0,0,0,0,0
          ldi count0,8
          ldi y,0
conti_8   call setliney
          delay 10
          inc y
          dec count0
          jrz conti_9
          jp conti_8
conti_9   ldi count0,8
          ldi y,0
conti_10  call resliney
          delay 10
          inc y
          dec count0
          jrz conti_11
          jp conti_10

conti_11  ldi count0,8
          ldi x,0
conti_12  call setlinex
          delay 10
          inc x
          dec count0
          jrz conti_13
          jp conti_12
conti_13  ldi count0,8
          ldi x,0
conti_14  call reslinex
          delay 10
          inc x
          dec count0
          jrz conti_15
          jp conti_14
conti_15  jp debut



; --[ routines diverses et varies ]--


; routine d'inversion vido ( en ram cran )

inv_img    call push
           ldi v,8
           ldi y,image
inv_img0   ld a,(y)
           com a
           ld (y),a
           inc y
           dec v
           jrnz inv_img0
           call pull
           ret

; routine d'allumage d'un point en coordonne x,y
; ( X contient X, Y contient Y )

set_xy     call push
           ld a,x
           addi a,image
           ld x,a
           ldi drwr,maskbit1.w   ; pointe, via reg. Y, la table des masques
           ldi a,maskbit1.d
           add a,y
           ld y,a                ; Y pointe masque relatif au bit  mettre  1
           ld a,(x)
           and a,(y)
           jrnz set_xy0          ; si le bit est dj  1, on ne fait rien !
           ld a,(x)
           add a,(y)
           ld (x),a
set_xy0    call pull
           ret


; routine d'extinction d'un point en coordonne x,y
; ( X contient X, Y contient Y )

res_xy     call push
           ld a,x
           addi a,image
           ld x,a
           ldi drwr,maskbit0.w   ; pointe, via reg. Y, la table des masques
           ldi a,maskbit0.d
           add a,y
           ld y,a                ; Y pointe masque relatif au bit  mettre  1
           ld a,(x)
           and a,(y)
           ld (x),a
           call pull
           ret

; routine d'allumage d'une ligne horizontale
; (  Y contient le numro de la ligne )

setliney   call push
           ldi x,7
sly0       call set_xy
           dec x
           jrr 7,x,sly0
           call pull
           ret

; routine d'allumage d'une ligne verticale
; (  X contient le numro de la colonne )

setlinex   call push
           ldi a,image
           add a,x
           ld x,a
           ldi a,0FFh
           ld (x),a
           call pull
           ret

; routine d'extinction d'une ligne horizontale
; (  Y contient le numro de la ligne )

resliney   call push
           ldi x,7
rly0       call res_xy
           dec x
           jrr 7,x,rly0
           call pull
           ret


; routine d'extinction d'une ligne verticale
; (  x contient le numro de la colonne )

reslinex   call push
           ldi a,image
           add a,x
           ld x,a
           clr a
           ld (x),a
           call pull
           ret



; routine de sauvegarde des registres X,Y,A,V,W dans pile utilisateur

push       ld sav_a,a            ; sauvegarde temporaire de A
           ld a,x                ; sauvegarde temporaire de X
           ld sav_x,a
           ld a,ptpile           ; rcupre le pointeur de pile
           ld x,a
           ld a,sav_x            ; sauvegarde de X
           ld (x),a
           inc x
           ld a,y                ; sauvegarde de Y
           ld (x),a
           inc x
           ld a,sav_a            ; sauvegarde de A
           ld (x),a
           inc x
           ld a,v                ; sauvegarde de V
           ld (x),a
           inc x
           ld a,W                ; sauvegarde de W
           ld (x),a
           inc X
           ld a,x
           ld ptpile,a           ; nouvelle valeur du pointeur de pile
           ld a,sav_x            ; la routine PUSH est totalement
           ld x,a                ; transparente pour l'appel.
           ld a,sav_a
           ret


; Routine de restoration des registres sauvegards par PUSH
; cette routine n'autorise pas le passage de paramtres par les
; regsitres puisqu'ils sont tous restors...!

pull       ld a,ptpile           ; rcupre le pointeur de pile
           ld x,a
           dec x
           ld a,(x)
           ld w,a                ; restore W
           dec x
           ld a,(x)
           ld v,a                ; restore V
           dec x
           ld a,(x)
           ld sav_a,a            ; restore A
           dec x
           ld a,(x)
           ld y,a                ; restore Y
           dec x
           ld a,(x)
           ld sav_x,a            ; restore X
           ld a,x                ; nouvelle valeur pointeur de pile
           ld ptpile,a
           ld a,sav_x
           ld x,a
           ld a,sav_a
           ret



; gestion de l'interruption TIMER : rafraichissement de l'cran 8x8

gestim     res tmz,tscr
           ldi tcr,timilli
           ldi wdr,chien
           ld int_a,a
           ld a,x
           ld int_x,a
           ld a,y
           ld int_y,a
           ld a,v
           ld int_v,a
           jrr t,status,gest_2
           dec ct1
           jrnz gest_2
           ldi ct1,20
           dec delai
           jrnz gest_2
           res t,status
gest_2     dec ct2
           jrnz gest_3
           ld a,blkdelai
           ld ct2,a
           ld a,cblink
           com a
           ld cblink,a
gest_3     clr pa
           inc colonne
           ld a,colonne
           cpi a,8
           jrc gest_0
           clr colonne
           clr a
gest_0     sla a                 ; envoyer sur 4 bits MSB du port C
           sla a
           sla a
           sla a
           andi a,7Fh            ; conserve PC7 en entre
           ld pc,a
           ld a,colonne
           addi a,image
           ld x,a
           ld a,(x)
           ld v,a
           ld a,colonne
           addi a,blkmap
           ld x,a
           ld a,(x)
           and a,cblink
           com a
           and a,v
           ld pa,a
           ld a,int_v
           ld v,a
           ld a,int_y
           ld y,a
           ld a,int_x
           ld x,a
           ld a,int_a
           reti


; --[   Dfinition des images utilises dans l'exemple d'animation ]--

carre0     .byte  00000000b
           .byte  00000000b
           .byte  00000000b
           .byte  00011000b
           .byte  00011000b
           .byte  00000000b
           .byte  00000000b
           .byte  00000000b

carre1     .byte  00000000b
           .byte  00000000b
           .byte  00111100b
           .byte  00100100b
           .byte  00100100b
           .byte  00111100b
           .byte  00000000b
           .byte  00000000b

carre2     .byte  00000000b
           .byte  01111110b
           .byte  01000010b
           .byte  01000010b
           .byte  01000010b
           .byte  01000010b
           .byte  01111110b
           .byte  00000000b

carre3     .byte  11111111b
           .byte  10000001b
           .byte  10000001b
           .byte  10000001b
           .byte  10000001b
           .byte  10000001b
           .byte  10000001b
           .byte  11111111b

;------------------------------------------
;  vecteurs d'interruption
;------------------------------------------

;  ***     CAN     ***
           .org 0FF0h
           reti

;  ***     TIMER   ***
           .ORG 0FF2h
           jp gestim

;  ***     PORTB,C ***
           .org 0FF4h
           reti

;  ***     PORTA   ***
           .org 0FF6h
           reti

;  ***     NMI     ***
           .org 0FFCh           
           reti

;  ***     RESET   ***
           .org 0FFEh
           jp init_pgm

           .end
