           .title "interface serie 16 entrees logiques"
           .vers  "st6225"
           .input "6225_reg.asm"
           .w_on


;        ================================================================
;        |  Interface 16 entres  liaison serie asynchrone 1200 bauds  |
;        ================================================================
;
;                        microcontroleur ST6 de SGS-THOMSON
;
; PROTOCOLE DE COMMUNICATION
;
; Les commandes sont dfinis  l'aide de caractres ASCII, ceci afin de
; minimiser les erreurs d'interprtation due  des erreurs de transmission.
; La vitesse de transmission peu leve contribue galement  minimiser les
; erreurs de transmission.
;
; LG    : Lecture de l'tat logique de toutes les entres ("G" pour globale)
; Lxx   : Lecture de l'tat logique de l'entre numro xx (xx=01,..., 16 )
; R     : Teste de la transmission srie
;
;
; TRANSMISSION SERIE ASYNCHRONE
;
; Vitesse de transmission determinee par le temps d'execution des instructions
;
;                                      13
; Temps d'un cycle instruction Tcy = -------
;                                    Fquartz
;
; Toutes les instructions necessite 4 cycles Tcy sauf :
;
; - JRxx (sauts relatifs), RET, RETI, STOP, WAIT   :   2 Tcy
; - JRR,JRS ( sauts relatifs selon etat d'un bit ) :   5 Tcy
;
;                                         1
; Temps de transmission d'un bit Tbit =  ----
;                                        baud
;
;      ------------------------------------------------------------
;      |  EMISSION: Dtermination des constantes de temporisation |
;      ------------------------------------------------------------
;
;                                                              Fquartz
; START BIT:  Tbit = (6 * Tempbit0 + 30) * Tcy  ==> Tempbit0 = ------- - 5
; ----------                                                   78*Baud
;
;                                                              Fquartz
; BIT :       Tbit = (6 * Tempbit1 + 48) * Tcy  ==> Tempbit1 = ------- - 8
; ---                                                          78*Baud
;
;                                                              Fquartz
; STOP  BIT:  Tbit = (6 * Tempbit2 + 04) * Tcy  ==> Tempbit2 = ------- - 0,7
; ----------                                                   78*Baud
;
;
;
; tableau recapitulatif pour differentes vitesses de transmission avec
; un quartz de 8,000 Mhz
;
;      ------------------------------------------------
;      | Baud   |  tempbit0  |  tempbit1  |  tempbit2 |
;      |--------|------------|------------|-----------|
;      |  600   |   166      |   163      |   170     |
;      | 1200   |    80      |    77      |    84     |
;      | 2400   |    38      |    35      |    42     |
;      ------------------------------------------------
;

;      ------------------------------------------------------------
;      | RECEPTION: Dtermination des constantes de temporisation |
;      ------------------------------------------------------------
;
;                 Tbit                                          Fquartz
; 1/2 START BIT:  ---- = ( 15* Tempbit0) * Tcy  ==> Tempbit0 = -----------
; -------------     2                                           390 * Baud
;
;                                                              Fquartz
; BIT 0 :     Tbit = (10* Tempbit1 + 24) * Tcy  ==> Tempbit1 = ------- - 2,4
; ---                                                          130*Baud
;
;                                                              Fquartz
; BIT 1  7 : Tbit = (10* Tempbit1 + 47) * Tcy  ==> Tempbit1 = ------- - 4,7
; ---                                                          130*Baud
;
; cette dernire est utilise pour dterminer Tempbit1
;                                                              Fquartz
; STOP  BIT:  Tbit = (10* Tempbit2 + 08) * Tcy  ==> Tempbit2 = ------- - 0,8
; ----------                                                   130*Baud
;
;
;
; tableau recapitulatif pour differentes vitesses de transmission avec
; un quartz de 8,000 Mhz
;
;      ------------------------------------------------
;      | Baud   |  tempbit0  |  tempbit1  |  tempbit2 |
;      |--------|------------|------------|-----------|
;      |  600   |    34      |    98      |   101     |
;      | 1200   |    17      |    47      |    50     |
;      | 2400   |    09      |    21      |    25     |
;      ------------------------------------------------
;
;
; CONFIGURATION DES ENTREES ET DES SORTIES
; ----------------------------------------
;
; Les 16 entres sont constitues par les 8 bits du port A et du port B.
;
; Voici la table de configuration des ports A, B et C :
;
;  port A :  Tous les bits en entre avec R de rappel et sans IT
;  port B :  Tous les bits en entre avec R de rappel et sans IT
;  port C :  PC7 en sortie symtrique ( TX )
;            Rem : La sortie TX est initialise a 1 par dfaut
;            PC6 en entre sans rsistance de rappel ni IT
;            PC5 et PC4 : en entre avec R de rappel ni I.T
;
;  !---------!-------------------!-----------------!------------------!
;  ! ....... !  DDR  direction   !   OR   option   !  DR   donnees    !
;  !---------!-------------------!-----------------!------------------!
;  ! port A  !  00000000 =   00h ! 00000000 = 00h  ! 00000000 = 00h   !
;  !---------!-------------------!-----------------!------------------!
;  ! port B  !  00000000 =   00h ! 00000000 = 00h  ! 00000000 = 00h   !
;  !---------!-------------------!-----------------!------------------!
;  ! port C  !  10000000 =   80h ! 10000000 = 80h  ! 10000000 = 80h   !
;  !---------!-------------------!-----------------!------------------!


;------------------------------------------------------------------------------
;                         Definition des constantes
;------------------------------------------------------------------------------

chien      .equ 0FEh             ; valeur du chien de garde  la valeur maxi.
tbit0_e    .equ 80               ; tempo start bit  ( pour 1200 bauds )
tbit1_e    .equ 77               ; tempo bit        ( pour 1200 bauds )
tbit2_e    .equ 84               ; tempo stop bit   ( pour 1200 bauds )
tbit0_r    .equ 17               ; tempo 1/2 start  ( pour 1200 bauds )
tbit1_r    .equ 47               ; tempo bit        ( pour 1200 bauds )
tbit2_r    .equ 50               ; tempo stop bit   ( pour 1200 bauds )
rx         .equ 6                ; PC6 = RX
tx         .equ 7                ; PC7 = TX
err	   .equ 7		 ; b7 de ETAT = erreur de rception

;------------------------------------------------------------------------------
;                  Definition des variables en ram $84  $BF
;------------------------------------------------------------------------------


copypc     .def 084h             ; pour maniplation bits du port C
caracter   .def copypc+1         ; Sauvegarde caractere emis./recep.
port       .def caracter+1       ; Numro du port command
etat	   .def port+1		 ; mot d'tat ( b7 = erreur de rception )
var1	   .def etat+1		 ; variable d'usage gnral
var2	   .def var1+1		 ; variable d'usage gnral

;------------------------------------------------------------------------------
;                                 Programme
;------------------------------------------------------------------------------

           .org 080h


; -- Definition de la table des bits de masquage --

maskbit1   .byte   1 , 2 , 4 , 8 , 16 , 32 , 64 , 128
maskbit0   .byte   0FEh , 0FDh , 0FBh , 0F7h , 0EFh , 0DFh , 0BFh , 7Fh




init_pgm   ldi wdr,chien
           clr a
           ld padir,a
           ld paopt,a
           ld pa,a
           ld  pbdir,a   
           ld  pbopt,a   
           ld  pb,a
           ldi pcdir,80h
           ldi pcopt,80h
           ldi pc,80h
           ldi copypc,80h
           clr ior

; Rem: on reste en mode NMI (pas de RETI) car aucune I.T. n'est utilise !

interp     res err,etat          ; init. indicateur d'erreur avant opration
           call recep		 ; attend commande
           cpi a,'R'             ; est-ce un test de liaison srie ?
           jrz TestL             ; oui, interprete commande courante
           jp Lecture            ; non, va voir si autre commande.
TestL      ldi a,'O'
           call emis
           jp interp

Lecture    cpi a,'L'             ; est-ce commande de lecture ?
           jrz Lectur_ok         ; oui, interprte commande.
           jp interp             ; non, commande inconnue
Lectur_ok  call numero           ; un numro suit-il la commande ?
           jrs err,etat,Lec_0    ; non, va voir si commande globale
           jp Lec_ind            ; oui, interprete la commande
Lec_0      cpi a,'G'             ; est-ce une commande globale ?
           jrz Lec_1             ; oui, va lirer toutes les entres
           jp interp             ; non, commande inconnue !
Lec_1      ld a,pb
           call ehexa8           ; lecture de toutes les entres.
           ld a,pa    
           call ehexa8
           jp interp		 ; fin interprtation globale.
Lec_ind    ldi drwr,maskbit1.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit1.d
           add a,x
           ld x,a                ; X pointe masque relatif au bit  mettre  1
           ld a,port
           cpi a,1               ; dtermine le port concern.
           jrz port1_2
           jp port2_2
port1_2    ld a,pa               ; le port A est concern . . .
           and a,(x)
           jrnz Lecind1          ; si le bit est  1 on emet '1' sinon '0'.
           ldi a,'0'
           call emis
           jp interp
Lecind1    ldi a,'1'
           call emis 
           jp interp             ; fin de l'interprtation.
port2_2    ld a,pb               ; le port B est concern . . .
           and a,(x)
           jrnz Lecind2          ; si le bit est  1 on emet '1' sinon '0'.
           ldi a,'0'
           call emis
           jp interp
Lecind2    ldi a,'1'
           call emis
           jp interp             ; fin de l'interprtation.



; -- Routine de rception d'un nombre ASCII compris entre 1 et 16  --
; -- Le format des nombres est le suivant:   01, 02, ... , 15, 16  --
; -- Le numro du bit-1 est retourn dans l'accu.A et le numro du --
; -- port est retourn dans la variable "port" ( 1=portA, 2=portB) --


numero     call recep            ; saisie du premier chiffre
           cpi a,'0'		 ; est-ce le chiffre "0" ?
           jrz num_1             ; oui, alors numro compris entre 01 et 09
           jp num_10             ; non, alors numro compris entre 10 et 16
num_1      call recep            ; numro commenant par 0, alors attend 1  9
           cpi a,'1'             ; si ce n'est pas le cas, il y a erreur !
           jrnc num_2
           jp num_err
num_2      cpi a,'9'
           jrz num_3
           jrc num_3
           jp num_err
num_3      andi a,0Fh            ; rcupre la valeur relle ( 1  9 )
           jp num_port           ; et va dterminer quel port est affect.
num_10     cpi a,'1'	         ; numro commanant par 1, alors attend 0  6
           jrz num_11		 ; si ce n'est pas le cas, il y a erreur !
           jp num_err
num_11     call recep
           cpi a,'0'
           jrnc num_12
           jp num_err
num_12     cpi a,'7'
           jrc num_13
           jp num_err
num_13     andi a,0Fh            ; rcupre la valeur relle ( 10  16 )
           addi a,10
num_port   cpi a,9               ; si numro < 9  alors c'est le port A qui
           jrnc num_14		 ; est concern, dans le cas contraire c'est
           ldi port,1		 ; le port B ( 1 = port A , 2 = port B )
           dec a                 ; l'accu. A contient le numro du bit affect
           ret			 ; et la variable "port" le numro du port.
num_14     subi a,8
           dec a
           ldi port,2
           ret
num_err    set err,etat		 ; l'indicateur d'erreur est actif.
           ret



; -- Routine de rception d'un nombre hexa. 8 bit cod par des caractres --
; -- ASCII.  exemple : A (41h) 2 (32h) ---> A2h


rhexa8     call recep            ; saisie du premier quartet
	   call testhexa	 ; teste si caractre = 0..9 ou A..F
           jrr err,etat,rhx0	 ; si oui, on continue.
           ret
rhx0	   sla a		 ; dcalage  gauche de 4 bits ( quartet MSB )
	   sla a
	   sla a
	   sla a
           ld var1,a		 ; sauvegarde du rsultat
           call recep		 ; saisie du second quartet
           call testhexa         ; teste si caractre = 0..9 ou A..F
           jrr err,etat,rhx1     ; oui, on continue.
           ret
rhx1	   add a,var1            ; runi le tout en un nombre hexa de 8 bits.
	   ld var1,a		 ; sauvegard dans la variable "var1".
           ret



; -- Routine de test si nombre hexa, avec conversion ASCii -> binaire


testhexa   cpi a,'0'
	   jrnc thx0
	   set err,etat
	   ret
thx0	   cpi a,'G'
	   jrc thx1
           set err,etat
           ret
thx1	   cpi a,'9'+1
	   jrnc thx2
           subi a,'0'
           ret
thx2	   cpi a,'A'
	   jrnc thx3
           set err,etat
           ret
thx3	   subi a,37h
	   ret


; -- Routine d'mission d'un nombre hexa. 8 bit sous forme ASCI --
; --  deux caractres.  exemple : A2h --->  A (41h) 2 (32h)    --

ehexa8     ld var1,a             ; sauvegarde temporaire
           rlc a                 ; ne possdant pas de dcalage  droite,
           rlc a                 ; on effectue 5 dcalage  gauche  travers
           rlc a                 ; la retenue ( carry ) afin de permuter les
           rlc a                 ; 4 bits de poids fort avec ceux de poids
           rlc a                 ; faible ... ruse de sioux !
           andi a,0fh            ; transmet ainsi les 4 bits MSB sous forme
           addi a,'0'            ; ASCII.
           cpi a,'9'+1           ; selon valeur, emet 0..9 ou bien A..F
           jrc ehx_0
           addi a,7
ehx_0      call emis
           ld a,var1             ; maintenant on va emettre les 4 bits LSB
           andi a,0fh            ; c'est plus rapide.
           addi a,'0'
           cpi a,'9'+1
           jrc ehx_1
           addi a,7
ehx_1      call emis
           ret



; -- Routine de rception d'un caractre par liaison srie asynchrone       --
; -- Le caractre recu est sauvegard dans l'accu A et la variable caracter --


recep      ldi drwr,maskbit0.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit0.d
recep_0    ldi v,tbit0_r         ; reception bit de start ( tempo reg. V )
           ldi wdr,chien
recep_1    jrs rx,pc,recep_0     ; attend start bit
           ldi wdr,chien
           dec v                 ; tempo start bit
           jrnz recep_1
           ldi w,8               ; initialise le compteur de bits a 8
           ldi wdr,chien         ; relance le chien de garde
           clr a
           com a
           ld  caracter,a        ; initialise caratre reu
recep_2    ldi v,tbit1_r
recep_6    ldi wdr,chien
           dec v
           jrnz recep_6
           ld a,caracter
           jrs rx,pc,recep_3
           and a,(x)
           jp recep_4
recep_3    nop
           nop
recep_4    ld caracter,a
           inc x
           dec w
           jrz recep_5
           jp recep_2
recep_5    ldi v,tbit2_r
recep_7    ldi wdr,chien
           dec v
           jrnz recep_7
           ld a,caracter
           ret


; -- routine d'emission d'un caractere par liaison serie asynchrone --
; -- le caractere a transmettre doit etre charge dans l'accu A      --


emis       ld caracter,a        ; sauvegarde caractere a emettre
           ldi drwr,maskbit1.w  ; pointe, via reg. X, la table des masques
           ldi x,maskbit1.d
           ldi v,tbit0_e        ; emission bit de start ( tempo reg. V )
           res tx,copypc        ; force TX = 0 en conservant la configuration
           ld a,copypc          ; des entrees/sorties
           ld pc,a
emis_0     dec v                ; tempo start bit
           jrnz emis_0
           ldi w,8              ; initialise le compteur de bits a 8
emis_1     ldi wdr,chien        ; relance le chien de garde
           ld a,caracter        ; rappel le caractere a transmettre
           and a,(x)            ; test l'etat du bit courant
           jrnz emis_3          ; selon etat met TX a 1 ou 0 logique
           res tx,copypc
           ld a,copypc
           ld pc,a
           jp emis_4
emis_3     set tx,copypc
           ld a,copypc
           ld pc,a
           nop
emis_4     ldi v,tbit1_e        ; tempo emission d'un bit
emis_5     dec v
           jrnz emis_5
           inc x                ; passe au bit suivant
           dec w
           jrz emis_7           ; si 8 bits transmis, emet stop bit
           jp emis_1
emis_7     nop                  ; 4 nop afin que le temps du huitime bit
           nop                  ; emis soit identique au 7 premiers
           nop
           nop
           set tx,copypc        ; force TX = 1 en conservant la configuration
           ld a,copypc          ; des entrees/sorties
           ld pc,a
           ldi v,tbit2_e
emis_6     dec v                ; tempo start bit
           jrnz emis_6
           ret


;------------------------------------------------------------------------------
;                            Vecteurs d'interruption
;------------------------------------------------------------------------------

;  ***     CAN     ***
           .org 0FF0h
           reti

;  ***     TIMER   ***
           .ORG 0FF2h
           reti

;  ***     PORTB,C ***
           .org 0FF4h
           reti

;  ***     PORTA   ***
           .org 0FF6h
           reti

;  ***     NMI     ***
           .org 0FFCh
           reti

;  ***     RESET   ***
           .org 0FFEh
           jp init_pgm

           .end
