           .title "interface serie 16 sorties"
           .vers  "st6225"
           .input "6225_reg.asm"
           .w_on


;        ================================================================
;        |  Interface 16 sorties  liaison serie asynchrone 1200 bauds  |
;        ================================================================
;
;                        microcontroleur ST6 de SGS-THOMSON
;
; PROTOCOLE DE COMMUNICATION
;
; Les commandes sont dfinis  l'aide de caractres ASCII, ceci afin de
; minimiser les erreurs d'interprtation due  des erreurs de transmission.
; La vitesse de transmission peu leve contribue galement  minimiser les
; erreurs de transmission.
;
; AG    : Activation de toutes les sorties ( "G" pour globale )
; Axx   : Activation de la sortie numro xx ( xx = 01, 02, ..., 16 )
; DG    : dsactivation de toutes les sorties ( "G" pour globale )
; Dxx   : dsactivation de la sortie numro xx ( xx = 01, 02, ..., 16 )
; CG    : complmentation de toutes les sorties ( "G" pour globale )
; Cxx   : complmentation de la sortie numro xx ( xx = 01, 02, ..., 16 )
; Bhhhh : initialisation binaire de toutes les sorties selon la valeur
;	  hexadcimale hhhh.
;
;
; TRANSMISSION SERIE ASYNCHRONE
;
; Vitesse de transmission determinee par le temps d'execution des instructions
;
;                                      13
; Temps d'un cycle instruction Tcy = -------
;                                    Fquartz
;
; Toutes les instructions necessite 4 cycles Tcy sauf :
;
; - JRxx (sauts relatifs), RET, RETI, STOP, WAIT   :   2 Tcy
; - JRR,JRS ( sauts relatifs selon etat d'un bit ) :   5 Tcy
;
;                                         1
; Temps de transmission d'un bit Tbit =  ----
;                                        baud
;
;
; RECEPTION: DETERMINATION DES CONSTANTES DE TEMPORISATION
;
;                 Tbit                                          Fquartz
; 1/2 START BIT:  ---- = ( 15* Tempbit0) * Tcy  ==> Tempbit0 = -----------
; -------------     2                                           390 * Baud
;
;                                                              Fquartz
; BIT 0 :     Tbit = (10* Tempbit1 + 24) * Tcy  ==> Tempbit1 = ------- - 2,4
; ---                                                          130*Baud
;
;                                                              Fquartz
; BIT 1  7 : Tbit = (10* Tempbit1 + 47) * Tcy  ==> Tempbit1 = ------- - 4,7
; ---                                                          130*Baud
;
; cette dernire est utilise pour dterminer Tempbit1
;                                                              Fquartz
; STOP  BIT:  Tbit = (10* Tempbit2 + 08) * Tcy  ==> Tempbit2 = ------- - 0,8
; ----------                                                   130*Baud
;
;
;
; tableau recapitulatif pour differentes vitesses de transmission avec
; un quartz de 8,000 Mhz
;
;      ------------------------------------------------
;      | Baud   |  tempbit0  |  tempbit1  |  tempbit2 |
;      |--------|------------|------------|-----------|
;      |  600   |    34      |    98      |   101     |
;      | 1200   |    17      |    47      |    50     |
;      | 2400   |    09      |    21      |    25     |
;      ------------------------------------------------
;

;------------------------------------------------------------------------------
;                         Definition des constantes
;------------------------------------------------------------------------------

chien      .equ 0FEh             ; valeur du chien de garde  la valeur maxi.
tbit0_r    .equ 17               ; tempo 1/2 start  ( pour 1200 bauds )
tbit1_r    .equ 47               ; tempo bit        ( pour 1200 bauds )
tbit2_r    .equ 50               ; tempo stop bit   ( pour 1200 bauds )
rx         .equ 6                ; PC6 = RX
err	   .equ 7		 ; b7 de ETAT = erreur de rception

;------------------------------------------------------------------------------
;                  Definition des variables en ram $84  $BF
;------------------------------------------------------------------------------


copypa     .def 084h             ; pour maniplation bits du port A
copypb     .def copypa+1         ; pour maniplation bits du port B
copypc     .def copypb+1         ; pour maniplation bits du port C
caracter   .def copypc+1         ; Sauvegarde caractere emis./recep.
port       .def caracter+1       ; Numro du port command
etat	   .def port+1		 ; mot d'tat ( b7 = erreur de rception )
var1	   .def etat+1		 ; variable d'usage gnral
var2	   .def var1+1		 ; variable d'usage gnral

;------------------------------------------------------------------------------
;                                 Programme
;------------------------------------------------------------------------------

           .org 080h


; -- Definition de la table des bits de masquage --

maskbit1   .byte   1 , 2 , 4 , 8 , 16 , 32 , 64 , 128
maskbit0   .byte   0FEh , 0FDh , 0FBh , 0F7h , 0EFh , 0DFh , 0BFh , 7Fh



; -- initialisation   PC4 a PC7 = entree avec resistance de pull-up
;                     PB et PA  = sortie push-pull ( 16 sorties logiques )

init_pgm   ldi wdr,chien
           clr a
           ld pcdir,a
           ld pcopt,a
           ld pc,a
           ld copypc,a
           ldi padir,0FFh
           ldi paopt,0FFh
           ld  pa,a
           ld  copypa,a
           ldi pbdir,0FFh
           ldi pbopt,0FFh
           ld  pb,a
           ld  copypb,a
           clr ior

interp     res err,etat          ; init. indicateur d'erreur avant opration
           call recep		 ; attend commande
           cpi a,'B'		 ; est-ce commande de chargement binaire ?
           jrz chargebin	 ; oui, interprete commande courante
           jp complem		 ; non, va voir si autre commande.

chargebin  call rhexa8		 ; saisie des deux hexa. MSB
	   jrr err,etat,chgb0	 ; pas d'erreur, on continue
           jp interp		 ; problme on rentre  la maison.
chgb0	   ld var2,a		 ; sauvegarde la valeur hexa. saisie.
           call rhexa8		 ; saisie des deux hexa. LSB
           jrr err,etat,chgb1	 ; si pas de problme on continue
           jp interp		 ; sinon, retour  la case dpart.
chgb1      ld copypa,a	         ; initialise les ports A et B selon leur
           ld pa,a		 ; reprsentation hexa. reue.
           ld a,var2
           ld copypb,a
           ld pb,a
           jp interp		 ; Fin de l'interprtation commande

complem    cpi a,'C'		 ; est-ce commande complmentation ?
           jrz compl_ok          ; oui, interprete commande courante.
           jp active		 ; non, va voir si autre commande.
compl_ok   call numero           ; un numro suit-il la commande ?
           jrs err,etat,compl_0  ; non, va voir si commande globale
           jp compl_ind          ; oui, interprete la commande
compl_0    cpi a,'G'		 ; est-ce une commande globale ?
	   jrz compl_1           ; si oui, va complmenter toutes les sorties
           jp interp             ; si non, alors commande inconnue !
compl_1    ld a,copypa
           com a
           ld copypa,a
           ld pa,a
           ld a,copypb
           com a
           ld copypb,a
           ld pb,a
           jp interp             ; fin interprtation commande globale
compl_ind  ldi drwr,maskbit1.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit1.d
           add a,x
           ld x,a                ; X pointe le masque relatif au bit
           ld a,port             ;  complmenter.
           cpi a,1               ; teste s'il s'agit du port A ou B
           jrz port1_1
           jp port2_1
port1_1    ld a,copypa           ; il s'agit du port A . . .
           and a,(x)             ; teste l'tat du bit concern
           jrnz pa_a_1
           ld a,copypa		 ; bit  0, alors on le force  1
           add a,(x)
           jp pa_copie
pa_a_1     ld a,copypa           ; bit  1, alors on le force  0
           sub a,(x)
pa_copie   ld copypa,a	         ; sauvegarde le tout et affecte le port A
           ld pa,a
           jp interp		 ; fin de l'interprtation.
port2_1    ld a,copypb           ; il s'agit du port B . . .
           and a,(x)             ; teste l'tat du bit concern
           jrnz pb_a_1	         ; bit  0, alors le force  1
           ld a,copypb
           add a,(x)
           jp pb_copie
pb_a_1     ld a,copypb           ; bit  1, alors le force  0
           sub a,(x)
pb_copie   ld copypb,a           ; sauvegarde le tout et affecte le port B
           ld pb,a
           jp interp		 ; fin de l'interprtation.


active     cpi a,'A'		 ; est-ce commande activation ?
           jrz active_ok         ; oui, interprte commande.
           jp desactive          ; non, va voir si autre commande.
active_ok  call numero           ; un numro suit-il la commande ?
           jrs err,etat,act_0    ; non, va voir si commande globale
           jp act_ind            ; oui, interprete la commande
act_0      cpi a,'G'     	 ; est-ce une commande globale ?
           jrz act_1		 ; oui, va activer toutes les sorties
           jp interp             ; non, commande inconnue !
act_1      clr a
           com a                 ; activation de toutes les sorties.
           ld copypb,a
           ld copypa,a
           ld pb,a
           ld pa,a
           jp interp		 ; fin interprtation globale.
act_ind    ldi drwr,maskbit1.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit1.d
           add a,x
           ld x,a                ; X pointe masque relatif au bit  mettre  1
           ld a,port
           cpi a,1               ; dtermine le port concern.
           jrnz port2_2
           ld a,copypa           ; le port A est concern . . .
           and a,(x)
           jrnz actind1          ; si le bit est dj  1, on ne fait rien !
           ld a,copypa
           add a,(x)
           ld copypa,a
           ld pa,a
actind1    jp interp             ; fin de l'interprtation.
port2_2    ld a,copypb           ; le port B est concern . . .
           and a,(x)
           jrnz actind2          ; si le bit est dj  1, on ne fait rien !
           ld a,copypb
           add a,(x)
           ld copypb,a
           ld pb,a
actind2    jp interp		 ; fin de l'interprtation.


desactive  cpi a,'D'             ; est-ce commande dsactivation ?
           jrz desac_ok		 ; oui, interprte la commande
           jp cmd_autre		 ; non, va voir si autre commande connue!
desac_ok   call numero           ; un numro suit-il la commande ?
           jrs err,etat,desac_0  ; non, va voir si commande globale
           jp desac_ind          ; oui, interprete la commande
desac_0    cpi a,'G'     	 ; est-ce une commande globale ?
           jrz desac_1  	 ; oui, va dsactiver toutes les sorties
           jp interp             ; non, commande inconnues !
desac_1    clr a                 ; dsactivation de toutes les sorties.
           ld copypb,a
           ld copypa,a
           ld pb,a
           ld pa,a
           jp interp		 ; fin interprtation globale.
desac_ind  ldi drwr,maskbit0.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit0.d
           add a,x
           ld x,a                ; X pointe masque relatif au bit  mettre  0
           ld a,port
           cpi a,1		 ; dtermine si port A ou B concern.
           jrnz port2_3
           ld a,copypa		 ; port A concern . . .
           and a,(x)
           ld copypa,a
           ld pa,a
           jp interp		 ; fin de l'interprtation.
port2_3    ld a,copypb		 ; port B concern.
           and a,(x)
           ld copypb,a
           ld pb,a
           jp interp	         ; fin de l'interprtation.

cmd_autre  jp interp		 ; pour d'autre commandes . . . plus tard !



; -- Routine de rception d'un nombre ASCII compris entre 1 et 16  --
; -- Le format des nombres est le suivant:   01, 02, ... , 15, 16  --
; -- Le numro du bit-1 est retourn dans l'accu.A et le numro du --
; -- port est retourn dans la variable "port" ( 1=portA, 2=portB) --


numero     call recep            ; saisie du premier chiffre
           cpi a,'0'		 ; est-ce le chiffre "0" ?
           jrz num_1             ; oui, alors numro compris entre 01 et 09
           jp num_10             ; non, alors numro compris entre 10 et 16
num_1      call recep            ; numro commenant par 0, alors attend 1  9
           cpi a,'1'             ; si ce n'est pas le cas, il y a erreur !
           jrnc num_2
           jp num_err
num_2      cpi a,'9'
           jrz num_3
           jrc num_3
           jp num_err
num_3      andi a,0Fh            ; rcupre la valeur relle ( 1  9 )
           jp num_port           ; et va dterminer quel port est affect.
num_10     cpi a,'1'	         ; numro commanant par 1, alors attend 0  6
           jrz num_11		 ; si ce n'est pas le cas, il y a erreur !
           jp num_err
num_11     call recep
           cpi a,'0'
           jrnc num_12
           jp num_err
num_12     cpi a,'7'
           jrc num_13
           jp num_err
num_13     andi a,0Fh            ; rcupre la valeur relle ( 10  16 )
           addi a,10
num_port   cpi a,9               ; si numro < 9  alors c'est le port A qui
           jrnc num_14		 ; est concern, dans le cas contraire c'est
           ldi port,1		 ; le port B ( 1 = port A , 2 = port B )
           dec a                 ; l'accu. A contient le numro du bit affect
           ret			 ; et la variable "port" le numro du port.
num_14     subi a,8
           dec a
           ldi port,2
           ret
num_err    set err,etat		 ; l'indicateur d'erreur est actif.
           ret



; -- Routine de rception d'un nombre hexa. 8 bit cod par des caractres --
; -- ASCII.  exemple : A (41h) 2 (32h) ---> A2h


rhexa8     call recep            ; saisie du premier quartet
	   call testhexa	 ; teste si caractre = 0..9 ou A..F
           jrr err,etat,rhx0	 ; si oui, on continue.
           ret
rhx0	   sla a		 ; dcalage  gauche de 4 bits ( quartet MSB )
	   sla a
	   sla a
	   sla a
           ld var1,a		 ; sauvegarde du rsultat
           call recep		 ; saisie du second quartet
           call testhexa         ; teste si caractre = 0..9 ou A..F
           jrr err,etat,rhx1     ; oui, on continue.
           ret
rhx1	   add a,var1            ; runi le tout en un nombre hexa de 8 bits.
	   ld var1,a		 ; sauvegard dans la variable "var1".
           ret



; -- Routine de test si nombre hexa, avec conversion ASCii -> binaire


testhexa   cpi a,'0'
	   jrnc thx0
	   set err,etat
	   ret
thx0	   cpi a,'G'
	   jrc thx1
           set err,etat
           ret
thx1	   cpi a,'9'+1
	   jrnc thx2
           subi a,'0'
           ret
thx2	   cpi a,'A'
	   jrnc thx3
           set err,etat
           ret
thx3	   subi a,37h
	   ret




; -- Routine de rception d'un caractre par liaison srie asynchrone       --
; -- Le caractre recu est sauvegard dans l'accu A et la variable caracter --


recep      ldi drwr,maskbit0.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit0.d
recep_0    ldi v,tbit0_r         ; reception bit de start ( tempo reg. V )
           ldi wdr,chien
recep_1    jrs rx,pc,recep_0     ; attend start bit
           ldi wdr,chien
           dec v                 ; tempo start bit
           jrnz recep_1
           ldi w,8               ; initialise le compteur de bits a 8
           ldi wdr,chien         ; relance le chien de garde
           clr a
           com a
           ld  caracter,a        ; initialise caratre reu
recep_2    ldi v,tbit1_r
recep_6    ldi wdr,chien
           dec v
           jrnz recep_6
           ld a,caracter
           jrs rx,pc,recep_3
           and a,(x)
           jp recep_4
recep_3    nop
           nop
recep_4    ld caracter,a
           inc x
           dec w
           jrz recep_5
           jp recep_2
recep_5    ldi v,tbit2_r
recep_7    ldi wdr,chien
           dec v
           jrnz recep_7
           ld a,caracter
           ret

;------------------------------------------------------------------------------
;                            Vecteurs d'interruption
;------------------------------------------------------------------------------

;  ***     CAN     ***
           .org 0FF0h
           reti

;  ***     TIMER   ***
           .ORG 0FF2h
           reti

;  ***     PORTB,C ***
           .org 0FF4h
           reti

;  ***     PORTA   ***
           .org 0FF6h
           reti

;  ***     NMI     ***
           .org 0FFCh
           reti

;  ***     RESET   ***
           .org 0FFEh
           jp init_pgm

           .end
