;****************************************************************************
;                 microcontroleur ST6 de SGS-THOMSON
;
;       !--------------------------------------------------------------!
;       !        Commande progressive de deux moteurs Pas  Pas        !
;       !--------------------------------------------------------------!
;
;  configuration des E/S
;  ---------------------
;  port A :  Tous les bits en sortie symtrique
;  port B :  Tous les bits en sortie drain ouvert
;  port C :  PC7 et PC6 en entre avec rsistance de rappel, sans IT
;            PC5 et PC4 : initialement en entre sans R de rappel ni I.T
;                         Conversion A/N sur PC4: PC4 en entre analogique
;                         Conversion A/N sur PC5: PC5 en entre analogique
;
;  !---------!-------------------!-----------------!------------------!
;  ! ....... !  DDR  direction   !   OR   option   !  DR   donnees    !
;  !---------!-------------------!-----------------!------------------!
;  ! port A  !  11111111 =   FFh ! 11111111 = FFh  ! 00000000 = 00h   !
;  !---------!-------------------!-----------------!------------------!
;  ! port B  !  11111111 =   FFh ! 00000000 = 00h  ! 11111111 = FFh   !
;  !---------!-------------------!-----------------!------------------!
;  ! port C  !  00000000 =   00h ! 00000000 = 00h  ! 00110000 = 30h   !
;  !---------!-------------------!-----------------!------------------!
;
;
;****************************************************************************


           .title "Commande moteurs PAS a PAS"
           .vers  "st6225"
           .input "6225_reg.asm"
           .w_on

;-----------------------------------------------------------------------------
;                     Dfinition des constantes
;-----------------------------------------------------------------------------

chien      .equ 0FEh            ; valeur du chien de garde
timilli    .equ 21              ; pour 500s environ
tmz        .equ 7               ; bit 7 du registre TCR ( fin tempo )

;  constantes utilise pour le port C

ModeMOT1   .equ 6               ; PC6 = mode fonctionnement moteur 1
ModeMOT2   .equ 7               ; PC7 = mode fonctionnement moteur 2

;  constantes utilises pour le registre d'tat des moteurs

conv       .equ 0               ; bit 0 de STATUS = demande de conversion
ArretM1    .equ 1               ; bit 1 de STATUS = arret moteur 1
ArretM2    .equ 2               ; bit 2 de STATUS = arret moteur 2
SensM1     .equ 3               ; bit 3 de STATUS = sens de rotation moteur 1
SensM2     .equ 4               ; bit 4 de STATUS = sens de rotation moteur 2

;  constantes utilises pour le port B

S1M1       .equ 0               ; bit 0 de pb = indicateur "sens 1 moteur 1"
AM1        .equ 1               ; bit 1 de pb = indicateur "arrt  moteur 1"
S2M1       .equ 2               ; bit 2 de pb = indicateur "sens 2 moteur 1"
S1M2       .equ 3               ; bit 3 de pb = indicateur "sens 1 moteur 2"
AM2        .equ 4               ; bit 4 de pb = indicateur "arret  moteur 2"
S2M2       .equ 5               ; bit 5 de pb = indicateur "sens 2 moteur 2"

;-----------------------------------------------------------------------------
;               Dfinition des variables en ram $84  $BF
;-----------------------------------------------------------------------------


BaseRam    .def 084h
ConvPC4    .def BaseRam         ; Valeur analogique issue de PC4
ConvPC5    .def ConvPC4+1       ; Valeur analogique issue de PC5
PMOT1      .def ConvPC5+1       ; Cycle moteur 1: commande des enroulements
PMOT2      .def PMOT1+1         ; Cycle moteur 2: commande des enroulements
Temps1     .def PMOT2+1         ; delai commande moteur 1
Temps2     .def Temps1+1        ; delai commande moteur 2
RefT1      .def Temps2+1        ; rfrence dlai commande moteur 1
RefT2      .def RefT1+1         ; rfrence dlai commande moteur 2
status     .def RefT2+1         ; sens de rotation des moteurs 1 et 2
save_a     .def status+1        ; sauvegarde de l'accu A
save_x     .def save_a+1        ; sauvegarde de l'index x

;-----------------------------------------------------------------------------
;                          Dbut du programme
;-----------------------------------------------------------------------------

           .org 080h

; Etat des sorties de commande des enroulements en mode "pas entiers biphas"
; ou en mode "demi-pas"

PEMOT1     .byte  05h ,  06h ,  0Ah ,  09h ,  05h ,  06h ,  0Ah ,  09h
DPMOT1     .byte  01h ,  05h ,  04h ,  06h ,  02h ,  0Ah ,  08h ,  09h
PEMOT2     .byte  50h ,  60h , 0A0h ,  90h ,  50h ,  60h , 0A0h ,  90h
DPMOT2     .byte  10h ,  50h ,  40h ,  60h ,  20h , 0A0h ,  80h ,  90h

; table des priodes, permet d'obtenir une relation linaire entre la rotation
; des potentiomtres et la frquence de rotation des moteurs. F = k * alpha

           .org 0C0h

TPERIOD1   .byte  255 , 217 , 187 , 165 , 148 , 134 , 122 , 112 , 104 ,  97
           .byte   90 ,  85 ,  80 ,  76 ,  72 ,  68 ,  65 ,  62 ,  59 ,  57
           .byte   55 ,  53 ,  51 ,  49 ,  47 ,  46 ,  44 ,  43 ,  42 ,  40
           .byte   39 ,  38 ,  37 ,  36 ,  35 ,  34 ,  34 ,  33 ,  32 ,  31
           .byte   31 ,  30 ,  29 ,  29 ,  28 ,  28 ,  27 ,  27 ,  26 ,  26
           .byte   25 ,  25 ,  24 ,  24 ,  23 ,  23 ,  23 ,  22 ,  22 ,  22

           .org 100h

TPERIOD2   .byte   21 ,  21 ,  21 ,  20 ,  20 ,  20 ,  20 ,  19 ,  19 ,  19
           .byte   18 ,  18 ,  18 ,  18 ,  18 ,  17 ,  17 ,  17 ,  17 ,  17
           .byte   16 ,  16 ,  16 ,  16 ,  16 ,  15 ,  15 ,  15 ,  15 ,  15
           .byte   15 ,  14 ,  14 ,  14 ,  14 ,  14 ,  14 ,  14 ,  13 ,  13
           .byte   13 ,  13 ,  13 ,  13 ,  13 ,  13 ,  13 ,  12 ,  12 ,  12
           .byte   12 ,  12 ,  12 ,  12 ,  12 ,  12 ,  11 ,  11 ,  11 ,  11


StartP     ldi wdr,chien             ; pour le cas o ...
           ldi padir,0FFh            ; initialisation du port A
           ldi paopt,0FFh
           ldi pa,00h
           ldi pbdir,0FFh            ; initialisation du port B
           ldi pbopt,00h
           ldi pb,0FFh
           ldi pcdir,00h             ; initialisation du port C
           ldi pcopt,00h
           ldi pc,30h
           ldi tscr,01011100b        ; div par 16 avec interruption autorisee
           ldi tcr,timilli
           ldi adcr,10h              ; CAN actif sans interruptions
           clr PMOT1
           clr PMOT2
           clr Temps1
           clr Temps2
           clr status
           set ArretM1,status
           set ArretM2,status
           ldi ior,10h               ; autorise interruptions masquables
           reti

loop       call Convert
           call Calcul
           jp loop


; Sous-programme de saisie des valeurs analogiques prsentes sur PC4 et PC5

Convert    set 4,pcopt            ; PC4 en entre analogique
           nop                    ; petit dlai pour stabilit de l'entre
           set conv,status        ; demande de conversion ( synchrone )
Conv_0     ldi wdr,chien          ; attend acquitement demande de conversion
           jrs conv,status,Conv_0
           set 5,adcr             ; lance conversion
           wait                   ; arrete tout pour meilleure conversion A/D
           res 5,adcr             ; CAN prt pour la prochaine conversion
           ld a,adr               ; recupere la valeur convertie
           ld ConvPC4,a           ; et sauvegarde celle-ci
           res 4,pcopt            ; PC4 en entre logique sans rappel ni IT
           nop

           set 5,pcopt            ; PC5 en entre analogique
           nop                    ; petit dlai pour stabilit de l'entre
           set conv,status        ; demande de conversion ( synchrone )
Conv_1     ldi wdr,chien          ; attend acquitement demande de conversion
           jrs conv,status,Conv_1
           set 5,adcr             ; lance conversion
           wait                   ; arrete tout pour meilleure conversion A/D
           res 5,adcr             ; CAN prt pour la prochaine conversion
           ld a,adr               ; recupere la valeur convertie
           ld ConvPC5,a           ; et sauvegarde celle-ci
           res 5,pcopt            ; PC5 en entre logique sans rappel ni IT
           ldi wdr,chien          ; puisqu'il le faut !
           ret

; sous-programme de calcul de la frquence et du sens de rotation des moteurs

Calcul     ld a,ConvPC4           ; dtermine si 78 >= N > 88h
           cpi a,88h              ; si oui, arret moteur
           jrc arret1             ; si non, dtermine le sens de rotation
           jp M1sens1             ; et la vitesse de rotation
arret1     cpi a,78h
           jrnc arretOK1
           jp M1sens2
arretOK1   set ArretM1,status
           clr a

           res AM1,pb             ; allume  LED "arret  moteur 1"
           set S1M1,pb            ; teint  LED "sens 1 moteur 1"
           set S2M1,pb            ; teint  LED "sens 2 moteur 1"

           jp FinM1
M1sens1    subi a,88h
           set SensM1,status
           res ArretM1,status

           set AM1,pb             ; teint  LED "arret  moteur 1"
           res S1M1,pb            ; allume  LED "sens 1 moteur 1"
           set S2M1,pb            ; teint  LED "sens 2 moteur 1"

           jp FinM1
M1sens2    ld v,a
           ldi a,77h
           sub a,v
           res SensM1,status
           res ArretM1,status

           set AM1,pb             ; teint  LED "arret  moteur 1"
           set S1M1,pb            ; teint  LED "sens 1 moteur 1"
           res S2M1,pb            ; allume  LED "sens 2 moteur 1"

FinM1      cpi a,60               ; N >= 60 ?
           jrnc M1T2              ; oui, va adresser TPERIOD2
           addi a,40h
           ld x,a                 ; non, adresse TPERIOD1
           ldi drwr,TPERIOD1.w    ; Cette technique permet de gagner du
           ld a,(x)               ; temps car le ST6 n'est pas trs rapide.
           ld RefT1,a
           jp FinM10
M1T2       subi a,60
           addi a,40h
           ld x,a
           ldi drwr,TPERIOD2.w
           ld a,(x)
           ld RefT1,a
FinM10     wait                   ; pour tre synchro avec le TIMER

           ld a,ConvPC5
           cpi a,88h
           jrc arret2
           jp M2sens1
arret2     cpi a,78h
           jrnc arretOK2
           jp M2sens2
arretOK2   set ArretM2,status
           clr a

           res AM2,pb             ; allume  LED "arret  moteur 2"
           set S1M2,pb            ; teint  LED "sens 1 moteur 2"
           set S2M2,pb            ; teint  LED "sens 2 moteur 2"

           jp FinM2
M2sens1    subi a,88h
           set SensM2,status
           res ArretM2,status

           set AM2,pb             ; teint  LED "arret  moteur 2"
           res S1M2,pb            ; allume  LED "sens 1 moteur 2"
           set S2M2,pb            ; teint  LED "sens 2 moteur 2"

           jp FinM2
M2sens2    ld v,a
           ldi a,77h
           sub a,v
           res SensM2,status
           res ArretM2,status

           set AM2,pb             ; teint  LED "arret  moteur 2"
           set S1M2,pb            ; teint  LED "sens 1 moteur 2"
           res S2M2,pb            ; allume  LED "sens 2 moteur 2"

FinM2      cpi a,60               ; N >= 60 ?
           jrnc M2T2              ; oui, va adresser TPERIOD2
           addi a,40h
           ld x,a                 ; non, adresse TPERIOD1
           ldi drwr,TPERIOD1.w    ; Cette technique permet de gagner du
           ld a,(x)               ; temps car le ST6 n'est pas trs rapide.
           ld RefT2,a
           jp FinM20
M2T2       subi a,60
           addi a,40h
           ld x,a
           ldi drwr,TPERIOD2.w
           ld a,(x)
           ld RefT2,a
FinM20     ret



; sous-programme de commande du moteur 1 dans le sens 1

IncMOT1    inc PMOT1
           ld a,PMOT1
           andi a,7
           ld PMOT1,a
           jrr ModeMOT1,pc,M1demi
           ldi drwr,PEMOT1.w
           ldi a,PEMOT1.d
           jp M1suite
M1demi     ldi drwr,DPMOT1.w
           ldi a,DPMOT1.d
M1suite    add a,PMOT1
           ld x,a
           ld a,pa
           andi a,0F0h
           add a,(x)
           ld pa,a
           ret

; sous-programme de commande du moteur 1 dans le sens 2

DecMOT1    dec PMOT1
           ld a,PMOT1
           andi a,7
           ld PMOT1,a
           jrr ModeMOT1,pc,M1demi2
           ldi drwr,PEMOT1.w
           ldi a,PEMOT1.d
           jp M1suite2
M1demi2    ldi drwr,DPMOT1.w
           ldi a,DPMOT1.d
M1suite2   add a,PMOT1
           ld x,a
           ld a,pa
           andi a,0F0h
           add a,(x)
           ld pa,a
           ret

; sous-programme de commande du moteur 2 dans le sens 1

IncMOT2    inc PMOT2
           ld a,PMOT2
           andi a,7
           ld PMOT2,a
           jrr ModeMOT2,pc,M2demi
           ldi drwr,PEMOT2.w
           ldi a,PEMOT2.d
           jp M2suite
M2demi     ldi drwr,DPMOT2.w
           ldi a,DPMOT2.d
M2suite    add a,PMOT2
           ld x,a
           ld a,pa
           andi a,0Fh
           add a,(x)
           ld pa,a
           ret

; sous-programme de commande du moteur 2 dans le sens 2

DecMOT2    dec PMOT2
           ld a,PMOT2
           andi a,7
           ld PMOT2,a
           jrr ModeMOT2,pc,M2demi2
           ldi drwr,PEMOT2.w
           ldi a,PEMOT2.d
           jp M2suite2
M2demi2    ldi drwr,DPMOT2.w
           ldi a,DPMOT2.d
M2suite2   add a,PMOT2
           ld x,a
           ld a,pa
           andi a,0Fh
           add a,(x)
           ld pa,a
           ret

GesTim     res tmz,tscr
           ldi tcr,timilli
           res conv,status
           ldi wdr,chien
           ld a,x
           ld save_x,a
           ld save_a,a
           jrr ArretM1,status,GT_1
           jp Mot2
GT_1       ld a,Temps1
           jrz GT_2
           dec Temps1
           jp Mot2
GT_2       ld a,RefT1
           ld Temps1,a
           jrr SensM1,status,GT_3
           call IncMOT1
           jp Mot2
GT_3       call DecMOT1
Mot2       jrr ArretM2,status,GT_10
           jp FinG
GT_10      ld a,Temps2
           jrz GT_20
           dec Temps2
           jp FinG
GT_20      ld a,RefT2
           ld Temps2,a
           jrr SensM2,status,GT_30
           call IncMOT2
           jp FinG
GT_30      call DecMOT2
FinG       ld a,save_x
           ld x,a
           ld a,save_a
           reti


;-----------------------------------------------------------------------------
;                         Vecteurs d'interruptions
;-----------------------------------------------------------------------------


;  ***     CAN     ***
           .org 0FF0h
           reti

;  ***     TIMER   ***
           .ORG 0FF2h
           jp GesTim

;  ***     PORTB,C ***
           .org 0FF4h
           reti

;  ***     PORTA   ***
           .org 0FF6h
           reti

;  ***     NMI     ***
           .org 0FFCh
           reti

;  ***     RESET   ***
           .org 0FFEh
           jp StartP

           .end
