           .title "interface serie 8 E/S logiques et 2 E analogiques"
           .vers  "st6225"
           .input "6225_reg.asm"
           .w_on


;        ===================================================================
;        | Interface 8 entres / sorties logiques et 2 entres analogiques |
;        |           liaison serie asynchrone 1200 bauds                  |
;        |      ( utilisant le microcontroleur ST6 de SGS-THOMSON )        |
;        ===================================================================
;
;
; PROTOCOLE DE COMMUNICATION
; --------------------------
;
; Les commandes sont dfinis  l'aide de caractres ASCII, ceci afin de
; minimiser les erreurs d'interprtation due  des erreurs de transmission.
; La vitesse de transmission peu leve contribue galement  minimiser les
; erreurs de transmission.
;
; R    : Test de la transmission.
;        Le systme hte (donc le ST6225) doit renvoyer "O"
; AG   : Activation de toutes les sorties ( "G" pour globale )
;        Le systme hte (donc le ST6225) doit renvoyer "O"
; Ax   : Activation de la sortie numro xx ( x = 1, 2, ..., 8 )
;        Le systme hte (donc le ST6225) doit renvoyer "O"
; DG   : dsactivation de toutes les sorties ( "G" pour globale )
;        Le systme hte (donc le ST6225) doit renvoyer "O"
; Dx   : dsactivation de la sortie numro xx ( x = 1, 2, ..., 8 )
;        Le systme hte (donc le ST6225) doit renvoyer "O"
; CG   : complmentation de toutes les sorties ( "G" pour globale )
;        Le systme hte (donc le ST6225) doit renvoyer "O"
; Cx   : complmentation de la sortie numro xx ( x = 1, 2, ..., 8 )
;        Le systme hte (donc le ST6225) doit renvoyer "O"
; Bhh  : initialisation binaire de toutes les sorties selon la valeur
;	 hexadcimale hh.
;        Le systme hte (donc le ST6225) doit renvoyer "O"
; LG   : Lecture globale des 8 entres logique.
;        Le systme hte doit renvoyer la valeur hexadcimale quivalente des
;        8 bits en entre, code sous forme ASCII ( soit hh ).
; Lx   : Lecture de l'entre logique numro x ( x = 1 .. 8 ).
;        Le systme hte doit renvoyer l'tat logique de l'entre au format
;        ASCII, sachant que "0" = tat logique 0 et "1" = tat logique 1.
; Vx   : Valeur numrique, code sur 8 bits, correspondant  la tension
;        analogique applique sur l'entre X ( X = 1 ou 2 ).
;        Le systme hte doit renvoyer la valeur convertie au format ASCII.
;
; TRANSMISSION SERIE ASYNCHRONE
; -----------------------------
;
; Vitesse de transmission determinee par le temps d'execution des instructions
;
;                                      13
; Temps d'un cycle instruction Tcy = -------
;                                    Fquartz
;
; Toutes les instructions necessite 4 cycles Tcy sauf :
;
; - JRxx (sauts relatifs), RET, RETI, STOP, WAIT   :   2 Tcy
; - JRR,JRS ( sauts relatifs selon etat d'un bit ) :   5 Tcy
;
;                                         1
; Temps de transmission d'un bit Tbit =  ----
;                                        baud
;
;
; 1 / EMISSION: Dtermination des constantes de temporisation
;
;                                                              Fquartz
; START BIT:  Tbit = (6 * Tempbit0 + 30) * Tcy  ==> Tempbit0 = ------- - 5
; ----------                                                   78*Baud
;
;                                                              Fquartz
; BIT :       Tbit = (6 * Tempbit1 + 48) * Tcy  ==> Tempbit1 = ------- - 8
; ---                                                          78*Baud
;
;                                                              Fquartz
; STOP  BIT:  Tbit = (6 * Tempbit2 + 04) * Tcy  ==> Tempbit2 = ------- - 0,7
; ----------                                                   78*Baud
;
;
;
; tableau recapitulatif pour differentes vitesses de transmission avec
; un quartz de 8,000 Mhz
;
;      ------------------------------------------------
;      | Baud   |  tempbit0  |  tempbit1  |  tempbit2 |
;      |--------|------------|------------|-----------|
;      |  600   |   166      |   163      |   170     |
;      | 1200   |    80      |    77      |    84     |
;      | 2400   |    38      |    35      |    42     |
;      ------------------------------------------------
;

; 2 / RECEPTION: Dtermination des constantes de temporisation
;
;                 Tbit                                          Fquartz
; 1/2 START BIT:  ---- = ( 15* Tempbit0) * Tcy  ==> Tempbit0 = -----------
; -------------     2                                           390 * Baud
;
;                                                              Fquartz
; BIT 0 :     Tbit = (10* Tempbit1 + 24) * Tcy  ==> Tempbit1 = ------- - 2,4
; ---                                                          130*Baud
;
;                                                              Fquartz
; BIT 1  7 : Tbit = (10* Tempbit1 + 47) * Tcy  ==> Tempbit1 = ------- - 4,7
; ---                                                          130*Baud
;
; cette dernire est utilise pour dterminer Tempbit1
;                                                              Fquartz
; STOP  BIT:  Tbit = (10* Tempbit2 + 08) * Tcy  ==> Tempbit2 = ------- - 0,8
; ----------                                                   130*Baud
;
;
;
; tableau recapitulatif pour differentes vitesses de transmission avec
; un quartz de 8,000 Mhz
;
;      ------------------------------------------------
;      | Baud   |  tempbit0  |  tempbit1  |  tempbit2 |
;      |--------|------------|------------|-----------|
;      |  600   |    34      |    98      |   101     |
;      | 1200   |    17      |    47      |    50     |
;      | 2400   |    09      |    21      |    25     |
;      ------------------------------------------------
;
;
;
;
; CONFIGURATION DES ENTREES ET DES SORTIES
; ----------------------------------------
;
; Les 8 entres sont les 8 bits du port B,
; Les 8 sorties sont les 8 bits du port A.
; Les 2 entres analogiques sont PC4 et PC5
;
; Par dfaut, PC4 et PC5 sont configures en entre logiques sans rsistance
; de rappel au +VDD et sans interruption. Le bit correspondant  PC4 ou PC5
; du registre d'option "OR" est forc  l'tat "1" dans le cas d'une acquisi-
; tion analogique (cette action configure l'entre choisie en mode analogique)
; car il ne faut pas oublier qu'on ne peut configurer en entre analogique
; qu'une seule entre  la fois.
;
; Voici la table de configuration des ports A, B et C :
;
;  port B :  Tous les bits en entre avec R de rappel et sans IT
;  port A :  Tous les bits en sortie symtrique, par dfaut  "0".
;  port C :  PC7 en sortie symtrique ( TX )
;            Rem : La sortie TX est initialise a 1 par dfaut
;            PC6 en entre sans rsistance de rappel ni IT
;            PC5 et PC4 : initialement en entre sans R de rappel ni I.T
;                         Conversion A/N sur PC4: PC4 en entre analogique
;                         Conversion A/N sur PC5: PC5 en entre analogique
;
;  !---------!-------------------!-----------------!------------------!
;  ! ....... !  DDR  direction   !   OR   option   !  DR   donnees    !
;  !---------!-------------------!-----------------!------------------!
;  ! port A  !  11111111 =   FFh ! 11111111 = FFh  ! 00000000 = 00h   !
;  !---------!-------------------!-----------------!------------------!
;  ! port B  !  00000000 =   00h ! 00000000 = 00h  ! 00000000 = 00h   !
;  !---------!-------------------!-----------------!------------------!
;  ! port C  !  10000000 =   80h ! 10000000 = 80h  ! 11110000 = F0h   !
;  !---------!-------------------!-----------------!------------------!





;------------------------------------------------------------------------------
;                         Definition des constantes
;------------------------------------------------------------------------------

chien      .equ 0FEh             ; valeur du chien de garde  la valeur maxi.
tbit0_e    .equ 80               ; tempo start bit  ( pour 1200 bauds )
tbit1_e    .equ 77               ; tempo bit        ( pour 1200 bauds )
tbit2_e    .equ 84               ; tempo stop bit   ( pour 1200 bauds )
tbit0_r    .equ 17               ; tempo 1/2 start  ( pour 1200 bauds )
tbit1_r    .equ 47               ; tempo bit        ( pour 1200 bauds )
tbit2_r    .equ 50               ; tempo stop bit   ( pour 1200 bauds )
rx         .equ 6                ; PC6 = RX
tx         .equ 7                ; PC7 = TX
err	   .equ 7		 ; b7 de ETAT = erreur de rception

;------------------------------------------------------------------------------
;                  Definition des variables en ram $84  $BF
;------------------------------------------------------------------------------


copypa     .def 084h             ; pour maniplation bits du port A
copypb     .def copypa+1         ; pour maniplation bits du port B
copypc     .def copypb+1         ; pour maniplation bits du port C
caracter   .def copypc+1         ; Sauvegarde caractere emis./recep.
etat       .def caracter+1       ; mot d'tat ( b7 = erreur de rception )
var1	   .def etat+1		 ; variable d'usage gnral
var2	   .def var1+1		 ; variable d'usage gnral

;------------------------------------------------------------------------------
;                                 Programme
;------------------------------------------------------------------------------

           .org 080h


; -- Definition de la table des bits de masquage --

maskbit1   .byte   1 , 2 , 4 , 8 , 16 , 32 , 64 , 128
maskbit0   .byte   0FEh , 0FDh , 0FBh , 0F7h , 0EFh , 0DFh , 0BFh , 7Fh



; -- initialisation du microcontoleur --

init_pgm   ldi wdr,chien
           ldi pcdir,80h
           ldi pcopt,80h
           ldi pc,0F0h
           ldi copypc,0F0h
           clr a
           ld  pbdir,a
           ld  pbopt,a
           ld  pb,a
           ld  copypb,a
           ldi padir,0FFh
           ldi paopt,0FFh
           ld  pa,a
           ld  copypa,a
           ldi adcr,10h              ; CAN actif sans interruptions
           clr ior

; Rem: on reste en mode NMI (pas de RETI) car aucune I.T. n'est utilise !

interp     res err,etat          ; init. indicateur d'erreur avant opration
           call recep		 ; attend commande
           cpi a,'R'             ; est-ce un test de la liaison srie ?
           jrz TestCOM           ; oui, va renvoyer "O"
           jp chargebin          ; non, va voir si autre commande

TestCOM    ldi a,'O'             ; renvoit caractre "O" au systme matre
           call emis
           jp interp

chargebin  cpi a,'B'		 ; est-ce commande de chargement binaire ?
           jrz chgbinok 	 ; oui, interprete commande courante
           jp complem		 ; non, va voir si autre commande.
chgbinok   call rhexa8		 ; saisie des deux hexa. MSB
	   jrr err,etat,chgb0	 ; pas d'erreur, on continue
           jp interp		 ; problme on rentre  la maison.
chgb0      ld copypa,a           ; initialise le port B selon leur
           ld pa,a               ; reprsentation hexa. reue.
           ldi a,'O'             ; renvoit caractre "O" au systme matre
           call emis
           jp interp		 ; Fin de l'interprtation commande

complem    cpi a,'C'		 ; est-ce commande complmentation ?
           jrz compl_ok          ; oui, interprete commande courante.
           jp active		 ; non, va voir si autre commande.
compl_ok   call numero           ; un numro suit-il la commande ?
           jrs err,etat,compl_0  ; non, va voir si commande globale
           jp compl_ind          ; oui, interprete la commande
compl_0    cpi a,'G'		 ; est-ce une commande globale ?
	   jrz compl_1           ; si oui, va complmenter toutes les sorties
           jp interp             ; si non, alors commande inconnue !
compl_1    ld a,copypa
           com a
           ld copypa,a
           ld pa,a
           ldi a,'O'             ; renvoit caractre "O" au systme matre
           call emis
           jp interp             ; fin interprtation commande globale
compl_ind  ldi drwr,maskbit1.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit1.d
           add a,x
           ld x,a                ; X pointe le masque relatif au bit
           ld a,copypa
           and a,(x)             ; teste l'tat du bit concern
           jrnz pb_a_1
           ld a,copypa           ; bit  0, alors on le force  1
           add a,(x)
           jp pb_copie
pb_a_1     ld a,copypa           ; bit  1, alors on le force  0
           sub a,(x)
pb_copie   ld copypa,a           ; sauvegarde le tout et affecte le port B
           ld pa,a
           ldi a,'O'             ; renvoit caractre "O" au systme matre
           call emis
           jp interp		 ; fin de l'interprtation.


active     cpi a,'A'		 ; est-ce commande activation ?
           jrz active_ok         ; oui, interprte commande.
           jp desactive          ; non, va voir si autre commande.
active_ok  call numero           ; un numro suit-il la commande ?
           jrs err,etat,act_0    ; non, va voir si commande globale
           jp act_ind            ; oui, interprete la commande
act_0      cpi a,'G'     	 ; est-ce une commande globale ?
           jrz act_1		 ; oui, va activer toutes les sorties
           jp interp             ; non, commande inconnue !
act_1      clr a
           com a                 ; activation de toutes les sorties.
           ld copypa,a
           ld pa,a
           ldi a,'O'             ; renvoit caractre "O" au systme matre
           call emis
           jp interp		 ; fin interprtation globale.
act_ind    ldi drwr,maskbit1.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit1.d
           add a,x
           ld x,a                ; X pointe masque relatif au bit  mettre  1
           ld a,copypa
           and a,(x)
           jrnz actind1          ; si le bit est dj  1, on ne fait rien !
           ld a,copypa
           add a,(x)
           ld copypa,a
           ld pa,a
actind1    ldi a,'O'             ; renvoit caractre "O" au systme matre
           call emis
           jp interp             ; fin de l'interprtation.


desactive  cpi a,'D'             ; est-ce commande dsactivation ?
           jrz desac_ok		 ; oui, interprte la commande
           jp lecture  		 ; non, va voir si autre commande connue!
desac_ok   call numero           ; un numro suit-il la commande ?
           jrs err,etat,desac_0  ; non, va voir si commande globale
           jp desac_ind          ; oui, interprete la commande
desac_0    cpi a,'G'     	 ; est-ce une commande globale ?
           jrz desac_1  	 ; oui, va dsactiver toutes les sorties
           jp interp             ; non, commande inconnues !
desac_1    clr a                 ; dsactivation de toutes les sorties.
           ld copypa,a
           ld pa,a
           ldi a,'O'             ; renvoit caractre "O" au systme matre
           call emis
           jp interp		 ; fin interprtation globale.
desac_ind  ldi drwr,maskbit0.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit0.d
           add a,x
           ld x,a                ; X pointe masque relatif au bit  mettre  0
           ld a,copypa
           and a,(x)             ; mise  0 du bit !
           ld copypa,a
           ld pa,a
           ldi a,'O'             ; renvoit caractre "O" au systme matre
           call emis
           jp interp		 ; fin de l'interprtation.

lecture    cpi a,'L'             ; est-commande de lecture des entres ?
           jrz lect_ok           ; oui, interprete la commande
           jp Analogic           ; non, va voir si autre commande
lect_ok    call numero           ; un numro suit-il la commande ?
           jrs err,etat,lect_0   ; non, va voir si commande globale
           jp lect_ind           ; oui, interprete la commande
lect_0     cpi a,'G'             ; est-ce une commande globale ?
           jrz lect_1            ; oui, interprete la commande
           jp interp             ; non, rentre  la maison
lect_1     ld a,pb               ; lecture des 8 entres ( port B )
           call ehexa8           ; envoi des 8 bits sous forme hex cod ASCII
           jp interp
lect_ind   ldi drwr,maskbit1.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit1.d
           add a,x
           ld x,a
           ld a,pb
           and a,(x)             ; test l'tat de l'entre concerne
           jrz entree_0          ; et selon celui-ci, emet '0' ou '1'
           ldi a,'1'
           call emis
           jp interp
entree_0   ldi a,'0'
           call emis
           jp interp

Analogic   cpi a,'V'             ; est-commande de lecture des entres ?
           jrz Ana_ok            ; oui, interprete la commande
           jp Cmd_Autre          ; non, va voir si autre commande
Ana_ok     call recep            ; Teste si entre analogique numro 1 ou 2
           cpi a,'1'             ; Entre N1 ?
           jrz analog_1          ;
           jp analog_2           ; non, alors autre...
analog_1   set 4,pcopt           ; PC4 en entre analogique
           nop                   ; petit dlai pour stabilit de l'entre
           set 5,adcr            ; lance conversion
conv_1     ldi wdr,chien         ; attend fin de conversion
           jrr 6,adcr,conv_1
           res 5,adcr            ; CAN prt pour la prochaine conversion
           ld a,adr              ; recupre la valeur convertie
           res 4,pcopt           ; PC4 en entre logique sans rappel ni IT
           jp ana_fin
analog_2   cpi a,'2'             ; entre N2 ?
           jrz analog_3
           jp interp
analog_3   set 5,pcopt           ; PC5 en entre analogique
           nop                   ; petit dlai pour stabilit de l'entre
           set 5,adcr            ; lance conversion
conv_2     ldi wdr,chien         ; attend fin de conversion
           jrr 6,adcr,conv_2
           res 5,adcr            ; CAN prt pour la prochaine conversion
           ld a,adr              ; recupre la valeur convertie
           res 5,pcopt           ; PC5 en entre logique sans rappel ni IT
ana_fin    call ehexa8           ; envoi des 8 bits sous forme hex cod ASCII
           jp interp

Cmd_Autre  jp interp


; -- Routine de rception d'un nombre ASCII compris entre 1 et 8   --
; -- Le format des nombres est le suivant:   1, 2, ... , 8         --
; -- Le numro du bit - 1 est retourn dans l'accumulateur A       --


numero     call recep            ; attend valeur code ascii entre 31h et 38h
           cpi a,'1'             ; si ce n'est pas le cas, il y a erreur !
           jrnc num_2
           jp num_err
num_2      cpi a,'9'
           jrc num_3
           jp num_err
num_3      andi a,0Fh            ; rcupre la valeur relle ( 1  8 )
           dec a                 ; l'accu. A contient le numro du bit - 1
           ret			 ;
num_err    set err,etat		 ; si erreur : l'indicateur d'erreur est actif
           ret



; -- Routine de rception d'un nombre hexa. 8 bit cod par des caractres --
; -- ASCII.  exemple : A (41h) 2 (32h) ---> A2h


rhexa8     call recep            ; saisie du premier quartet
	   call testhexa	 ; teste si caractre = 0..9 ou A..F
           jrr err,etat,rhx0	 ; si oui, on continue.
           ret
rhx0	   sla a		 ; dcalage  gauche de 4 bits ( quartet MSB )
	   sla a
	   sla a
	   sla a
           ld var1,a		 ; sauvegarde du rsultat
           call recep		 ; saisie du second quartet
           call testhexa         ; teste si caractre = 0..9 ou A..F
           jrr err,etat,rhx1     ; oui, on continue.
           ret
rhx1	   add a,var1            ; runi le tout en un nombre hexa de 8 bits.
	   ld var1,a		 ; sauvegard dans la variable "var1".
           ret



; -- Routine de test si nombre hexa, avec conversion ASCii -> binaire


testhexa   cpi a,'0'
	   jrnc thx0
	   set err,etat
	   ret
thx0	   cpi a,'G'
	   jrc thx1
           set err,etat
           ret
thx1	   cpi a,'9'+1
	   jrnc thx2
           subi a,'0'
           ret
thx2	   cpi a,'A'
	   jrnc thx3
           set err,etat
           ret
thx3	   subi a,37h
	   ret

; -- Routine d'mission d'un nombre hexa. 8 bit sous forme ASCI --
; --  deux caractres.  exemple : A2h --->  A (41h) 2 (32h)    --

ehexa8     ld var1,a             ; sauvegarde temporaire
           rlc a                 ; ne possdant pas de dcalage  droite,
           rlc a                 ; on effectue 5 dcalage  gauche  travers
           rlc a                 ; la retenue ( carry ) afin de permuter les
           rlc a                 ; 4 bits de poids fort avec ceux de poids
           rlc a                 ; faible ... ruse de sioux !
           andi a,0fh            ; transmet ainsi les 4 bits MSB sous forme
           addi a,'0'            ; ASCII.
           cpi a,'9'+1           ; selon valeur, emet 0..9 ou bien A..F
           jrc ehx_0
           addi a,7
ehx_0      call emis
           ld a,var1             ; maintenant on va emettre les 4 bits LSB
           andi a,0fh            ; c'est plus rapide.
           addi a,'0'
           cpi a,'9'+1
           jrc ehx_1
           addi a,7
ehx_1      call emis
           ret



; -- Routine de rception d'un caractre par liaison srie asynchrone       --
; -- Le caractre recu est sauvegard dans l'accu A et la variable caracter --


recep      ldi drwr,maskbit0.w   ; pointe, via reg. X, la table des masques
           ldi x,maskbit0.d
recep_0    ldi v,tbit0_r         ; reception bit de start ( tempo reg. V )
           ldi wdr,chien
recep_1    jrs rx,pc,recep_0     ; attend start bit
           ldi wdr,chien
           dec v                 ; tempo start bit
           jrnz recep_1
           ldi w,8               ; initialise le compteur de bits a 8
           ldi wdr,chien         ; relance le chien de garde
           clr a
           com a
           ld  caracter,a        ; initialise caratre reu
recep_2    ldi v,tbit1_r
recep_6    ldi wdr,chien
           dec v
           jrnz recep_6
           ld a,caracter
           jrs rx,pc,recep_3
           and a,(x)
           jp recep_4
recep_3    nop
           nop
recep_4    ld caracter,a
           inc x
           dec w
           jrz recep_5
           jp recep_2
recep_5    ldi v,tbit2_r
recep_7    ldi wdr,chien
           dec v
           jrnz recep_7
           ld a,caracter
           ret


; -- routine d'emission d'un caractere par liaison serie asynchrone --
; -- le caractere a transmettre doit etre charge dans l'accu A      --


emis       ld caracter,a        ; sauvegarde caractere a emettre
           ldi drwr,maskbit1.w  ; pointe, via reg. X, la table des masques
           ldi x,maskbit1.d
           ldi v,tbit0_e        ; emission bit de start ( tempo reg. V )
           res tx,copypc        ; force TX = 0 en conservant la configuration
           ld a,copypc          ; des entrees/sorties
           ld pc,a
emis_0     dec v                ; tempo start bit
           jrnz emis_0
           ldi w,8              ; initialise le compteur de bits a 8
emis_1     ldi wdr,chien        ; relance le chien de garde
           ld a,caracter        ; rappel le caractere a transmettre
           and a,(x)            ; test l'etat du bit courant
           jrnz emis_3          ; selon etat met TX a 1 ou 0 logique
           res tx,copypc
           ld a,copypc
           ld pc,a
           jp emis_4
emis_3     set tx,copypc
           ld a,copypc
           ld pc,a
           nop
emis_4     ldi v,tbit1_e        ; tempo emission d'un bit
emis_5     dec v
           jrnz emis_5
           inc x                ; passe au bit suivant
           dec w
           jrz emis_7           ; si 8 bits transmis, emet stop bit
           jp emis_1
emis_7     nop                  ; 4 nop afin que le temps du huitime bit
           nop                  ; emis soit identique au 7 premiers
           nop
           nop
           set tx,copypc        ; force TX = 1 en conservant la configuration
           ld a,copypc          ; des entrees/sorties
           ld pc,a
           ldi v,tbit2_e
emis_6     dec v                ; tempo start bit
           jrnz emis_6
           ret


;------------------------------------------------------------------------------
;                            Vecteurs d'interruption
;------------------------------------------------------------------------------

;  ***     CAN     ***
           .org 0FF0h
           reti

;  ***     TIMER   ***
           .ORG 0FF2h
           reti

;  ***     PORTB,C ***
           .org 0FF4h
           reti

;  ***     PORTA   ***
           .org 0FF6h
           reti

;  ***     NMI     ***
           .org 0FFCh
           reti

;  ***     RESET   ***
           .org 0FFEh
           jp init_pgm

           .end
