           .title "Minuterie 15 minutes"
           .vers  "st6225"
           .input "6225_reg.asm"
           .w_on

;
;-----------------------------------------------------------------------------
;                          Definition des constantes
;-----------------------------------------------------------------------------

chien      .equ 0FEh            ; valeur du chien de garde
tmz        .equ 7               ; mis a 1 quand Timer(TCR) passe a 0.
ValTimer   .equ 125             ; pour base de temps de 1ms        
TimerMode  .equ 01011010b       ; Division par 4, IT timer autorises
                                ; ( 2s * 4 * 125 = 1ms ) 
RunStop    .equ 0               ; Bit b0 de RegEtat=1 <=> Tempo. en cours
Alarme     .equ 1               ; Bit b1 de RegEtat=1 <=> Alarme sonore
C_Lent     .equ 50              ; Clignotement lent 1 Hz
C_Rapide   .equ 10              ; Clignotement Rapide 5 Hz

BP_Run     .equ 7               ; Bouton poussoir Run / Stop
BP_Moins   .equ 6               ; Bouton poussoir "Moins"
BP_Plus    .equ 5               ; Bouton poussoir "Plus"

;-----------------------------------------------------------------------------
;                  Definition des variables en ram $84  $BF
;-----------------------------------------------------------------------------


BaseRam    .def 084h            ; Dbut de la zone RAM
copypa     .def BaseRam         ; registre image du port A
copypb     .def copypa+1        ; registre image du port B
MultPort   .def copypb+1        ; pour multiplexage des ports A et B       
ClignoP    .def MultPort+1      ; pour clignotement  LED connectes aux ports
Delai0     .def ClignoP+1       ; pour Delais multiples de 1ms 
MilliSec   .def Delai0+1        ; comptage des millisecondes
Secondes   .def MilliSec+1      ; comptage des secondes
Minutes    .def Secondes+1      ; dcomptage des minutes
ValCligno  .def Minutes+1       ; priode de cligontement des LEDs
Delai1     .def ValCligno+1     ; pour gestion delais 10ms
RegEtat    .def Delai1+1        ; registre d'tat du temporisateur
save_a     .def RegEtat+1       ; sauvegarde de l'accu. A pendant I.T. TIMER
save_x     .def save_a+1        ; sauvegarde de l'accu. X pendant I.T. TIMER
RefCligno  .def save_x+1        ; contient rfrence clignotement des LEDs
NBoucles   .def RefCligno+1     ; contient nombre de cycles sonores (alarme)     

;-----------------------------------------------------------------------------
;                             Debut du programme
;-----------------------------------------------------------------------------

           .org 080h

Mask       .byte  00000000b  , 00000000b
           .byte  00000000b  , 00000001b
           .byte  00000000b  , 00000011b
           .byte  00000000b  , 00000111b
           .byte  00000000b  , 00001111b
           .byte  00000000b  , 00011111b
           .byte  00000000b  , 00111111b
           .byte  00000000b  , 01111111b
           .byte  00000000b  , 11111111b
           .byte  00000001b  , 11111111b
           .byte  00000011b  , 11111111b
           .byte  00000111b  , 11111111b
           .byte  00001111b  , 11111111b
           .byte  00011111b  , 11111111b
           .byte  00111111b  , 11111111b
           .byte  01111111b  , 11111111b



StartPGM   ldi wdr,chien          ; rarme le chien de garde
           clr pcdir              ; Port C en entre logique avec R de rappel
           clr pcopt              ; et sans Interruptions
           clr pc
           ldi padir,0FFh         ; Port A en sortie  drain ouvert
           clr paopt
           ldi pa,0FFh 
           ldi copypa,00h
           ldi pbdir,0FFh         ; Port B en sortie  drain ouvert
           ldi pbopt,80h          ; sauf PB7 = sortie symtrique
           ldi pb,07Fh 
           ldi copypb,00h
           ldi Delai1,10          ; 10*1ms = 10ms
           ldi MilliSec,100       ; 100*10ms = 1s
           ldi Secondes,60        ; 60*1s=1minute
           clr Minutes            ; tempo. nulle pour le moment
           clr MultPort
           clr ClignoP
           clr RegEtat            ; pas de tempo en cours
           ldi ValCligno,C_Rapide
           ldi RefCligno,C_Rapide
           ldi tcr,ValTimer
           ldi tscr,TimerMode     ; mode de fonctionnement du TIMER
           ldi ior,00010000b      ; autorise interruptions masquables.
           reti                   ; revient au mode normal.

ModeRegl   ldi ValCligno,C_Rapide
           ldi RefCligno,C_Rapide
ModeIntr   ldi Delai0,150
ModeAtt    ld a,pc                ; Si bouton enfon, anti-rebonds pendant
           com a                  ; une dure de 150 ms
           andi a,11100000b
           jrz ModeIntr
           ld a,Delai0
           jrnz ModeAtt
           ld a,pc                ; Bouton enfonc, lequel est-ce ?
           jrs BP_Run,a,ModeS0    ; Est-ce le bouton Run / Stop ?
           jp ModeR0              ; oui, on y va.
ModeS0     jrr BP_Plus,a,ModeS1   ; Non, Est-ce le bouton "Plus" ?
           jp ModeS2              ; non, alors c'est le bouton "Moins"
ModeS1     ld a,Minutes           ; oui, incrmente minutes si infrieures  15
           cpi a,15
           jrnc ModeS5
           inc Minutes
ModeS5     jp ModeS10
ModeS2     ld a,Minutes           ; dcrmente minutes si suprieur  0
           jrz ModeS10
           dec Minutes
ModeS10    ldi drwr,Mask.w        ; allumes les diodes LED concernes
           ldi x,Mask.d
           ld a,Minutes
           add a,a
           add a,x
           ld x,a
           ld a,(x)
           ld copypb,a
           inc x
           ld a,(x)
           ld copypa,a
ModeToff   ldi Delai0,255
ModeS20    ld a,Delai0                  ; attend 0,25 secondes
           jrnz ModeS20
           jp ModeRegl                  ; retour  la case dpart

ModeR0     ld a,Minutes                 ; Start tempo si Minutes > 0
           jrnz ModeRun
           jp ModeRegl
ModeRun    ldi ValCligno,C_Lent         ; clignotement lent des diodes
           ldi RefCligno,C_Lent
           set RunStop,RegEtat          ; lance tempo

Mode_30    ldi Delai0,255               ; Attend relachement de la touche Run
Mode_31    jrr BP_Run,pc,Mode_30        ; 
           ld a,Delai0                  ; oui, bouton enfonc pendant 0,25s?
           jrnz Mode_31                 ; non, on attend

Mode_S     ldi Delai0,255               ; init. delai de 0.25
Mode_0     jrs BP_Run,pc,Mode_1         ; Arrt forc ?
           ld a,Delai0                  ; oui, bouton enfonc pendant 0,25s?
           jrz Mode_2
           jp Mode_0
Mode_2     res RunStop,RegEtat          ; oui, on arrte tout !
Mode_1     jrs RunStop,RegEtat,Mode_S   ; attend fin tempo
           ldi copypa,00h               ; Termine : on teint toutes les LED
           ldi copypb,00h
           clr Minutes
           jrs Alarme,RegEtat,Mode_Al   ; Tempo arrive  terme ?
           jp ModeRegl                  ; non, pas d'alarme sonore
Mode_Al    res Alarme,RegEtat           ; alarme prise en compte
           ldi NBoucles,6               ; 6 cycles d'impulsions sonores
Alarm_S    ldi w,5                      ; Chaque cycle est constitu de
GeneSon    ldi copypb,80h               ; 5 impulsions sonores 500Hz d'une
           ldi Delai0,100               ; dure de 0,1S puis d'un "blanc"
Alarme0    ldi ClignoP,0FFh             ; inhibe clignotement pour le son...
           ld a,Delai0                  ; d'une dure de 0,255S.
           jrnz Alarme0
           ldi copypb,00h
           ldi Delai0,100
Alarme1    ld a,Delai0
           jrnz Alarme1
           dec w
           jrz Alarme2
           jp GeneSon
Alarme2    ldi Delai0,255
Alarme4    ld a,Delai0
           jrnz Alarme4
           dec NBoucles
           jrz Mode_10
           jp Alarm_S
Mode_10    ldi Delai0,150
Mode_11    ld a,pc                      ; attend aucun boutons non enfoncs
           com a                        ; pendant au moins 150 ms
           andi a,11100000b
           jrnz Mode_10
           ld a,Delai0
           jrnz Mode_11
           jp ModeRegl                  ; retour  la case dpart




;-----------------------------------------------------------------------------
;                       Routine d'interruption du TIMER
;-----------------------------------------------------------------------------

GesTimer   res tmz,tscr            ; relance le TIMER
           ldi tcr,ValTimer
           ldi wdr,chien
           ld save_a,a
           ld a,x
           ld save_x,a

           ; Gestion du multiplexage visuel des ports
           
           ld a,copypa            ; Toutes les millisecondes les ports
           and a,MultPort         ; sont alternativement activs.
           and a,ClignoP          ; => toutes les millisecondes le Flag
           com a
           ld pa,a                ;    ClignoP est complment.
           ld a,MultPort
           com a
           ld MultPort,a
           and a,copypb
           and a,ClignoP
           com a
           ld pb,a

           ; Gestion du delai programmable depuis le corps : Delai0

           ld a,Delai0
           jrz Gest_0
           dec Delai0

           ; Gestion base de temps de 10ms et clignotement des LEDs

Gest_0     dec Delai1
           jrz Gest_2
           jp Gest_Fin
Gest_2     ldi Delai1,10          ; init. nouveau cycle de 10ms
           dec ValCligno          ; gestion clignotement des LEDs
           jrnz Gest_6
           ld a,RefCligno
           ld ValCligno,a
           ld a,ClignoP           ; permutation de l'tat des bits
           com a
           ld ClignoP,a

           ; Gestion de la temporisation si RunStop = 1 (Tempo en cours)

Gest_6     jrs RunStop,RegEtat,Gest_1
           jp Gest_Fin
Gest_1     dec MilliSec           ; dcrmente les millisecondes
           jrz Gest_7
           jp Gest_Fin
Gest_7     ldi MilliSec,100       ; init. nouveau cycle de 1 seconde
           dec Secondes           ; dcrmente les secondes
           jrz Gest_4
           jp Gest_Fin
Gest_4     ldi Secondes,60        ; init. nouveau cycle de 1 minute
           dec Minutes            ; dcrmente les minutes
           jrnz Gest_5
           res RunStop,RegEtat    ; arrt tempo
           set Alarme,RegEtat     ; tempo arrive normalement  terme
Gest_5     ldi drwr,Mask.w        ; allumes les diodes LED concernes
           ldi x,Mask.d
           ld a,Minutes
           add a,a
           add a,x
           ld x,a
           ld a,(x)
           ld copypb,a
           inc x
           ld a,(x)
           ld copypa,a
Gest_Fin   ld a,save_x
           ld x,a
           ld a,save_a            ; restitue le contenu de l'accu A
           reti     


;-----------------------------------------------------------------------------
;                         Vecteurs d'interruption
;-----------------------------------------------------------------------------

;  ***     CAN     ***
           .org 0FF0h
           reti

;  ***     TIMER   ***
           .ORG 0FF2h
           jp GesTimer

;  ***     PORTB,C ***
           .org 0FF4h
           reti

;  ***     PORTA   ***
           .org 0FF6h
           reti

;  ***     NMI     ***
           .org 0FFCh
           reti

;  ***     RESET   ***
           .org 0FFEh
           jp StartPGM

           .end
