           .title "Serrure codee 4 chiffres"
           .vers  "st6225"
           .input "6225_reg.asm"
           .w_on

; Mode de fonctionnement des ports parallles A, B et C
;          - Port A : PA0  PA3 : entre logique avec R de rappel sans IT
;                     PA4  PA7 : sortie logique  drain ouvert          
;          - Port B : PB0  PB3 : entre logique avec R de rappel sans IT
;                     PB4  PB7 : sortie logique  drain ouvert          
;          - Port C : tout en sortie symtrique.
;
;  !---------!-------------------!-----------------!------------------!
;  ! ....... !  DDR  direction   !   OR   option   !  DR   donnees    !
;  !---------!-------------------!-----------------!------------------!
;  ! port A  !  11110000 =   F0h ! 00000000 = 00h  ! 11110000 = F0h   !
;  !---------!-------------------!-----------------!------------------!
;  ! port B  !  11110000 =   F0h ! 00000000 = 00h  ! 11110000 = F0h   !
;  !---------!-------------------!-----------------!------------------!
;  ! port C  !  11110000 =   F0h ! 11110000 = F0h  ! 10000000 = 80h   !
;  !---------!-------------------!-----------------!------------------!
;
;
;-----------------------------------------------------------------------------
;                          Definition des constantes
;-----------------------------------------------------------------------------

chien      .equ 0FEh            ; valeur du chien de garde
DelaiT     .equ 80              ; dlai de 80ms entre deux frappes de touches
Annule     .equ 10              ; Touche annulation = touche code 10
Valide     .equ 11              ; Touche validation = touche code 11
LED        .equ 7               ; PC7 = commande LED (active  l'tat 0)
RELAIS     .equ 4               ; PC4 = commande relais (active  l'tat 1)
DelaiR     .equ 3000            ; temporisation relais = 3000ms = 3s

;-----------------------------------------------------------------------------
;                  Definition des variables en ram $84  $BF
;-----------------------------------------------------------------------------


BaseRam    .def 084h            ; Dbut de la zone RAM
NBchiffr   .def BaseRam         ; nombre de chiffres saisis                
CodeC1     .def NBchiffr+1      ; mmoire du chiffre N1 du code secret      
CodeC2     .def CodeC1+1        ; mmoire du chiffre N2 du code secret      
CodeC3     .def CodeC2+1        ; mmoire du chiffre N3 du code secret      
CodeC4     .def CodeC3+1        ; mmoire du chiffre N4 du code secret      
ClavC1     .def CodeC4+1        ; mmoire du chiffre N1 saisi au clavier
ClavC2     .def ClavC1+1        ; mmoire du chiffre N2 saisi au clavier
ClavC3     .def ClavC2+1        ; mmoire du chiffre N3 saisi au clavier
ClavC4     .def ClavC3+1        ; mmoire du chiffre N4 saisi au clavier
code       .def ClavC4+1        ; code de la touche enfonce
frappe     .def code+1          ; indicateur touche enfonce
count0     .def frappe+1        ; index des colonnes du clavier
count1     .def count0+1        ; index des lignes du clavier
masque     .def count1+1        ; gestion des colonnes de touches
rebonds    .def masque+1        ; gestion des rebonds des touches

;-----------------------------------------------------------------------------
;                             Debut du programme
;-----------------------------------------------------------------------------

           .org 080h

StartPGM   ldi wdr,chien          ; rarme le chien de garde
           ldi padir,0F0h
           ldi paopt,0
           ldi pa,0F0h
           ldi pbdir,0F0h
           ldi pbopt,0
           ldi pb,0F0h
           ldi pcdir,0F0h
           ldi pcopt,0F0h
           ldi pc,80h
           clr code               ; aucune touche enfonce pour le moment
           clr frappe
           clr adcr               ; convertisseur non utilis
           clr tscr               ; timer non utilis
           clr ior                ; pas d'IT. Reste en mode NMI

           ; dbut de la gestion de la serrure code

           ldi wdr,chien
           call Secret            ; lecture et mmorisation code secret
Nouveau    ldi NBchiffr,4         ; aucun chiffre saisi pour le moment
Att_T      call Clavier           ; touche appuye ?
           ld a,frappe
           jrz Att_T              ; non, on attend
Att_R      call Clavier           ; oui, attend relache de la touche
           ld a,frappe
           jrnz Att_R
           ld a,code              ; Touche numrique ?
           cpi a,10
           jrc TouchNum           ; oui, va mmoriser le code saisi
           jp TouchCom            ; non, alors c'est une commande.
TouchNum   ld a,NBchiffr          ; Les 4 chiffres saisis ?
           jrnz NumSuite          ; non, continu la saisie
           jp Att_T               ; oui, n'en tient pas compte...
NumSuite   ld a,NBchiffr          ; mmorise code touche enfonce
           addi a,ClavC1-1
           ld x,a
           ld a,code
           ld (x),a
           dec NBchiffr           ; dcrment pointeur de codes saisis
           res LED,pc             ; LED allume pendant 50mS
           ldi a,50/4
           call Tempor
           set LED,pc
           jp Att_T               ; continu la saisie
TouchCom   cpi a,Annule           ; command d'annulation du code ?
           jrnz T_Valide          ; non, peut tre une validation de code...
           jp Nouveau             ; oui, on recommence tout depuis le dbut!
T_Valide   cpi a,Valide           ; commande de validation ?
           jrz Val_Suite          ; oui, teste validit
           jp Att_T               ; non, qu'est-ce que cela peut tre ???
Val_Suite  ld a,NBchiffr          ; teste si 4 chiffres effectivement saisis
           jrz Val_Ok             ; oui, va comparer les codes
           jp Att_T               ; non, attend suite de la saisie des chiffres
Val_Ok     ldi y,CodeC4           ; comparaison indexe des codes
           ldi x,ClavC4
           ldi v,4
Test_S     ld a,(x)
           cp a,(y)
           jrnz Pas_Ident         ; codes diffrents, on sort...
           dec x
           dec y
           dec v                  ; les 4 chifres tests ?
           jrnz Test_S
           jp CodeIdent           ; codes identiques, va ouvrir la porte...
Pas_Ident  ldi w,10               ; clignotement rapide de la LED pendant
Pas_S      res LED,pc             ; environ 2s
           ldi a,100/4            ; LED = 1 pendant environ 0,1S
           call Tempor
           set LED,pc
           ldi a,100/4            ; LED = 0 pendant environ 0,1S
           call Tempor
           dec w
           jrnz Pas_S
           jp Nouveau
CodeIdent  res LED,pc             ; codes identiques : allumage LED
           set RELAIS,pc          ; activation du relais
           ldi a,DelaiR/(3*4)     ; tempo relais
           call Tempor
           ldi a,DelaiR/(3*4)     ; tempo relais
           call Tempor
           ldi a,DelaiR/(3*4)     ; tempo relais
           call Tempor
           set LED,pc             ; extinction LED
           res RELAIS,pc          ; dsactivation du relais
           jp Nouveau             ; retour  la case dpart...

;-----------------------------------------------------------------------------
;                             Dfinition des sous-programmes
;-----------------------------------------------------------------------------

; sous-programme de saisi d'une touche au clavier

Clavier    ldi wdr,chien
           clr frappe             ; aucune touche pour le moment
           ldi masque,11101111b
           ldi count0,4
           ; dtermination de la colonne concerne
clav_0     ld a,masque
           andi a,11110000b       ; conserve PB0  PB3 en entre
           ld pb,a                ; affecte la colonne courante
           nop                    ; dlai pour stabilisation des entres
           nop
           nop
           nop
           ld a,pb                ; teste si touche enfonce
           andi a,0Fh
           cpi a,0Fh              ; touche enfonce ?
           jrnz T_ok              ; oui, va l'identifier
           dec count0             ; non, passe  la colonne suivante
           jrz Pas_tch            ; si les 4 colonnes testes, c'est fini!
           ld a,masque            ; sinon on prpare la colonne suivante
           sla a
           ld masque,a
           jp clav_0
Pas_tch    ret                    ; aucune touche appuye : frappe=0
T_ok       ld rebonds,a           ; mmorise l'tat des lignes
           ldi a,4
           sub a,count0            ; rcupre numro de colonne
           ld count0,a
           ; limination des rebonds ventuels
           ldi v,255
tempo      ld a,pb
           andi a,0Fh
           cp a,rebonds
           jrz clav_1             ; pas de rebonds pour le moment
           jp Clavier             ; rebonds, on recommence...
clav_1     ldi wdr,chien
           dec v                  ; dlai anti-rebonds termin ?
           jrz clav_2             ; oui, va dterminer quelle touche
           jp tempo               ; non, attend fin tempo anti-rebonds
           ; dtermination du numro de ligne
clav_2     ldi count1,0           ; dtermine numro de ligne
           ld a,rebonds
           sla a
           sla a
           sla a
           sla a
clav_3     sla a                  ; touche dtecte ?
           jrnc clav_4            ; oui, c'est presque fini
           inc count1             ; non, count1 = count1 + 4
           inc count1             ; 
           inc count1             ; 
           inc count1             ; 
           jp clav_3
           ; dtermination code de la touche
clav_4     ld a,count1
           add a,count0
           ld code,a
           ldi frappe,0FFh        ; indique touche enfonce...
           ldi pb,11110000b       ; dsactive colonne du clavier
           ldi a,DelaiT/4
           call Tempor            ; dlai de 0,1S pour viter frappe trop
           ret                    ; rapide...

; sous-programme de lecture et mmorisation du code secret dfini par les
; interrupteurs situs sur la carte principale.

Secret     ldi pa,11100000b       ; lecture chiffre 1 code secret
           nop
           nop
           nop
           ld a,pa
           andi a,0Fh
           ld CodeC1,a
           ldi pa,11010000b       ; lecture chiffre 2 code secret
           nop
           nop
           nop
           ld a,pa
           andi a,0Fh
           ld CodeC2,a
           ldi pa,10110000b       ; lecture chiffre 3 code secret
           nop
           nop
           nop
           ld a,pa
           andi a,0Fh
           ld CodeC3,a
           ldi pa,01110000b       ; lecture chiffre 4 code secret
           nop
           nop
           nop
           ld a,pa
           andi a,0Fh
           ld CodeC4,a
           ldi pa, 0Fh
           ret

; sous-programme de temporisation multiple de 4mS
;  l'appel, l'accu A contient la valeur de la tempo. / 4 en millisecondes
; Ex: si Accu A = 10, tempo=10*4=40ms
; Ce sous-programme autorise des temporisations comprise entre 4 et 1000mS


Tempor     ldi v,250
Temp0      ldi wdr,chien
           dec v
           jrnz Temp0
           dec a
           jrnz Tempor
           ret



;-----------------------------------------------------------------------------
;                         Vecteurs d'interruption
;-----------------------------------------------------------------------------

;  ***     CAN     ***
           .org 0FF0h
           reti

;  ***     TIMER   ***
           .ORG 0FF2h
           nop
           reti

;  ***     PORTB,C ***
           .org 0FF4h
           reti

;  ***     PORTA   ***
           .org 0FF6h
           reti

;  ***     NMI     ***
           .org 0FFCh
           reti

;  ***     RESET   ***
           .org 0FFEh
           jp StartPGM

           .end
