{ Ce programme illustre la programmation directe de l'UART en TURBO PASCAL   }
{ Dans le source propos il n'y a aucun contrles effectus quant  la       }
{ validit du code reu , de plus l'mission et la rception ne sont pas     }
{ gres par interruptions ce qui n'autorise pas le mode full duplex.        }

{ Amliorations ventuelles  prvoir : Gestion des erreurs de transmission  }
{                                       Rception sur interruptions          }
program liaison_serie;

const
  COM2 = $2F8;     { adresse de base du port srie N1                       }
  COM1 = $3F8;     { adresse de base du port srie N2                       }
  offset_THR = 0;  { registre tampon d'mission                              }
  offset_RBR = 0;  { registre tampon de rception                            }
  offset_IER = 1;  { Validation des interruptions                            }
  offset_IIR = 2;  { Identification des interruptions                        }
  offset_LCR = 3;  { Commande de ligne                                       }
  offset_MCR = 4;  { Commande de modem                                       }
  offset_LSR = 5;  { Etat de la ligne                                        }
  offset_MSR = 6;  { Etat du modem                                           }
  div_msb =1;      { Accs au diviseur de frquence                          }
  div_lsb =0;
  acces_diviseur =$80;
  SansParite    = 8*0;
  PariteImpaire = 8*1;
  ParitePaire   = 8*3;
  PariteUn      = 8*5;
  PariteZero    = 8*7;

var
 car : byte;

Procedure InitCOM(NumCOM,baud:word; parite,NBBits,NBStop : byte);
var
 DivLsb , DivMSB , Config , Nbits , Nstop : byte;
begin
 case baud of
    50 : begin DivMSB := 9    ; DivLSB := 0     ;  end;
    75 : begin DivMSB := 6    ; DivLSB := 0     ;  end;
   110 : begin DivMSB := 4    ; DivLSB := 23    ;  end;
   150 : begin DivMSB := 3    ; DivLSB := 0     ;  end;
   300 : begin DivMSB := 1    ; DivLSB := 128   ;  end;
   600 : begin DivMSB := 0    ; DivLSB := 192   ;  end;
  1200 : begin DivMSB := 0    ; DivLSB := 96    ;  end;
  2400 : begin DivMSB := 0    ; DivLSB := 48    ;  end;
  4800 : begin DivMSB := 0    ; DivLSB := 24    ;  end;
  9600 : begin DivMSB := 0    ; DivLSB := 12    ;  end;
 19200 : begin DivMSB := 0    ; DivLSB := 6     ;  end;
   else  begin writeln('Vitesse de transmission incorrecte'); exit; end;
 end;
 case NBBits of
    5  : Nbits := 0;
    6  : Nbits := 1;
    7  : Nbits := 2;
    8  : Nbits := 3;
   else  begin writeln('Nombre de bits incorrect'); exit; end;
 end;
 case NBStop of
    1  : Nstop := 0;
    2  : Nstop := 4;
   else  begin writeln('Nombre de bits de STOP incorrect'); exit; end;
 end;

 port[NumCOM+offset_LCR]:= acces_diviseur;
 port[NumCOM+div_msb]   := DivMSB;
 port[NumCOM+div_lsb]   := DivLSB;
 Config := Nbits or Nstop or parite;
 port[NumCOM+offset_LCR]:= Config;

end;


function COMin(NumCOM:word):byte;                 { rception d'un caractre }
begin
repeat until (port[NumCom+offset_LSR] and $01)<>0;{ attend si caractre reu }
COMin := port[NumCOM+offset_RBR];                 { Si oui, renvoit caractre}
end;


Procedure COMout(NumCOM:word;code:byte);          { mission d'un caractre  }
begin
repeat until (port[NumCOM+offset_LSR] and $20)<>0;{ Teste si tampon vide     }
port[NumCOM+offset_THR]:= code;                   { Si oui, envoit caractre }
end;

{ ================================ CORPS =================================== }

BEGIN

{ Exemple d'utilisation et d'initialisation du port srie 1 ( COM1 )         }

InitCOM( COM1 , 1200 , ParitePaire , 8 , 2 );
COMout(COM1,ord('A'));
car := COMin(COM1);

END.
