program TestCarteIO;

uses
 crt, dos, graph;

type
 TB    = array[1..518] of byte;

const
 { utilises pour la barre d'outils et le burreau }
 LBouton     : byte = 32;
 Hbouton     : byte = 32;
 MargeBouton : byte = 7;
 NBouton     : byte = 16;
 AucunBouton : byte = 255;
 CouleurFondBurreau    : byte = darkgray;
 CouleurFondTableau    : byte = lightblue;
 CouleurBordureTableau : byte = yellow;
 IconesOutils: array[0..15] of string[13] =
  ( 'SORTIE1.ICN', 'SORTIE2.ICN','SORTIE3.ICN'  , 'SORTIE4.ICN',
    'SORTIE5.ICN', 'SORTIE6.ICN', 'SORTIE7.ICN', 'SORTIE8.ICN',
    'RIEN.ICN', 'LOGIQUE1.ICN', 'ANALOG1.ICN', 'ANALOG2.ICN',
    'RIEN.ICN', 'RIEN.ICN'  , 'READY.ICN', 'SORTIR.ICN'  );
 ON  : boolean = true;
 OFF : boolean = false;
 XBMenu : word = 10;
 YBMenu : word = 10;
 BoutonsVisiblesBarreOutils : array[0..15] of byte =
  ( 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 1 , 1 , 1 , 0 , 0 , 1 , 1 );
 MasqueBit : array[1..8] of byte =
  ( 1 , 2 , 4 , 8 , 16 , 32 , 64 , 128 );

 { utilises pour la liason srie }
 COM2 = $2F8;     { adresse de base du port srie N2                       }
 COM1 = $3F8;     { adresse de base du port srie N1                       }
 offset_THR = 0;  { registre tampon d'mission                              }
 offset_RBR = 0;  { registre tampon de rception                            }
 offset_IER = 1;  { Validation des interruptions                            }
 offset_IIR = 2;  { Identification des interruptions                        }
 offset_LCR = 3;  { Commande de ligne                                       }
 offset_MCR = 4;  { Commande de modem                                       }
 offset_LSR = 5;  { Etat de la ligne                                        }
 offset_MSR = 6;  { Etat du modem                                           }
 div_msb =1;      { Accs au diviseur de frquence                          }
 div_lsb =0;
 acces_diviseur =$80;
 SansParite    = 8*0;
 PariteImpaire = 8*1;
 ParitePaire   = 8*3;
 PariteUn      = 8*5;
 PariteZero    = 8*7;


var
 { utilises pour la barre d'outils, la souris et le burreau }
 regs        : registers;
 PosPX       ,            {Position X du pointeur souris en mode graphique }
 PosPY       : word;      {Position Y du pointeur souris en mode graphique }
 BoutonDroit ,            {Etat du bouton droit de la souris               }
 BoutonGauche: boolean;   {Etat du bouton gauche de la souris              }
 Carte,
 ModeGraph   : integer;
 maxx , maxy : integer;   {Coordonnes maxi en X et en Y                   }
 NomLogo     : string;
 TBimage     : TB;
 fin         : file of TB;
 NumBoutonBarreOutils : byte;
 FinProgramme: boolean;
 EtatSortiesLogiques ,
 EtatEntreesLogiques  : byte;
 ValeurCanal1 , ValeurCanal2 : byte;

 { utilises pour la liason srie }
 car     : byte;
 TimeOut : boolean;
 VCOM    : word;
 NCOM    : string;


Procedure InitCOM(NumCOM,baud:word; parite,NBBits,NBStop : byte);
var
 DivLsb , DivMSB , Config , Nbits , Nstop : byte;
begin
 case baud of
    50 : begin DivMSB := 9    ; DivLSB := 0     ;  end;
    75 : begin DivMSB := 6    ; DivLSB := 0     ;  end;
   110 : begin DivMSB := 4    ; DivLSB := 23    ;  end;
   150 : begin DivMSB := 3    ; DivLSB := 0     ;  end;
   300 : begin DivMSB := 1    ; DivLSB := 128   ;  end;
   600 : begin DivMSB := 0    ; DivLSB := 192   ;  end;
  1200 : begin DivMSB := 0    ; DivLSB := 96    ;  end;
  2400 : begin DivMSB := 0    ; DivLSB := 48    ;  end;
  4800 : begin DivMSB := 0    ; DivLSB := 24    ;  end;
  9600 : begin DivMSB := 0    ; DivLSB := 12    ;  end;
 19200 : begin DivMSB := 0    ; DivLSB := 6     ;  end;
   else  begin writeln('Vitesse de transmission incorrecte'); exit; end;
 end;
 case NBBits of
    5  : Nbits := 0;
    6  : Nbits := 1;
    7  : Nbits := 2;
    8  : Nbits := 3;
   else  begin writeln('Nombre de bits incorrect'); exit; end;
 end;
 case NBStop of
    1  : Nstop := 0;
    2  : Nstop := 4;
   else  begin writeln('Nombre de bits de STOP incorrect'); exit; end;
 end;

 port[NumCOM+offset_LCR]:= acces_diviseur;
 port[NumCOM+div_msb]   := DivMSB;
 port[NumCOM+div_lsb]   := DivLSB;
 Config := Nbits + Nstop + parite;
 port[NumCOM+offset_LCR]:= Config;

end;


function COMin(NumCOM:word):byte;                 { rception d'un caractre }
var
 valtime : word;
begin
 valtime := 500;
 TimeOut := false;
 repeat
 delay(1);
 if valtime<>0 then dec(valtime)
               else TimeOut :=true;
 until ((port[NumCom+offset_LSR] and $01)<>0) or TimeOut; { attend caractere }
 COMin := port[NumCOM+offset_RBR];                { Si oui, renvoit caractre}
end;


Procedure COMout(NumCOM:word;code:byte);          { mission d'un caractre  }
begin
repeat until (port[NumCOM+offset_LSR] and $20)<>0;{ Teste si tampon vide     }
port[NumCOM+offset_THR]:= code;                   { Si oui, envoit caractre }
end;




{ Dtecte la prsence d'une ventuelle souris }
Function DetecteSouris:boolean;
begin
 regs.ax := $00;
 intr($33,regs);
 if regs.ax <> $FFFF then DetecteSouris := false
                     else DetecteSouris := true;
end;


{ rend le curseur visible }
procedure SourisVisible;
begin
 Regs.ax := $0001;
 intr($33,regs);
end;


{ rend le curseur invisible }
procedure SourisInvisible;
begin
 Regs.ax := $0002;
 intr($33,regs);
end;


{ Dtermine la position de la souris }
procedure PositionSouris;
begin
 regs.ax := $03;
 intr($33,regs);
 PosPX := regs.cx;
 PosPY := regs.dx;
end;


{ teste l'tat des boutons gauche et droit }
procedure EtatBoutonSouris;
begin
 regs.ax := $03;
 intr($33,regs);
 if (regs.bx and $02) <> 0 then BoutonDroit := true
                           else BoutonDroit := false;
 if (regs.bx and $01) <> 0 then BoutonGauche := true
                           else BoutonGauche := false;
end;


{ Vido en mode graphique }
procedure EcranGraphique;
var errcode:integer;
begin
  carte:=detect;
  initgraph(carte,modegraph,''); { dans le rpertoire courant }
  errcode:=graphresult;
  if errcode<>grok then
   begin
   writeln('Erreur  l''initialistion du mode graphique');
   writeln('Code de l''erreur : ',errcode);
   halt
   end;
  maxx:=getmaxx;
  maxy:=getmaxy;
end;


{ vido en mode texte }
procedure EcranTexte;
begin
 closegraph;
 restoreCRTMode;
end;


{ chargement du logo depuis le disque dur en RAM }
procedure ChargeLogo(NomLogo:string);
begin
 assign(fin,NomLogo);
 {$I-}
 reset(fin);
 {$I+}
 if(ioresult<>0)
   then begin
   EcranTexte;
   writeln('Fichiers "',NomLogo,' manquants...');
   halt;
   end
   else begin
   read(fin,TBimage);
   close(fin);
   end;
end;



{ Affiche image bitmap d'un bouton }
Procedure LogoBouton(x,y:word; var tbi : TB);
begin
 putimage(x,y,tbi,normalput);
end;


{ Dessine le contour du bouton selon son tat                      }
{ X , Y : coordonnes coin suprieur gauche du bouton  redessiner }
{ Etat  : ON , OFF                                                 }
{ La largeur du bouton est dfinie en pixels dans LBouton          }
{ La hauteur du bouton est dfinie en pixels dans LBouton          }
Procedure EtatBouton(x,y : word; etat:boolean);
var
 c1 , c2 : byte;
begin
 setlinestyle(solidln,0,normwidth);
 if etat then begin  c1 := black;   c2 := white;  end
         else begin  c2 := black;   c1 := white;  end;
 setcolor(c1);
 line(x-2,y-2,x+Lbouton+1,y-2);
 line(x-1,y-1,x+Lbouton+0,y-1);
 line(x-2,y-1,x-2,y+HBouton+1);
 line(x-1,y,x-1,y+HBouton);
 setcolor(c2);
 line(x-1,y+HBouton+1,x+LBouton+1,y+HBouton+1);
 line(x,y+HBouton,x+LBouton,y+HBouton);
 line(x+LBouton,y,x+LBouton,y+HBouton-1);
 line(x+LBouton+1,y-1,x+LBouton+1,y+HBouton);
end;

{ dtermine si le pointeur souris est dans une zone rectangulaire de l'cran}
function ZonePointeur(x1,y1,x2,y2:word):boolean;
begin
 if (PosPX>=x1)and(PosPX<=x2)and(PosPY>=y1)and(PosPY<=y2)
   then ZonePointeur := true
   else ZonePointeur := false;
end;


{ Attend une action sur la souris ou le clavier }
Procedure AttendActionSouris;
var
 oldbg, oldbd : boolean;
 ppx , ppy    : word;
begin
 EtatBoutonSouris;
 PositionSouris;
 oldbg := BoutonGauche;
 oldbd := BoutonDroit;
 ppx := PosPX;
 ppy := PosPY;
 repeat
   EtatBoutonSouris;
   PositionSouris;
 until(oldbg<>BoutonGauche)or(oldbd<>BoutonDroit)or(ppx<>PosPX)or(ppy<>PosPY);
end;


{ Dessine la barre d'outils }
Procedure DessineBarreOutils;
var
 i : byte;
begin
 for i := 0 to NBouton-1 do
 begin
  if BoutonsVisiblesBarreOutils[i] = 1 then
   begin
   Chargelogo(IconesOutils[i]);
   LogoBouton(XBmenu+i*(32+MargeBouton),YBmenu,TBimage);
   EtatBouton(XBmenu+i*(32+MargeBouton),YBmenu,Off);
   end;
 end;
end;


{Dtecte si un bouton de la barre d'outils a t enfonc (bouton souris Gauch}
{et renvoie le numro du bouton si tel est le cas dans NumBoutonBarreOutils  }
procedure ClickBarreOutils;
var
 OldNumBouton , NewNumBouton : byte;
begin
 OldNumBouton := AucunBouton;
 NumBoutonBarreOutils := AucunBouton;
 if not(BoutonGauche) then exit;
 while BoutonGauche and not(BoutonDroit) and
       ZonePointeur( XBMenu , YBMenu , XBmenu+(LBouton+MargeBouton)*NBouton ,
                     YBMenu+HBouton-1) do
   begin
   NewNumBouton := (PosPX-XBMenu) div (LBouton+MargeBouton);
   if (NewNumBouton<>OldNumBouton)and(NewNumBouton<NBouton) then
    begin
    SourisInvisible;
    if (OldNumBouton<>AucunBouton)and(BoutonsVisiblesBarreOutils[OldNumBouton]=1) then
        EtatBouton(XBmenu+(Lbouton+MargeBouton)*OldNumBouton,YBmenu,Off);
    if BoutonsVisiblesBarreOutils[NewNumBouton]=1 then
        EtatBouton(XBmenu+(Lbouton+MargeBouton)*NewNumBouton,YBmenu,On);
    SourisVisible;
    OldNumBouton := NewNumBouton;
    end;
   AttendActionSouris;
   end;
 if BoutonsVisiblesBarreOutils[OldNumBouton]=1 then
  begin
  SourisInvisible;
  EtatBouton(XBmenu+(Lbouton+MargeBouton)*OldNumBouton,YBmenu,Off);
  SourisVisible;
  end;
 if ZonePointeur( XBMenu , YBMenu , XBmenu+(LBouton+MargeBouton)*NBouton,
    YBMenu+HBouton-1) and (BoutonsVisiblesBarreOutils[OldNumBouton]=1)
    then NumBoutonBarreOutils := OldNumBouton
    else NumBoutonBarreOutils := AucunBouton;
end;


{ Dessine fentre affichage valeur numrique }
Procedure Tableau(x,y,LTableau,HTableau,cf,cb:word;titre:string);
var
 SurfaceTableau : array[1..4] of pointtype;
begin
 SurfaceTableau[1].x := x            ;  SurfaceTableau[1].y := y;
 SurfaceTableau[2].x := x+LTableau-1 ;  SurfaceTableau[2].y := y;
 SurfaceTableau[3].x := x+LTableau-1 ;  SurfaceTableau[3].y := y+HTableau-1;
 SurfaceTableau[4].x := x            ;  SurfaceTableau[4].y := y+HTableau-1;
 setfillstyle(solidfill,CF);
 setlinestyle(solidln,0,normwidth);
 setcolor(CB);
 fillpoly(4,SurfaceTableau);
 moveto(x+LTableau div 2,y+12);
 settextstyle(Defaultfont,Horizdir,1);
 settextjustify(centertext,bottomtext);
 outtext(titre);
end;


{Dessine le burreau}
procedure DessineBurreau(TypeAction:byte);
const
 XFenAnalg1 : word =70  ;            YFenAnalg1 : word =300;
 XFenAnalg2 : word =370 ;            YFenAnalg2 : word =300;
 XFenLogiq1 : word =45  ;            YFenLogiq1 : word =150;
 XFenLogiq2 : word =340 ;            YFenLogiq2 : word =150;
 LFenAnalg1 : word =200 ;            HFenAnalg1 : word =60 ;
 LFenAnalg2 : word =200 ;            HFenAnalg2 : word =60 ;
 LFenLogiq1 : word =250 ;            HFenLogiq1 : word =50 ;
 LFenLogiq2 : word =250 ;            HFenLogiq2 : word =50 ;
var
 SurfaceBurreau : array[1..4] of pointtype;
 rect : array[1..4] of pointtype;
 i : byte;
 s : string[3];
begin
 case TypeAction of
 0 : begin
   { rempli le fond du burreau }
   SurfaceBurreau[1].x := 0;       SurfaceBurreau[1].y := 0;
   SurfaceBurreau[2].x := maxx;    SurfaceBurreau[2].y := 0;
   SurfaceBurreau[3].x := maxx;    SurfaceBurreau[3].y := maxy;
   SurfaceBurreau[4].x := 0;       SurfaceBurreau[4].y := maxy;
   setfillstyle(solidfill,CouleurFondBurreau);
   fillpoly(4,SurfaceBurreau);
   { dessine les 2 fentres analogiques et les deux fentres logiques }
   Tableau( XFenAnalg1, YFenAnalg1, LFenAnalg1, HFenAnalg1,
            lightgray, yellow, 'Entre Analogique N1' );
   Tableau( XFenAnalg2, YFenAnalg2, LFenAnalg2, HFenAnalg2,
            lightgray, yellow, 'Entre Analogique N2' );
   Tableau( XFenLogiq1, YFenLogiq1, LFenLogiq1, HFenLogiq1,
            lightgray, yellow, 'Sorties logiques' );
   Tableau( XFenLogiq2, YFenLogiq2, LFenLogiq2, HFenLogiq2,
            lightgray, yellow, 'Entres logiques' );
   setcolor(brown);
   for i := 1 to 8 do
    begin
    str(i,s);
    outtextxy(XFenLogiq1+37+25*(i-1),YFenLogiq1+23,s);
    outtextxy(XFenLogiq2+37+25*(i-1),YFenLogiq2+23,s);
    end;
     end;

 1 : begin
     setlinestyle(solidln,0,thickwidth);
     setcolor(darkgray);
     for i := 1 to 8 do
      begin
      rect[1].x := XFenLogiq1+25+25*(i-1);
      rect[1].y := YFenLogiq1+25;
      rect[2].x := XFenLogiq1+25+25*(i);
      rect[2].y := rect[1].y;
      rect[3].x := rect[2].x;
      rect[3].y := YFenLogiq1+40;
      rect[4].x := rect[1].x;
      rect[4].y := rect[3].y;
      if (EtatSortiesLogiques and MasqueBit[i]) = 0
         then setfillstyle(solidfill,lightgreen)
         else setfillstyle(solidfill,lightred);
      fillpoly(4,rect);
      end;
     end;

 2 : begin
     setlinestyle(solidln,0,thickwidth);
     setcolor(darkgray);
     for i := 1 to 8 do
      begin
      rect[1].x := XFenLogiq2+25+25*(i-1);
      rect[1].y := YFenLogiq2+25;
      rect[2].x := XFenLogiq2+25+25*(i);
      rect[2].y := rect[1].y;
      rect[3].x := rect[2].x;
      rect[3].y := YFenLogiq2+40;
      rect[4].x := rect[1].x;
      rect[4].y := rect[3].y;
      if (EtatEntreesLogiques and MasqueBit[i]) = 0
         then setfillstyle(solidfill,lightgreen)
         else setfillstyle(solidfill,lightred);
      fillpoly(4,rect);
      end;
     end;

 3 : begin
     Tableau( XFenAnalg1, YFenAnalg1, LFenAnalg1, HFenAnalg1,
              lightgray, yellow, 'Entre Analogique N1' );
     moveto(XFenAnalg1 + LFenAnalg1 div 2 ,YFenAnalg1 + HFenAnalg1 div 2);
     settextjustify(centertext,centertext);
     settextstyle(Defaultfont,Horizdir,3);
     setcolor(blue);
     str(ValeurCanal1,s);
     outtext(s);
     end;

 4 : begin
     Tableau( XFenAnalg2, YFenAnalg2, LFenAnalg2, HFenAnalg2,
              lightgray, yellow, 'Entre Analogique N2' );
     moveto(XFenAnalg2 + LFenAnalg2 div 2 ,YFenAnalg2 + HFenAnalg2 div 2);
     settextjustify(centertext,centertext);
     settextstyle(Defaultfont,Horizdir,3);
     setcolor(blue);
     str(ValeurCanal2,s);
     outtext(s);
     end;
 end;
end;

procedure MauvaiseLiaison;
const
 LFenDiag = 440;
 HFenDiag = 50;
 XFenDiag = (640 - LFenDiag) div 2;
 YFenDiag = 480 - 60;

begin
 SourisInvisible;
 Tableau( XFenDiag, YFenDiag, LFenDiag, HFenDiag,
          lightred, white, 'Etat dilaogue' );
 moveto(XFenDiag + LFenDiag div 2 ,YFenDiag + HFenDiag div 2);
 settextjustify(centertext,centertext);
 settextstyle(Defaultfont,Horizdir,1);
 setcolor(white);
 outtext('Dfaut de communication ! ... CLIQUEZ ICI ');
 SourisVisible;
 sound(110); delay(20); nosound; delay(100);
 sound(110); delay(20); nosound; delay(100);
 sound(110); delay(20); nosound; delay(100);
 repeat
 AttendActionSouris;
 until ZonePointeur(XFenDiag,YFenDiag,XFenDiag+LFenDiag,YFenDiag+HFenDiag)
       and BoutonGauche;
 SourisInvisible;
 Tableau( XFenDiag, YFenDiag, LFenDiag, HFenDiag,darkgray, darkgray, '' );
 SourisVisible;
end;



{============================================================================}
{                          Corps du programme
{============================================================================}

BEGIN

if ParamCount <>1
  then begin
  writeln('Prcisez COM1 ou COM2 ...');
  writeln('Ex : TESTIO COM2');
  halt;
  end
  else begin
  NCOM := ParamStr(1);
  if (NCOM='COM2') then VCOM := COM2
    else if (NCOM='COM1') then VCOM := COM1
      else begin
      writeln('Nom de port srie invalide ( COM1 ou COM2 )');
      halt;
      end;
  end;

if not(DetecteSouris) then
 begin
 writeln('Souris non dtecte...');
 halt;
 end;

InitCOM( VCOM , 1200 , SansParite , 8 , 1 ); { utilisation du port srie 2  }

EtatSortiesLogiques := 0;
EtatEntreesLogiques := 0;
EcranGraphique;
SourisInvisible;
DessineBurreau(0);
DessineBurreau(1);
DessineBarreOutils;
SourisVisible;
SourisVisible;
FinProgramme := false;

{ dsactive toutes les sorties par dfaut }
COMout(VCOM,ord('D'));                      { envoit commande 'DG'   }
COMout(VCOM,ord('G'));
car := COMin(VCOM);
if ( TimeOut or (car<>ord('O'))) then MauvaiseLiaison;
Repeat
 AttendActionSouris;
 ClickBarreOutils;
 case NumBoutonBarreOutils of
  0..7 : begin;
         COMout(VCOM,ord('C'));                      { envoit commande 'C'   }
         COMout(VCOM,ord('1')+NumBoutonBarreOutils); { suivie du N de sortie}
         car := COMin(VCOM);
         if  (car<>ord('O')) or TimeOut
             then MauvaiseLiaison
             else begin
                  EtatSortiesLogiques :=
                    EtatSortiesLogiques xor MasqueBit[NumBoutonBarreOutils+1];
                  DessineBurreau(1);
                  end;
         end;
   8 : begin;
       end;

   9 : begin
       COMout(VCOM,ord('L'));                      { envoit commande 'LG'   }
       COMout(VCOM,ord('G'));
       car := COMin(VCOM);
       if TimeOut then MauvaiseLiaison;
       if (car>=$30)and(car<=$39)
                      then EtatEntreesLogiques := (car-$30)*16
                      else EtatEntreesLogiques := (car-ord('A')+10)*16;
       car := COMin(VCOM);
       if TimeOut then MauvaiseLiaison;
       if (car>=$30)and(car<=$39)
         then EtatEntreesLogiques := EtatEntreesLogiques or (car-$30)
         else EtatEntreesLogiques := EtatEntreesLogiques or (car-ord('A')+10);
       DessineBurreau(2);
       end;

  10 : begin
       COMout(VCOM,ord('V'));                      { envoit commande 'V1'   }
       COMout(VCOM,ord('1'));

       car := COMin(VCOM);
       if TimeOut then MauvaiseLiaison;
       if (car>=$30)and(car<=$39)
                      then ValeurCanal1 := (car-$30)*16
                      else ValeurCanal1 := (car-ord('A')+10)*16;
       car := COMin(VCOM);
       if TimeOut then MauvaiseLiaison;
       if (car>=$30)and(car<=$39)
         then ValeurCanal1 := ValeurCanal1 + (car-$30)
         else ValeurCanal1 := ValeurCanal1 + (car-ord('A')+10);
       DessineBurreau(3);
       end;

  11 : begin
       COMout(VCOM,ord('V'));                      { envoit commande 'V2'   }
       COMout(VCOM,ord('2'));
       car := COMin(VCOM);
       if TimeOut then MauvaiseLiaison;
       if (car>=$30)and(car<=$39)
                      then ValeurCanal2 := (car-$30)*16
                      else ValeurCanal2 := (car-ord('A')+10)*16;
       car := COMin(VCOM);
       if TimeOut then MauvaiseLiaison;
       if (car>=$30)and(car<=$39)
         then ValeurCanal2 := ValeurCanal2 + (car-$30)
         else ValeurCanal2 := ValeurCanal2 + (car-ord('A')+10);
       DessineBurreau(4);
       end;

  12 : begin
       end;
  13 : begin
       end;
  14 : begin
       { Demande  l'interface srie si celui-ci est prt }
       COMout(VCOM,ord('R'));                      { envoit commande 'R'   }
       car := COMin(VCOM);
       if (car<>ord('O')) or TimeOut then MauvaiseLiaison;
       end;
  15 : FinProgramme := true;
 end;

until FinProgramme;
EcranTexte;
END.