ࡱ                >  	               K          M          J    I                 U1   bjbj                   N    U-                                                                 ]                                                                                              T          7      J      J      J      J      J      J      J      J                                           $   -!    !#     "                             J                      J      J      J      J      "                           J              J      J                        J  :         J             J                                                                      J              D              B                                                                                 J      .     Ύd{                                                                                                                                                               
;**************************************************************************
;                           Assembly directives                          ;**************************************************************************

.title "CALCULATOR" 

.vers "ST6230" 
      .romsize 2
      .w_on 
.pp_on



;**************************************************************************
;                             Data registers                                
;**************************************************************************

      .input "st623x.def"

;**************************************************************************
;                               data ram                                   ;**************************************************************************

kdep_cnt .def 84h                 ; The depressed key counter is increased
                                  ; in the timer interrupt routine.
krel_cnt .def 85h                 ; The realesed key counter is increased 
                                  ; in the timer interrupt routine.
key_val  .def 86h                 ; Saves the depressed key if it is 
                                  ; present for more than 40 ms.
key_sav  .def 87h                 ; Saves the value of a depressed key in
; order to compare that the keypad entry
; is always the same during the keypad
                                  ; processing time.
overflow .def 88h                 ; Saves the carry of each operation.
result   .def 89h                 ; Saves the result of each operation.
                                  ; addition.
addr_r   .def 8ah                 ; Saves the byte address of the
                                  ; resultant.
addr_a   .def 8bh                 ; Saves the byte address of number A.
byte_num .def 8ch                 ; The byte number has to be shifted, the
                                  ; byte number has to be added and the 
                                  ; byte number has to be multiplied.
pointa   .def 8dh                 ; The decimal point position of the
                                  ; number A.
pointb   .def 8eh                 ; The decimal point position of the
                                  ; number B.
pointr   .def 8fh                 ; The decimal point position of the 
                                  ; resultant addition.
key_flag .def 90h


;**************************************************************************
k_dep    .equ   0                 ; Indicates that a key has been depressed
                                  ; during the keypad scanning.
k_sav    .equ   1                 ; Indicates that a depressed key has been
                                  ; saved in key_sav register.
k_on     .equ   2                 ; Allows to process a key.

rg_keypr .def 91h                 ; key code after  key processing routine.
save_a   .def 92h                 ; Save the accumulator in interrupt
                                  ; routine.

ope_flag .def 93h

;**************************************************************************
mult_val .equ   1                 ; Set if the result of the multiplication
                                  ; is valided.
k_fnd    .equ   2                 ; Set when the key processing routine   				 	    ; find the key code.

buf0     .def 0a0h                ;\
buf1     .def 0a1h                ; |
buf2     .def 0a2h                ; | number A
buf3     .def 0a3h                ; |
buf4     .def 0a4h                ;/

buf5     .def 0a5h                ;\
buf6     .def 0a6h                ; |
buf7     .def 0a7h                ; | number B
buf8     .def 0a8h                ; |
buf9     .def 0a9h                ;/

; 6 bytes for the resultant addition ( from 0aah to 0afh )
; 16 bytes for the resultant multiplication ( from 0aah to 0b9h )

;**************************************************************************
;                            constants definition                           ;**************************************************************************

lsb_a    .equ 0a0h                ; The least significant byte address of 
                                  ; the number A.
msb_a    .equ 0a4h                ; The most significant byte address of 
                                  ; the number A. 
lsb_b    .equ 0a5h                ; The least significant byte address of 
                                  ; the number B.
msb_b    .equ 0a9h                ; The most significant byte address of 
                                  ; the number B.
lsb_r    .equ 0aah                ; The least significant byte address of 
                                  ; the resultant addition.
msb_r    .equ 0bah                ; The most significant byte address of 
     ; the resultant multiplication.
pointr0  .equ 0b1h                ; The decimal point address of the 
                                  ; resultant multiplication.
tempo_40 .equ 04h                 ; The value of tempo_40 is equal to 40 ms
                                  ; divided by the interrupt time base.
tempo_60 .equ 06h                 ; The value of tempo_60 is equal to 60 ms
                                  ; divided by the interrupt time base.

; bits timer1

tmz      .equ 7                   ; This bit must be cleared by user 
                                  ; software before to start
                                  ; with a new count.

;**************************************************************************
; 					data rom                                    ;**************************************************************************

; The effective address of the byte to be read as a data in the ROM memory  
; is obtained by the concatenation of the 6 less significant bits of the
; address in the data space and the content of the DRWR register.           
;**************************************************************************

     .block  64-$%64          ; Force page boundary.

key_tab	 .byte 0eeh       ; 0
.byte 0deh              ; 1
     .byte 0beh               ; 2
     .byte 07eh               ; 3
     .byte 0edh               ; 4
     .byte 0ddh               ; 5
     .byte 0bdh               ; 6
     .byte 07dh               ; 7
     .byte 0ebh               ; 8
     .byte 0dbh               ; 9
     .byte 0b7h               ; +
     .byte 077h               ; x
     .byte 0e7h               ; RAZ
     .byte 0d7h               ; .

;**************************************************************************;                           PROGRAM SPACE ;**************************************************************************
;                            main program                                  ;**************************************************************************

                        .section 1   ;This directive provides a logical
                                     ;partionning of the program space 

reset        ldi DWDR,0feh               ; Load the watchdog.
             ldi DDRA,00001111b 
             ldi ORA,00000000b
             ldi DRA,00001111b  
	       ldi x,084h
inram        clr a                    ;\ 
	 	 ld (x),a                 ; |
	 	 inc x                    ; | Clear ram from 084h to 0bfh.
	 	 ld a,x                   ; |
	 	 cpi a,0c0h               ; |
	 	 jrc inram                ;/
	 	 ldi DWR,key_tab.w        ; The data rom window register is				  		        ; initialized by the notation 
                                      ; key_tab.w.
	 	 ldi IOR,00010000b        ; Enable the interrupts.
       	 reti

	 	 ldi DWDR,0feh            ; Load the watchdog.
	 	 ldi TCR1,11010000b       ; 12 x 16 x (0d0h) x 1/4 Mhz = 10 ms
	 	 ldi TSCR1,01101100b      ; Start the timer. 

cal0         ldi buf0,00h             ;\
	 	 ldi buf1,01h             ; |
		 ldi buf2,05h             ; | number A = 24,510
		 ldi buf3,04h             ; |
		 ldi buf4,02h             ; |
		 ldi pointa,03h           ;/
   	 
             ldi buf5,01h             ;\
       	 ldi buf6,03h             ; |
       	 ldi buf7,06h             ; | number B = 926,31
       	 ldi buf8,02h             ; |
       	 ldi buf9,09h             ; |
       	 ldi pointb,02h           ;/

cal1         wait                     ; Wait for interrupt.
       	 ld a,key_val             ; Read the key.
       	 jrz cal1                 ; Key ?
       	 call keypr               ; Key processing routine.
       	 jrr k_fnd,ope_flag,cal1  ; Test if the key processing routine 
                                      ; find the key code.
       	 ld a,rg_keypr
       	 cpi a,0ah                ; Key " + " ?
       	 jrnz cal2
       	 call additn              ; Call the addition subroutine. 
	 	 jp cal0
cal2         cpi a,0bh                ; Key " x " ?
       	 jrz cal3
       	 jp cal1
cal3         call multicn             ; Call the multiplication subroutine.
	 	 jp cal0

;**************************************************************************
;                              subroutines                                  ;**************************************************************************

; The .INPUT directive causes the source statememt(s) to be read from the 
; specified file. 

	 	 .input "scan_key.asm"
       	 .input "additn.asm"
       	 .input "multipl1.asm"

;**************************************************************************
;                             key processing                                
;**************************************************************************

keypr    ldi y,key_tab.d          ; Load the first address of the key
                                  ; table.
         ldi rg_keypr,00h         ; Initialize rg_keypr.
keypr1   ld a,key_val
         cp a,(y)
         jrz keypr2               ; Test if the key is found.
         inc rg_keypr             ; Increase rg_keypr.
         inc y                    ; Increase key table address.
         ldi a,0eh                ; 14 bytes in key table.
         addi a,key_tab.d
         cp a,y                   ; Test the end of key table.
         jrnz keypr1
         res k_fnd,ope_flag
         jp keypr3
keypr2   set k_fnd,ope_flag
keypr3   clr key_val
         ret




;**************************************************************************
;                         interrupt routines                                ;**************************************************************************

;**************************************************************************
;                          timer interrupt                                  ;**************************************************************************

it_timer ldi DWDR,0feh    ; Reload the watchdog.
         ldi TCR1,11010000b; reload the counter.
         res tmz,TSCR1     ; Restart the timer.
         inc kdep_cnt     ; Increase depressed key counter.
         inc krel_cnt     ; Increase released key counter.
         ld save_a,a      ; Save the accumulator.
         call scan_key    ; Call the scanning keypad subroutine.
         ld a,save_a      ; Restore the accumulator.
         reti

;**************************************************************************;                    interrupt and restart vectors                          
;************************************************************************** 
	 .section 32

int4     nop
	   reti
int3     jp it_timer
int2     nop
         reti
int1     nop
         reti
         nop
         nop
         nop
         nop
nmi      nop
         reti
res      jp reset

                                                                                                                                                                              U1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              M          	    '  .  /  0  1  }        1  2  ~      a      4  z                                                                                                                                                                                                                                                                                                                                                                   M          	    '  .  /  0  1  }        1  2  ~      a      4  z    	  .	  U	  	  	  
  G
  
  
    L      "  P      
  D
  V
  W
  X
  
  
  0  |        E              e        $  J  y            ?  e          	  U      9  k      3  e      ,  h        [      dz    	  .	  U	  	  	  
  G
  
  
    L      "  P      
  D
  V
  W
  X
  
  
  0  |                                                                                                                                                                                                                                                                                                                                                                    +
         E              e        $  J  y            ?  e          	  U                                                                                                                                                                                                                                                                                                                                                                          U      9  k      3  e      ,  h        [      ;              M  N                                                                                                                                                                                                                                                                                                                                                                       [      ;              M  N        g      I  J                 B  d            2  T  U          >  ?  }             <   z            I!  |!  !  !  !  !  5"  f"  g"  "  "  "  #  ##  B#  H#  q#  #  #  #  $  @$  A$  }$  $  $  %  ]%  %  %  %  %  5&  A&  u&  &  &  &  &  &  ='  '  '  !(  4(  5(  O(      d      g      I  J                 B  d            2  T  U          >                                                                                                                                                                                                                                                                                                                                                                    >  ?  }             <   z            I!  |!  !  !  !  !  5"  f"  g"  "  "  "  #  ##  B#  H#  q#                                                                                                                                                                                                                                                                                                                                                                          q#  #  #  #  $  @$  A$  }$  $  $  %  ]%  %  %  %  %  5&  A&  u&  &  &  &  &  &  ='  '  '  !(  4(  5(                                                                                                                                                                                                                                                                                                                                                                          5(  O(  l(  (  (  (  %)  q)  r)  )  )  *  3*  E*  *  *  *  5+  O+  +  +  +  +  +  ,  ,  ,  ,  ,  ,                                                                                                                                                                                                                                                                                                                                                                          O(  l(  (  (  (  %)  q)  r)  )  )  *  3*  E*  *  *  *  5+  O+  +  +  +  +  +  ,  ,  ,  ,  ,  ,  `,  ,  ,  E-  -  -  .  @.  p.  .  .  /  Z/  /  /  /  60  0  0  0  0  0  0  0  0  0  0   1  
1  1  '1  41  B1  T1  U1                                                                                                                                                                                                ?,  `,  ,  ,  E-  -  -  .  @.  p.  .  .  /  Z/  /  /  /  60  0  0  0  0  0  0  0  0  0  0   1  
1                                                                                                                                                                                                                                                                                                                                                                          
1  1  '1  41  B1  T1  U1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             . A!"#$%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
  [         $  @ $    N o r m a l       mH                  2 A@ 2    P o l i c e   p a r   d  f a u t             0 Z`  0   
 T e x t e   b r u t      OJ QJ     U-    N       U1        z    U    >  q#  5(  ,  
1  U1                  !   "   #   %   &      [  O(  U1        $       i   q             !  %  (  -                 #  :  =  >  G  H  K  L  S  T  V  W  `                                                       !  *  4  ;  >  A  X  ]  ^  a  b  k  l  o  s  u  v  x                                      
             !  '  (  -  0  2  3  9  :  =  >  B  C  I  J  M  N  T  y                                                	  
      G  M  Q  T  k  p  q  t  u  y  z                                          	      %  (  )  -  .  4  5  8  9  ;  <  >  ?  F  H  K  p  t  u  {  |                                                      
       F  L  P  V  Z  ]  t  w  x                            	  
	  0	  9	  D	  L	  N	  Q	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  
  
  
  
  
  %
  &
  .
  0
  5
  :
  =
  T
  ]
  ^
  b
  e
  n
  o
  r
  s
  v
  w
  {
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
             &  +  -  0  1  ;  E  K  O  R  i  m  n  q  r  }                !  #  &  D  G  H  N  R  U                                              	
  
  .
  1
  T
  W
  p
  v
  
  
  
  
  
  
  
  
      6  <  I  L  o  r                                           |                      '  (  ,  -  4  ]  `  a  g  k  p  u  x                                                !  "  &  '  .  W  Z  [  a  e  j  o  r                                          	               '  P  S  T  ]  h  m  r  u                                          
        A  J  e  h                                          )  +  ,  1  2  4  _  f  g  i  j  m  n  w                              
        ;  ?  B  E  F  K          *  1  5  8  9  =  >  @  A  C  D  H  V  Y  ^  d  i  k  l  t  u  w  x  {  |                                            u  }                          &  *  H  L  j  n                      8  <  8  ?                '  +  .  /  6  7  <  ?  D  L  O  j  n  o  r  s  {                            !  @  C  ]  b  c  f  g  k  q  s  ~                                                ,  7  8  :  ;  >  q  z                                          )  ,  9  <  T  Y  Z  ]  ^  c  t  w                    	  &  )  U  X  z  }                   $   '   N   R   i   m   r   {                                                             !  !  !  !  !!  A!  D!  E!  H!  I!  S!  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !   "  "  "  "  "  "  ("  2"  9"  ;"  N"  Q"  i"  l"  ~"  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  \#  g#  #  #  #  #  #  $  $  $  $  $  $  $  $  $  $  $  #$  ,$  A$  M$  `$  j$  $  $  $  %  r%  w%  {%  ~%  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  &  &  &  &  &&  (&  )&  2&  <&  >&  N&  Q&  q&  t&  u&  x&  y&  {&  |&  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  '  '  !'  &'  *'  -'  >'  B'  C'  N'  X'  Z'  ['  ^'  x'  {'  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  (  (  (  z(  (  `)  e)  f)  o)  )  )  )  )  )   *  *  *  *  
*  *  *  ,*  2*  3*  6*  7*  >*  I*  L*  ]*  d*  e*  h*  i*  n*  y*  |*  }*  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  +  +  +  +  +  +  "+  &+  '+  /+  5+  9+  :+  =+  >+  F+  G+  M+  N+  X+  c+  e+  f+  n+  v+  }+  ~+  +  +  +  +  +  +  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  	-  -  -  -  #-  &-  '-  *-  0-  3-  =-  A-  B-  E-  K-  M-  N-  S-  W-                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               B A T M A N  D : \ D u n o d \ c a l c u l . a s m . d o c  Wof                 1F                 D!n?                 1                 
vS\                 ;URȓ                 e[#                 bt[                                          h ho(  -                          h ho(  -                         h ho(  -                          h ho(  -                          h ho(  -                          h ho(  -                          h ho(  -                         h ho(  -    D!            Wo            ;U            1F            b            1            
vS            e[                               @ T-  T-  M   T-      T-             U-  P   @     G                        T i m e s   N e w   R o m a n   5                       S y m b o l   3&                        A r i a l   ?5  	                      C o u r i e r   N e w   "  q        XZFYZF          a%       O                      $                                                                                                                                                                                                                                                                                                                               0              -                                                                              K ; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *        B A T M A N  B A T M A N                                                   Oh +'0                                                 	   0     <  
   X     d  
   p     |                         L   ;**************************************************************************        ***      BATMAN *       ATM      Normal.dot *      BATMAN d      1 TM      Microsoft Word 8.0 *@    F#    @    P@){@    M{              a%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ՜. +,D   ՜. +,  L        h      p                                                   
         ,             Dell Computer Corporation *    O            -     
                                  L   ;**************************************************************************            Titre                          6      >         
   _PID_GUID      A   N   { 0 3 D B C E 8 0 - 5 A 7 7 - 1 1 D 1 - B 6 D 9 - 9 7 7 7 3 B 9 E 8 B 1 0 }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       	   
         
                                                             !   "   #   $   %   &   '   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   ;   <   =   >   ?   @   A   C   D   E   F   G   H   I   L   R o o t   E n t r y                            ȢC     	           F    Ed{d{N         1 T a b l e    
 C  @       C C O¿  C C             HC                   (   #    W o r d D o c u m e n t                          U  C                                             N       S u m m a r y I n f o r m a t i o n             
        (                                    :           D o c u m e n t S u m m a r y I n f o r m a t i o n           8                                B          C o m p O b j                                                                                j   < @ 
  
    o    _?6  
         @,       
                  ,       
                 
      C ,       
     t            
      C ,       
     ]          C ,       
     >      U      
      C     
  	           F   Document Microsoft Word 
   MSWordDoc    Word.Document.8 9q                                                                                                                                                                                                                                                                                                                                                                                                                                  