ࡱ                >  	                                          I                 7   bjbj                   f    2                                                                 ]                                                                                                        "                                                     "     "      "      "      "      "      "  $   #    %  B   "  -                                                                        "                                                                                                    "                                                                      "        @         T     !                                                                           "            b  ,   S^z                    r"                                                                                                                                           
.W_ON ;	

;************************** REGISTER DECLARATION *************************

X 		.def 080h!M 	; Index register.
Y 		.def 081h 	; Index register. 
V	 	.def 082h 	; Short direct register.
W 		.def 083h 	; Short direct register.

A		.def 0ffh!M 	; Accumulator.

DRD 		.def 0C3h 	; Port d data register.
DDRD 		.def 0C7h 	; Port d direction register.
ORD 		.def 0CFh 	; Port d option register.	

IOR 		.def 0C8h 	; Interrupt option register.	
DRWR 		.def 0C9h!M 	; Data rom window register.

ADR 		.def 0D0h!M 	; A/D result register.
ADCR 		.def 0D1h 	; A/D control register.
TPSC 		.def 0D2h 	; Timer 1 prescaler register.
TCR 		.def 0D3h 	; Timer 1 counter register.
TSCR 		.def 0D4h 	; Timer 1 status control register.

WDR 		.def 0D8h 	; Watchdog register.

;*********************** DATA RAM REGISTERS ******************************

VALR 		.def 099h!M 	; motor current register 
LOOP 		.def 087h 	; counter
DX 		.def 088h 	; back up of X 
DY 		.def 089h 	; back up of Y 	
DXb 		.def 08Ah 	; back up of X 
DYb 		.def 08bh 	; back up of Y
FLIT 		.def 08ch 	; motor control flag register 
;b0 indicates 0 crossing pulse 
; b2 indicates timer operation on triac triggering 
; b3 indicates line polarity versus Vdd 
; b4 indicates timer operation on current sensing delay 
; b7 indicates timer operation 
; b1, b5, b6 are unused here 
DVALR 	.def 08eh 	; previous VALR register value
COMPT 	.def 08dh 	; soft start counter 
DPRB 		.def 08fh 	; back up of port B data register
INDEX 		.def 091h 	; motor current compensation register 
ADCcou 	.def 092h 	; torque limitation register 
ADCcou1 	.def 093h 


ADCvit 		.def 094h!M 	; speed reference register 
ADCvit1 	.def 095h 
DA 		.def 096h 	; back up of A 
DAb 		.def 097h 	; back up of A

;*********************** EQUATE DEFINITION *******************************

OFSET 	.equ 008h 	; offset subtracted from motor current 
; in current compensation calculation 
OFSET1 	.equ 007h 	; offset subtracted from motor current 	
; in measure delay time calculation 
TGATE 	.equ 008h 	; triac gate pulse duration 08h=385us 
TDTIM 		.equ 053h 	; time limit to define priority between 
; timer & potentiometers subroutines 
TDMIN 		.equ 008h 	; minimum trig. delay time 08h=385us
TDMAX 	.equ 09ch 	; maximum trig. delay time 9ch=9.0 ms 
START 	.equ 002h 	; step of soft start operation

;******************* BEGINNING OF PROGRAM AREA *********************

.org 0800h 

;*********************************************************************************** 
;*                              SPEED REFERENCE TABLE                               * 
;***********************************************************************************

VITT 		.BYTE 		86H,84h,82H,80H,7eH,7cH,7aH,78H 
.BYTE		76H,74h,72H,70H,6eH,6cH,6aH,68H 
.BYTE 		66H,64h,62H,60H,5eH,5cH,5aH,59H 
.BYTE 		58h,57H,56H,55H,54H,53H,52H,51H 
.BYTE 		4fH,4dH,4bH,49H,47H,45H,43H,41H 
.BYTE 		3fH,3dH,3bH,39H,37H,35H,33H,31H 
.BYTE 		2fH,2dH,2bH,29H,27H,25H,23H,21H 
.BYTE 		1fH,1dH,1bH,19H,17H,15H,13H,11H

;************************************************************************************
;*                        CURRENT COMPENSATION TABLE                           * ;************************************************************************************

COUPLE 	.BYTE 		00H,01H,01h,02H,03H,04H,04H,05H
.BYTE 		06H,07H,07H,08H,09H,0ah,0aH,0bH 
.BYTE 		0cH,0dH,0dh,0eH,0fH,10H,10H,11H 
.BYTE 		12H,13H,13H,14H,15H,16H,16H,17H
.BYTE 		18H,19H,19h,1aH,1bH,1cH,1dH,1eH 	
.BYTE 		1fH,20H,21H,22H,23H,24H,25H,26H 	
.BYTE 		27H,29H,2ah,2bH,2cH,2eH,2fH,30H 
.BYTE 		31H,33h,34H,35H,37H,38H,3bH,3eH

;************************************************************************************
;*                       PEAK CURRENT INSTANT TIME TABLE                     * ;************************************************************************************

RTMES 	.BYTE 		0aH,0ah,10H,10H,10H,11H,11H,11H 
.BYTE 		12H,12H,12H,13H,13H,13H,14H,14H 
.BYTE 		14H,14H,14H,15H,15H,15H,15H,15H 
.BYTE 		16H,16H,16H,16H,16H,17H,17H,17H                                                                            
 . B Y T E   	 	 1 7 H , 1 7 H , 1 7 H , 1 8 H , 1 8 H , 1 8 H , 1 8 H , 1 8 H   
 . B Y T E   	 	 1 8 H , 1 9 H , 1 9 H , 1 9 H , 1 9 h , 1 9 H , 1 a H , 1 a H   
 . B Y T E   	 	 1 a H , 1 a H , 1 b H , 1 b h , 1 b H , 1 c H , 1 c H , 1 c H   
 . B Y T E   	 	 1 d H , 1 d H , 1 e H , 1 e H , 1 f H , 2 0 H , 2 0 H , 2 1 H 
 
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *   
 ; * 	 		    INITIALIZATION                                             * ;************************************************************************************


start 		ldi WDR,0feh 		; watchdog initialization
ldi X,084h 
raz		clr A 			; clear the RAM 
ld (X),A 
inc X 
ld A,X 
cpi A,0d5h 
jrc raz

INIT 		ldi DRD, 0efh 		; PD1/2/3 in push pull output connected at Vdd
ldi DDRD, 00fh 		; PD4 in interrupt input, PD5 in analog input
ldi ORD, 03fh		; PB6/7 in HI input

ldi ADR,00h 		; A/D conv. initialization 
ldi ADCR,00h 		; ADC is stopped

ldi FLIT, 00h 		; clear logic and application registers 
ldi COMPT, 0ah 	
ldi INDEX, 00h 
ldi VALR, 00h 
ldi DVALR, 00h 
ldi ADCvit, 09fh 
ldi IOR,10h 		; interrupt validation: PB0 interrupt on falling edge 
reti 

;*************************************************************************************
;*                                           MAIN PROGRAM                                        * ;*************************************************************************************

;****************************** SOFT START TASK ******************************

SOFT1	jrr 0,FLIT,SOFT1 	; wait 0 crossing ( # 1 ) 
res 0,FLIT 
call VIT 
ldi A,TDMAX ; 
ld A,ADCvit 		; ENABLE THIS INSTRUCTION TO INHIBIT
; THE SOFT START 
SOFT2		jrr 0,FLIT,SOFT2 	; wait 0 crossing ( # 2,.., n-1 ) 
res 0,FLIT 		; reset b0 of FLIT 
ld TCR,A 		; load timer register 
ldi TSCR,01111100b 	; start timer with interrupt & PSC = 16 
set 7,FLIT 		; control timer cycle with b7 indicator ATINI 
jrs 7,FLIT,ATINI 	; wait end of timer operation 
subi A, START 
cp A, ADCvit 
jrnc SOFT3 
jp SOFT4 
SOFT3		jp SOFT2 
SOFT4 	ld A, ADCvit




;************************* MAIN MOTOR CONTROL PROGRAM ****************************

MAIN 		jrr 0,FLIT,MAIN 	; wait 0 crossing ( # n ) 
res 0,FLIT

MAIN1 		ldi DRWR,COUPLE.W 	; define motor current compensation 
ld A, VALR 		; A <= VALR motor current measure 
subi A, OFSET 		; A <= VALR  OFSET
jrnc MAIN4 
clr A

MAIN4 		cpi A, 040h 		; check VALR to max. value 
jrc MAIN3 
ldi A, 03fh 		; limit VALR to its max. value

MAIN3 		addi A, 040h 
ld X, A 			; load VALR@ in X register MAIN2 
ld A, (X) 		; calculate current compensation data

; ************************ TORQUE LIMITATION TASK ***************************************

jp MAINc 		; ENABLE THIS INSTRUCTION TO STOP 
; TORQUE LIMITATION 
cp A, ADCcou 
jrc MAINc 
ld A, ADCcou 		; limit to the max. requested torque

; *************************** SPEED CONTROL TASK *****************************************

MAINc 		ld INDEX,A
ldi INDEX,00h 		; ENABLE THIS INSTRUCTION TO INHIBIT 
; CURRENT COMPENSATION

MAIN5a 	ld A, ADCvit 		; load speed reference 
sub A, INDEX 		; substrate current comp. to speed ref. 
jrnc MAIN5 
ldi A, TDMIN 		; limit trig. delay time to min. value

; ************************ PHASE ANGLE CONTROL TASK ***********************************

MAIN5 		ld TCR,A 		; load timer for triac triggering delay 
ldi TSCR,01111100b 	; start timer with interrupt & PSC = 16 
set 7,FLIT 		; b7 <= 1, b7 indicates timer operation

; ******************************** DELAY TIME CONTROL ***************************************

cpi A, TDTIM 	; if Tdelay > TDMIN, 
jrc MAINm 		; then read references before triggering

; **************** SPEED REFERENCE & TORQUE LIMIT TASK ****************************

jrr 3,FLIT,ATfin 	; read potentiometer when Vac is > 0 
call VIT 		; read speed ref. & torque lim. 

ATfin 		jrs 7,FLIT,ATfin 	; wait end of timer operation 
JP MAIN


MAINm 	jrs 7,FLIT,MAINm 	; wait end of timer operation 
jrr 3,FLIT,FIN 		; read potentiometer when Vac is > 0 
call VIT 		; read speed ref. & torque lim. FIN 
jp MAIN

;**************************************************************************************************** 
;*                                      PROGRAM SUBROUTINES                                                * 
;****************************************************************************************************

;********************** CURRENT MEASUREMENT SUBROUTINE *************************

ADC 		ldi DRD, 0efh 		; PD5 in analog input
ldi DDRD, 00fh 		
ldi ORD, 03fh		
ldi ADCR, 30h 		; start conversion 

ADC1 		jrr 6,ADCR,ADC1 	; wait end of conversion 
ld A, ADR 		; A <= ADR 
com A 			; complement A/D result to obtain 
; current measure referred to Vss 
ADC2		ld VALR, A 		; update motor current measure in VALR 
ret

;***** SPEED REFERENCE & TORQUE LIMITATION MEASURE SUBROUTINE ******

; ********************* SPEED REFERENCE MEASUREMENT TASK **********************

VIT 		ldi DRD, 0efh 		; PD6 input connected on A/D converter
ldi DDRD, 00fh 		
ldi ORD, 05fh		
ldi ADCR, 30h 		; A/D conversion start 

VITadc 		jrr 6,ADCR,VITadc 	; wait at end of conversion 
ld A, ADR 	
ld ADCvit, A 
ldi X, ADCvit 
ldi ADCvit1,00h 
call DIV4
ldi DRWR,VITT.W 	; convert measured value in 
ld A, ADCvit1 		; triac triggering delay time 
addi A, 40h 
ld X, A 
ld A, (X)
ld ADCvit,A

; ******************* TORQUE REFERENCE MEASUREMENT TASK ************************

COU 		ldi DRD, 0efh 		; PD7 input connected on A/D converter
ldi DDRD, 00fh 		
ldi ORD, 09fh		
ldi ADCR, 30h 	; A/D conversion start 

COU1 	jrr 6,ADCR, COU1 	; wait at end of conversion 
ld A, ADR 
ld ADCcou, A 
ldi X, ADCcou 
ldi ADCcou1,00h 
call DIV4

ldi DRWR,COUPLE.W 	; convert measured value in 
ld A, ADCcou1 		; triac triggering delay time 
addi A, 40h 
ld X, A 
ld A, (X) 
ld ADCcou,A

FVIT		ldi DRD, 0efh 	
ldi DDRD, 00fh 		
ldi ORD, 05fh		

ret 

;************************** DIVISION BY 4 SUBROUTINE *****************************

DIV4 		ldi LOOP, 06h 

DIV42 		ld A,(x) 
sla A 
ld (X),A 	
inc X 	
ld A,(X) 
rlc A 
ld (X),A 
dec LOOP 
jrz DIV41 
dec X 
jp DIV42 

DIV41		ret

;************* REGISTER CONTEXT SAVING SUBROUTINE ************************

SR 		ld DA, A 	; A-->DA 
ld A, X 		; X-->A 
ld DX, A 	; A-->DX 
ld A, Y 		; Y-->A 
ld DY, A 	; A-->DY 
ret

;************* REGISTER CONTEXT RESTORING SUBROUTINE *********************

RSTR 		ld A,DX 	; DX-->A 
ld X,A 		; A-->X 
ld A,DY 	; DY-->A 
ld Y,A 		; A-->Y 
ld A,DA 	; DA-->A 
ret

;************* REGISTER CONTEXT SAVING SUBROUTINE ************************

SRb0 		ld DAb,A 	; A-->DAb 
ld A, X 		; X-->A 
ld DXb,A 	; A-->DX 
ld A, Y 		; Y-->A 
ld DYb,A 	; A-->DY 
ret

;************* REGISTER CONTEXT RESTORING SUBROUTINE *********************

RSTRb0 	ld A,DXb 	; DX-->A 
ld X,A 		; A-->X 
ld A,DYb 	; DY-->A 
ld Y,A 		; A-->Y 
ld A,DAb 	; DAb-->A 
ret

;****************** TIMER INTERRUPT SUBROUTINE ***************************

ITIM 		ldi TSCR,00h 		; stop the timer 
call SR 			; save context
jrs 2,FLIT,ITIM1 	; 2nd interrupt ? 
jrs 4,FLIT,ITIM2	; 3rd interrupt ?
set 2, FLIT 		; 1st interrupt ; b2 <= 1 
ldi DRD, 00h 		; TRIGGER THE TRIAC WITH BOOST 
nop 
ldi DRD, 01h 		; REDUCE GATE CURRENT and wait at triac 
; latching ( PA0 turns off ) 
ldi TCR, TGATE 	; load timer triac triggering 
ldi TSCR, 01111100b 	; start timer & PSC = 16 
jp FTIM

ITIM1 		res 2, FLIT 		; 2nd interrupt 
ldi DRD, 07h 		; STOP THE TRIAC GATE PULSE : pA to Vdd 
set 4, FLIT 		; prepare 3rd interrupt
ldi DRWR, RTMES.W 	; current measure delay time 
ld A, VALR
subi A, OFSET1 	; A <= VALR - OFSET1 
jrnc ITIM3 
clr A 

ITIM3 		cpi A, 040h 
jrc ITIM4 
ldi A, 03fh 

ITIM4		addi A, 040h 
ld X, A 
ld A, (X)
ld TCR, A 		; load timer with maesure. delay time 
ldi TSCR,01111100b 	; start timer & PSC = 16 
jp FTIM

ITIM2 		res 4, FLIT 		; 3rd interrupt 
jrs 3,FLIT,FTIM1 	; sense motor current when Vac < 0
ldi DRD, 0fh 		; pointer for current measure test 
call ADC 		; if negative, measure shunt voltage 
ldi DRD, 07h 		; end of pointer ( optional )

FTIM1 		res 7, FLIT 		; END OF TIMER OPERATION

FTIM 		call RSTR 		; restore context 
reti 

;****************** 0 CROSSING INTERRUPT SUBROUTINE **********************

IPB 		ldi WDR, 0feh 	; watchdog control 
call SRb0 	; save context 
jrr 3,FLIT,IPB1 	; test on line half cycle polarity
res 3, FLIT 	; negative half cycle operation 
ldi IOR, 30h 	; prepare rising edge interrupt 
jp IPB2

IPB1 		set 3, FLIT 	; positive half cycle operation 
ldi IOR, 10h 	; prepare falling edge interrupt

IPB2 		set 0, FLIT 	; 0 crossing indicator validation 
call RSTRb0 	; restore context 
reti

;************ UNUSED INTERRUPT ADDRESSES ********************

IADC 		reti
IPA 		reti 
IMNI 		reti

;************************** INTERRUPT VECTORS ************************************
.org 0ff0h

jp IADC 	; adc 
jp ITIM 		; timer 
jp IPB 		; port b and c 
jp IPA 		; port a

.org 0ffch

jp IMNI 		; non maskable interrupt vector 
jp start 		; reset interrupt vector 

;*********************************************************************************************

.eject 
.end

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             i  j           y/  z/  7  7                                                                                                                                                                                                                                                                                                                                                                                                                     OJ QJ h nHOJ QJ h nHOJ QJ h  
     
    V  W  z            
  6  e              F  v             K  L                                                                                                                                                                                                                                                                                                                                                                              
    V  W  z            
  6  e              F  v             K  L  z            I  i        	  =	  n	  	  	  
  5
  I
  J
  K
  }
  
  
  
  
      X          U  {      
  
  c
  d
  p
  q
  
    s  t          G  p                  B  j            f                                                                                                          dL  z            I  i        	  =	  n	  	  	  
  5
  I
  J
  K
  }
  
  
  
  
                                                                                                                                                                                                                                                                                                                                                                       O      X          U  {      
  
  c
  d
  p
  q
  
    s  t          G  p                                                                                                                                                                                                                                                                                                                                                                O                B  j            f      <  e      V      J  L                                                                                                                                                                                                                                                                                                                                                                                 <  e      V      J  L                        $  %  k              R  c  s              H      R  S              ,  M  o        (  6  B  L  ]  q  r  s  t  u            H  x                  0  ]            .  <  G  {  |        !   8   9   h                                                                                                         d                $  %  k              R  c  s              H                                                                                                                                                                                                                                                                                                                                                                             R  S              ,  M  o        (  6  B  L  ]  q  r  s  t  u                                                                                                                                                                                                                                                                                                                                                                   H  x                  0  ]            .  <  G  {  |        !                                                                                                                                                                                                                                                                                                                                                               !   8   9   h               ;!  <!  x!  !  !  !  I"  J"  n"  "  "  "  "  1#  ]#  ^#  #  #  #  #                                                                                                                                                                                                                                                                                                                                                                   ;!  <!  x!  !  !  !  I"  J"  n"  "  "  "  "  1#  ]#  ^#  #  #  #  #  #  $  @$  H$  I$  $  %  %  %  %  %  &  &  %&  I&  J&  |&  &  &  &  '  "'  #'  h'  i'  '  '  '  	(  (  A(  B(  {(  (  (  (  (  (  (  )  ))  2)  <)  H)  I)  )  )  )  )  )  !*  "*  W*  b*  p*  *  *  *  *  *  *  +  +  +  '+  (+  >+  P+  `+  a+  f+  g+  +  +  +  +  +                                                                                             d#  #  $  @$  H$  I$  $  %  %  %  %  %  &  &  %&  I&  J&  |&  &  &  &  '  "'  #'  h'  i'  '  '  '                                                                                                                                                                                                                                                                                                                                                              '  	(  (  A(  B(  {(  (  (  (  (  (  (  )  ))  2)  <)  H)  I)  )  )  )  )  )  !*  "*  W*  b*  p*                                                                                                                                                                                                                                                                                                                                                                p*  *  *  *  *  *  *  +  +  +  '+  (+  >+  P+  `+  a+  f+  g+  +  +  +  +  +  +  +  +  ,  ,  ,                                                                                                                                                                                                                                                                                                                                                             +  +  +  +  ,  ,  ,  #,  .,  5,  ?,  @,  K,  L,  ,  ,  ,  ,  ,  ,  ,  -  -  O-  P-  j-  |-  -  -  -  -  -  .  .  !.  4.  H.  [.  o.  s.  t.  .  .  .  .  /  /  )/  -/  ./  y/  z/  /  /  /  0  -0  \0  a0  0  0  0  1  1  1  E1  }1  1  1  1  2  2  2  2  .2  92  F2  G2  \2  e2  o2  2  2  2  2   3  53  h3  3  3  3  3  3  4  #4  $4  o4  p4  4  4  4                                                                                                       d,  #,  .,  5,  ?,  @,  K,  L,  ,  ,  ,  ,  ,  ,  ,  -  -  O-  P-  j-  |-  -  -  -  -  -  .  .  !.                                                                                                                                                                                                                                                                                                                                                                       !.  4.  H.  [.  o.  s.  t.  .  .  .  .  /  /  )/  -/  ./  y/  z/  /  /  /  0  -0  \0  a0  0  0  0                                                                                                                                                                                                                                                                                                                                                                 0  1  1  1  E1  }1  1  1  1  2  2  2  2  .2  92  F2  G2  \2  e2  o2  2  2  2  2   3  53  h3  3  3                                                                                                                                                                                                                                                                                                                                                                       3  3  3  3  4  #4  $4  o4  p4  4  4  4  5  E5  M5  N5  5  5  5  5  
6  6  6  N6  O6  [6  g6  s6  t6                                                                                                                                                                                                                                                                                                                                                                     4  5  E5  M5  N5  5  5  5  5  
6  6  6  N6  O6  [6  g6  s6  t6  6  6  6  6  6  7  !7  "7  -7  .7  Y7  ~7  7  7  7  7  7  7                                                                                                                                                                                                                                                                                                                                                                    #t6  6  6  6  6  6  7  !7  "7  -7  .7  Y7  ~7  7  7  7  7  7  7                                                                                                                                                                                                                                                                                                                                                                                                         . A!"#$%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
  [         $  @ $    N o r m a l       mH                  2 A@ 2    P o l i c e   p a r   d  f a u t             4 B`  4    C o r p s   d e   t e x t e      CJ     2    f       7        L            !   #  '  p*  ,  !.  0  3  t6  7         !   "   $   %   &   '   )   *   +   -   .   /   0   2           +  4  7     #   (   ,   1       \   _   p   x                                                
      ,  4  >  A  [  c  l  o                                              $  '  4  ;  <  D  N  Q  Z  _  b  k  l  t  }                                                T  W  b  g  h  o  p  x                                                                     #  ,  1  2  9  :  >  ?  G  M  V  Y  a  n  w  x  }  ~                                                      
          0  6  7  ;  E  H  Q  Y  _  g  v  y                                                
  
    +  3  ?  B  K  Q  U  X  c  h  i  r  s  {                                  &  )  9  C  D  H  I  N  O  V  ]  d  r  }                                                
  "  %  3  8  9  ;  <  B  C  K  L  S  W  \  _  m  n  y                               	  	  	  	  
	  	  	  	  e	  h	  P  U  X  [  i  q  r                                                               #  :  C  R  X  _  b                                            
      (  +  7  :  G  J  K  Q  Y  \  i  r                      "  &  )  1  ;  >  G  K  Q  T  `  b  c  k                                    "  $  '  :  ?  @  E  F  J  K  T  p  w  x  }                                            
        %                                            #  $  +  Q  U  ]  `  l  o                                        
         )  *  1                                  
              (                                       .  7  8  ?  @  D  F  H  I  N  O  R  U  Y  a  d  r  w  x  |  ~              
            %  &  +  -  0  C  H  I  N  O  S  T  ]                      #  &  '  ,  1  5  6  :  ;  E  F  L  M  W                                                      /  3  ;  @  A  J  V  [  ]  `  q  u  }                                                                                            !  	!  !  !  1!  3!  I!  L!  T!  ^!  c!  i!  j!  l!  m!  s!  w!  ~!  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  u"  x"  "  "  "  "  "  "  "  "  "  "  "  "  "  "   #  #  #  #  #  #  0#  2#  <#  >#  ?#  E#  J#  M#  Q#  W#  Y#  \#  j#  n#  t#  w#  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  V$  Y$  r$  {$  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  %  %  %  %  %   %  %%  (%  ,%  2%  4%  7%  E%  I%  P%  S%  e%  l%  m%  u%  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  &  &  &  &  w&  z&  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  R'  T'  f'  h'  y'  {'  '  '  '  '  '  '  (  (  (  !(  1(  3(  D(  F(  V(  X(  i(  l(  (  (  (  (  (  (  (  (  (  (  (  (  (  (  )  )  )  )  $)  ')  })  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  6*  9*  L*  O*  P*  U*  W*  [*  d*  h*  i*  p*  q*  t*  *  *  *  *  *  *  *  *  *  *  +  +  +  +  ?+  C+  D+  F+  G+  L+  P+  X+  _+  d+  l+  o+  ~+  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  ',  ),  *,  ,,  -,  0,  B,  I,  N,  W,  X,  [,  m,  t,  u,  |,  },  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  -  -  -  -  -  -  $-  &-  2-  6-  7-  <-  =-  A-  B-  I-  K-  P-  W-  Z-  m-  r-  s-  x-  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  .  .  .  .  .  !.  -.  5.  7.  >.  N.  Q.  p.  x.  .  .  .  .  .  .  .  .  .  .  +/  ./  </  D/  E/  L/  N/  R/  [/  _/  `/  g/  i/  l/  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  "0  &0  -0  60  80  ;0  H0  O0  P0  W0  X0  \0  ]0  f0  0  0  0  0  0  0  0  0  0  0  0  0  1  1  1  1  #1  '1  }1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  2  2  2  2  2  2  2  2   2  !2  *2  +2  12  2  2  2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 B A T M A N  D : \ D u n o d \ s e n s . a s m . d o c  Wof                 1F                 D!n?                 1                 
vS\                 ;URȓ                 e[#                 bt[                                          h ho(  -                          h ho(  -                         h ho(  -                          h ho(  -                          h ho(  -                          h ho(  -                          h ho(  -                         h ho(  -    D!            Wo            ;U            1F            b            1            
vS            e[                               @ 2  2  M   2      2      (           2  P   @  P      P  , @     G                        T i m e s   N e w   R o m a n   5                       S y m b o l   3&                        A r i a l   "  q        QZFRZF        S  )       Y                      $                                                                                                                                                                                                                                                                                                                               0              E3                                                                                       B A T M A N  B A T M A N                                                                                                     Oh +'0   T                                               	            
          
   (     4     <     D     L               s         s       BATMAN         ATM      Normal.dot        BATMAN d      1 TM      Microsoft Word 8.0  @    F#    @    f.z@    Rz         S     )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ՜. +,D   ՜. +,D           h      p                                                   
                       Dell Computer Corporation D    Y            E3     
                                                 Titre                         6      >         
   _PID_GUID      A   N   { F D 8 F F A C 0 - 5 A 7 5 - 1 1 D 1 - B 6 D 9 - 9 7 7 7 3 B 9 E 8 B 1 0 }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   H   I   J   K   L   M   N   P   Q   R   S   T   U   V   Y   R o o t   E n t r y                                                 	           F    ]z e[^z[          1 T a b l e                                                                                             4   %      W o r d D o c u m e n t                                                                                     f       S u m m a r y I n f o r m a t i o n                           (                                           G           D o c u m e n t S u m m a r y I n f o r m a t i o n           8                                     O           C o m p O b j                                                                                           j                                                                                                                                                                                                                                                   
  	           F   Document Microsoft Word 
   MSWordDoc    Word.Document.8 9q                                                                                                                                                                                                                                                                                                                                                                                                                                                         Oh +'0   T                                               	            
          
   (     4     <     D     L               s         s       BATMAN         ATM      Normal.dot        BATMAN d      2 TM      Microsoft Word 8.0  @    G    @    f.z@    83z         S     )                                                                                                                                                            ՜. +,D   ՜. +,D           h      p                                                   
                       Dell Computer Corporation D    Y            E3     
                                                 Titre                         6      >         
   _PID_GUID      A   N   { F D 8 F F A C 0 - 5 A 7 5 - 1 1 D 1 - B 6 D 9 - 9 7 7 7 3 B 9 E 8 B 1 0 }                                                     i  j           y/  z/  7  7   f                                                                                                                                                                                                                                                                                                                                                                                                                OJ QJ h nHOJ QJ h nHOJ QJ h   . A!"#$%  ;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
  [         $  @ $    N o r m a l       mH                  2 A@ 2    P o l i c e   p a r   d  f a u t             4 B@  4    C o r p s   d e   t e x t e      CJ     2    f                                                                   c     &  *  1  2    %                    #                   
      V   W   z                 
  6  e              F  v             K  L  z            I  i          =  n        5  I  J  K  }              X          U  {      	  	  c	  d	  p	  q	  	  
  s
  t
  
  
  
    G  p                
  B
  j
  
  
  
      f      <  e        	  2  Z  [    N  O  P                       _                (  7  G  Y                  ;  G  Q  `          $  a                &  '  (  )  *  }  ~          -  Q  ]  c  d              D  E              0  1                U  a          -  j          #  X  Y            L  T  U  V            e    9   :                        1!  I!  u!  !  !  !  !  "  "  n"  o"  "  "  "  "  "  0#  <#  J#  Y#  j#  t#  #  #  #  #  #  #  #  O$  P$  $  $  $  $  $  %  %  %%  4%  E%  O%  P%  %  %  %  %  %  %  %  %  &  &  &  &  &  o&  p&  &  &  &  &  &  &  &  &  &  &  &  &  &  &   '  '  L'  M'  f'  y'  '  '  '  '  '  (  (  (  1(  D(  V(  i(  m(  n(  (  (  (  (  (  )  $)  ()  ))  t)  u)  )  )  )  )  )  )  )  .*  /*  W*  q*  *  *  *  +  +  N+  l+  +  +  +  +  +  2,  X,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  -  -  $-  W-  -  -  -  -  -  .  N.  {.  |.  .  .  .  .  .  $/  %/  N/  i/  /  /  /  0  0  80  g0  h0  0  0  0  0  1  1  1  1  (1  )1  |1  1  1  1  1  1  1  1  1  1  2  32  42  2  2  2  2  2     p#      p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#      p#      p#      p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  _    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#      p#      p#      p#      p#      p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#      p#      p#      p#      p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#      p#      p#      p#      p#      p#      p#      p#      p#      p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#      p#      p#      p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#      p#      p#      p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#  v:    p#      p#      p#      p#  v:         [    2  2                                                                                                f        L            !   #  '  p*  ,  !.  0  3  t6  7         !   "   $   %   &   '   )   *   +   -   .   /   0   2           +  4  7     #   (   ,   1       \   _   p   x                                                
      ,  4  >  A  [  c  l  o                                              $  '  4  ;  <  D  N  Q  Z  _  b  k  l  t  }                                                T  W  b  g  h  o  p  x                                                                     #  ,  1  2  9  :  >  ?  G  M  V  Y  a  n  w  x  }  ~                                                      
          0  6  7  ;  E  H  Q  Y  _  g  v  y                                                
  
    +  3  ?  B  K  Q  U  X  c  h  i  r  s  {                                  &  )  9  C  D  H  I  N  O  V  ]  d  r  }                                                
  "  %  3  8  9  ;  <  B  C  K  L  S  W  \  _  m  n  y                               	  	  	  	  
	  	  	  	  e	  h	  [    P  U  X  [  i  q  r                                                               #  :  C  R  X  _  b                                            
      (  +  7  :  G  J  K  Q  Y  \  i  r                      "  &  )  1  ;  >  G  K  Q  T  `  b  c  k                                    "  $  '  :  ?  @  E  F  J  K  T  p  w  x  }                                            
        %                                            #  $  +  Q  U  ]  `  l  o                                        
         )  *  1                                  
              (                                       .  7  8  ?  @  D  F  H  I  N  O  R  U  Y  a  d  r  w  x  |  ~              
            %  &  +  -  0  C  H  I  N  O  S  T  ]                      #  &  '  ,  1  5  6  :  ;  E  F  L  M  W                                                      /  3  ;  @  A  J  V  [  ]  `  q  u  }                                                                                            !  	!  !  !  1!  3!  I!  L!  T!  ^!  c!  i!  j!  l!  m!  s!  w!  ~!  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  u"  x"  "  "  "  "  "  "  "  "  "  "  "  "  "  "   #  #  #  #  #  #  0#  2#  <#  >#  ?#  E#  J#  M#  Q#  W#  Y#  \#  j#  n#  t#  w#  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  V$  Y$  r$  {$  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  $  %  %  %  %  %   %  %%  (%  ,%  2%  4%  7%  E%  I%  P%  S%  e%  l%  m%  u%  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  %  &  &  &  &  w&  z&  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  &  R'  T'  f'  h'  y'  {'  '  '  '  '  '  '  (  (  (  !(  1(  3(  D(  F(  V(  X(  i(  l(  (  (  (  (  (  (  (  (  (  (  (  (  (  (  )  )  )  )  $)  ')  })  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  )  6*  9*  L*  O*  P*  U*  W*  [*  d*  h*  i*  p*  q*  t*  *  *  *  *  *  *  *  *  *  *  +  +  +  +  ?+  C+  D+  F+  G+  L+  P+  X+  _+  d+  l+  o+  ~+  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  +  ',  ),  *,  ,,  -,  0,  B,  I,  N,  W,  X,  [,  m,  t,  u,  |,  },  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  ,  -  -  -  -  -  -  $-  &-  2-  6-  7-  <-  =-  A-  B-  I-  K-  P-  W-  Z-  m-  r-  s-  x-  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  .  .  .  .  .  !.  -.  5.  7.  >.  N.  Q.  p.  x.  .  .  .  .  .  .  .  .  .  .  +/  ./  </  D/  E/  L/  N/  R/  [/  _/  `/  g/  i/  l/  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  /  "0  &0  -0  60  80  ;0  H0  O0  P0  W0  X0  \0  ]0  f0  0  0  0  0  0  0  0  0  0  0  0  0  1  1  1  1  #1  '1  }1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  2  2  2  2  2  2  2  2   2  !2  *2  +2  12  2  2  2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   B A T M A N  D : \ D u n o d \ s e n s . a s m . d o c  B A T M A N  A : \ s e n s . a s m  Wof                 1F                 D!n?                 1                 
vS\                 ;URȓ                 e[#                 bt[                                          h ho(  -                          h ho(  -                         h ho(  -                          h ho(  -                          h ho(  -                          h ho(  -                          h ho(  -                         h ho(  -    D!            Wo            ;U            1F            b            1            
vS            e[                               @ ]  ]  	 	 	 ]      ]      X         [  \  ]    2  2  0   @  0      1 f    1 L    0 P    0  , @  0 o @     G                        T i m e s   N e w   R o m a n   5                       S y m b o l   3&                        A r i a l   "  q        QZFTZF        S  )       Y                      $                                                                                                                                                                                                                                                                                                                               0              E3                                                                                     B A T M A N  B A T M A N                      I                7   bjbj                    h    2                                                                 ]                                                          z  4  6      6      6      6     B           ?                                                     ?      ?       ?       ?       ?       ?       ?  $   W@    KB  B   D?  ]                                                                        D?      ;                                              ;      ;      ;                                    ?                         T   &  T                                     ?      ;  f   ;      ;     d>                                                                           ?              ,   @z     6      ;      ?                                                                                                                                                             R o o t   E n t r y                                                 	           F    |z@z   @      1 T a b l e                                                                                                4   %      W o r d D o c u m e n t                                                                                     h       S u m m a r y I n f o r m a t i o n                           (                                           
                           	   
         
                                                ^          !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   _   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F      a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~          D o c u m e n t S u m m a r y I n f o r m a t i o n           8                                               C o m p O b j                                                                                           j       0 T a b l e                                                                                           `   B                                                                                                                                               	         
              A   N   { F D 8 F F A C 0 - 5 A 7 5 - 1 1 D 1 - B 6 D 9 - 9 7 7 7 3 B 9 E 8 B 1 0 }                                                                  Oh +'0   T                                               	            
          
   (     4     <     D     L               s         s       BATMAN         ATM      Normal.dot        BATMAN d      2 TM      Microsoft Word 8.0  @    G    @    f.z@    83z         S     )      
  	           F   Document Microsoft Word 
   MSWordDoc    Word.Document.8 9q                                                         ՜. +,D   ՜. +,D           h      p                                                   
                       Dell Computer Corporation D    Y            E3     
                                                 Titre                         6      >         
   _PID_GUID                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    