;|---------------------------------------------------------------------------|
;|                     ST6292/94 Registers Declaration                       |
;| Use this file with the .input directive.                                  |
;|---------------------------------------------------------------------------|

x        .def 80h!m               ; Index register.
y        .def 81h!m               ; Index register.
v        .def 82h                 ; Short direct register.
w        .def 83h                 ; Short direct register.

a        .def 0ffh!m              ; Accumulator.

dra      .def 0c0h                ; Port a data register.
drb      .def 0c1h                ; Port b data register.
drc      .def 0c2h                ; Port c data register.

ddra     .def 0c4h                ; Port a direction register.
ddrb     .def 0c5h                ; Port b direction register.
ddrc     .def 0c6h                ; Port c direction register.

ora      .def 0cch                ; Port a option register.
orb      .def 0cdh                ; Port b option register.
orc      .def 0ceh                ; Port c option register.

ior      .def 0c8h                ; Interrupt option register.
drwr     .def 0c9h                ; Data rom window register.

adr      .def 0d0h                ; A/D result register.
adcr     .def 0d1h                ; A/D control register.

psc1     .def 0d2h                ; Timer 1 prescaler register.
tcr1     .def 0d3h!m              ; Timer 1 counter register.
tscr1    .def 0d4h                ; Timer 1 status control register.

tmcr2    .def 0d5h                ; Timer 2 mode control register.
tscr20   .def 0d6h                ; Timer 2 status/control register.
tscr21   .def 0d7h                ; Timer 2 status/control register.
trcr2    .def 0d9h                ; Timer 2 reload/capture register.
tcr2     .def 0dah                ; Timer 2 compare register.
tlr2     .def 0dbh                ; Timer 2 load register.
    
wdr      .def 0d8h                ; Watchdog register.

ocr      .def 0dch                ; Oscillateur control register.

lvi      .def 0ddh                ; Multiplex register / lvi flag register.

rtcr     .def 0deh                ; Real time clock control register.

spirad   .def 0e0h                ; SPI register RAD.
spidiv   .def 0e1h                ; SPI register DIV.
spimod   .def 0e2h                ; SPI register MOD.

mbr      .def 0e8h                ; Memory bank register.

eecr     .def 0eah                ; Eeprom control register.
