;===========================================================
;=                 REPETITEUR ANALOGIQUE                   =
;===========================================================

;Reception serie, sur 16 bits, par boucle de courant, avec
;affichage analogique de la donnee recue.

;attention: les contenus de "timer2ms" et de "seuil" sont
;pour un quartz de 6.144 MHz.
;Seuil pour 3V environ,
;timer2ms pour 2ms environ.

;Directives d'assemblage
;=======================

		.title "repana"
		.vers "st6215"
		.input "6215_reg.asm"
		.w_on

;Tableau des micro-pas
;=====================

		.org 880h

micropas	.byte 8Fh,09Fh,0BEh,0CEh,0DDh,0EBh,0FAh,0F8h
		.byte 0F7h,0F5h,0E4h,0D2h,0C1h,0B1h,90h,70h
		.byte 60h,41h,31h,22h,14h,05h,07h,08h
		.byte 0Ah,1Bh,2Dh,3Eh,4Eh,6Fh,0FFh,0FFh

;Constantes
;==========

watch		.equ 0FEh
seuil		.equ 9Bh
timer2ms	.equ 40h		; ps2,ps1,ps0 = 100

;Adresses registres
;==================

consmsb		.def 84h
conslsb		.def 85h
posmsb		.def 86h
poslsb		.def 87h
recepmot	.def 88h
recepmsb	.def 89h
pccopy		.def 8Ah		; image du registre drc
consh		.def 8Bh		; stockage des 2
consl		.def 8Ch		; octets recus

;Initialisations
;===============

reset		ldi wdr, watch		; PC7 : entree d'interruption
		ldi ddrc, 00101111b	; PC6 : entree avec rappel 
		ldi orc, 10011111b	; PC5 : sortie drain ouvert
		ldi drc, 00111111b	; mise a "1" 
					; PC4 : entree analogique
		ldi pccopy, 00111111b	; pccopy : image du port C

		ldi ddra, 0FFh		; 8 sorties
		ldi ora, 0FFh		; symetriques pour
		clr dra			; le MPAP

		ldi tscr, 10011100b	; initialisation du timer

		ldi drwr, micropas.w	; initialiser tableau
		ldi x,micropas.d	; des micro-pas

		clr poslsb
		clr posmsb
		clr conslsb
		clr consmsb

		ldi w, 0Fh

;Programme principal
;===================

debut		ldi wdr, watch

init1		jrr 6, drc, init2	; l'aiguille est-elle devant
		call recul		; le capteur a la mise sous
		jp init1		; tension

init2		call avance		; recherche de l'affichage "0"
		jrr 6, drc, init2	; phase d'initialisation

initbis		ldi ior, 00110000b	; autorise interruption
					; pour le CAN, le timer,
		reti			; et front montant sur PortC

milieu		ld a, w
		jrnz moteur

		ld a, recepmsb		; on pourrait traiter
		ld consh, a		; directement recepmsb et

		ld a, recepmot		; recepmot, sans utiliser
		ld consl, a		; consl et consh

		call fois32		; consmsb,lsb pour
					; rotatio2
moteur		ldi wdr, watch
		call rotatio2		; commande du MPAP

		jp milieu

;Rotation du moteur
;==================

rotatio2	ld a, consmsb		; voir organigramme
		cp a, posmsb		; du sp ROTATION
		jrz rotat1
		jp rotat4

rotat1		ld a, conslsb
		cp a, poslsb
		jrnz rotat2

		ret

rotat2		jrnc rotat3
		jp rotat5

rotat3		ld a, consmsb
		sub a, posmsb
		cpi a, 16h
		jrnc relai
		jp rotat6
relai		jp rotat11

rotat4		jrnc rotat3

rotat5		ld a, posmsb
		sub a, consmsb
		cpi a, 16h
		jrnc rotat6
		jp rotat11

rotat6		ld a, posmsb
		cpi a, 2Ch
		jrnc rotat7
		jp rotat10

rotat7		jrz rotat9

rotat8		ld a, posmsb
		subi a, 2Dh
		ld posmsb, a
		jp rotat10

rotat9		ld a, poslsb
		cpi a, 0E0h
		jrc rotat10
		jp rotat8

rotat10		ld a, poslsb
		addi a, 20h
		jrnc sansret2
		inc posmsb
sansret2	ld poslsb, a
		call recul		; l'appel des sp avance
		ret			; et recul peut devoir etre
					; permute pour que le sens de
					; rotation soit le meme que
					; celui du capteur
rotat11		ld a, posmsb
		jrz rotat12
		jp rotat13

rotat12		ld a, poslsb
		cpi a, 20h
		jrnc rotat13
		ldi a, 2Dh
		add a, posmsb
		ld posmsb, a

rotat13		ld a, poslsb
		subi a, 20h
		jrnc sansret3
		dec posmsb
sansret3	ld poslsb, a
		call avance
		ret

fois32		ldi v, 05		; decalage a gauche
fois2		ld a, consl		; de consh, consl
		sla a			; 5 fois
		ld consl, a
		ld a, consh
		rlc a
		ld consh, a
		dec v
		jrnz fois2
		ld consmsb, a		; [A] = consh
		ld a, consl		; resultat dans
		ld conslsb, a		; consmsb,lsb
		ret

avance		inc x
		ld a, x
		cpi a, micropas.d+30
		jrnz avance1
		ldi x, micropas.d
avance1		ld a, (x)
		ld dra, a
		call tempo
		ret

recul		dec x
		ld a, x
		cpi a, micropas.d-1
		jrnz recul1
		ldi x, micropas.d+29
recul1		ld a, (x)
		ld dra, a
		call tempo
		ret

tempo		ldi v,30h
tempo1		ldi wdr,watch
		dec v
		jrnz tempo1
		ret

;Acquisition analogique
;======================

analog		ldi adcr, 0B0h		; lancement acquisition
		wait			; PC7 est en permanence
					; configuree en entree
		ret			; analogique

;Interruption PC7
;================

clk		ld y, a			; sauvegarde de l'accu
		call analog

		res 5, pccopy		; decharger capa
		ld a, pccopy
		ld drc, a

		ldi a, seuil		; test reception d'un
		cp a, adr		; "0" ou d'un "1"
		ld a, recepmot		; gestion de l'octet en
		rlc a			; cours de reception
		ld recepmot, a		; stockage octet faible
		ld a, recepmsb		; recuperation bit sorti a gauche
		rlc a			; injection dans poids faible
		ld recepmsb, a		; de l'octet fort

		jrs 7, tscr, clk1	; test de tmz, pour
		dec w			; determiner le debut
		jp clk2			; d'un nouvel octet

clk1		ldi w, 0Fh

clk2		ldi tcr, timer2ms
		res 7, tscr		; lancement tempo 2ms

		set 5, pccopy		; fin de dcharge capa
		ld a, pccopy
		ld drc, a

		ld a, y			; restitution de l'accu
		reti			; pour le prog. principal

;Interruption du CAN
;===================

intadc		ldi adcr, 10h
		reti

;Vecteurs d'interruption
;=======================

		.org 0FF0h

adc		jp intadc

		.org 0FF4h

portc		jp clk

		.org 0FFEh

res		jp reset
