;================================================================
;=         Commande d'un moteur pas  pas en micro-pas          =
;================================================================

;recopie d'une tension d'entree analogique au moyen d'un MPAP a 
;aimant permanent, 7.5 degres par pas, commande en micropas:
;1 micropas par degre (30 micropas pour 4 pas). Adaptation d'echelle:
;rotation totale du MPAP de 360 degres modulo 360

;Directives d'assemblage
;=======================

		.title "rotatmod"
		.vers "st6215"
		.romsize 2
		.input "6215_reg.asm"	
		.w_on

;Tableau des micro-pas
;=====================

		.org 880h

micropas	.byte 8Fh,09Fh,0BEh,0CEh,0DDh,0EBh,0FAh,0F8h
		.byte 0F7h,0F5h,0E4h,0D2h,0C1h,0B1h,90h,70h
		.byte 60h,41h,31h,22h,14h,05h,07h,08h
		.byte 0Ah,1Bh,2Dh,3Eh,4Eh,6Fh,0FFh,0FFh

;Constantes
;==========

watchtim	.equ0FEh

;Adresses registres
;==================

consmsb		.def 84h		; consigne
conslsb		.def 85h
posmsb		.def 86h		; position
poslsb	.def 87h	

;Initialisations
;===============

reset		ldi wdr, watchtim	; 4 entrees sans
		clr ddrc		; rappel ni 
		clr orc			; interruption
		ldi drc, 0FFh		; dont Pc4 pour le CAN

		ldi ddra, 0FFh		; 8 sorties
		ldi ora, 0FFh		; symetriques pour
		clr dra			; le MPAP

		ldi ior, 10h		; autorise interruption
					; pour le CAN

		ldi drwr, micropas.w	; initialiser tableau
		ldi x,micropas.d	; des micro-pas

		clr poslsb
		clr posmsb

		reti

;Programme principal
;===================

debut		ldi wdr, watchtim
		call analog		; acquisition analogique
		ldi wdr, watchtim
		call rotation		; rotation du moteur
		ldi wdr, watchtim
		jp debut

;Sous-programme d'acquisition analogique
;=======================================

analog		set 4, orc		; pc4 = entree analogique
		ldi adcr, 0B0h		; lancement acquisition
		wait

		res 4, orc
		ret

;Rotation du moteur
;==================

rotation	call fois45		; [ADR]*45 -> consmsb,lsb
		ld a, consmsb
		cp a, posmsb
		jrz rotat1
		jp rotat4

rotat1		ld a, conslsb
		cp a, poslsb
		jrnz rotat2
		ret			; fin de test: consigne = position

rotat2		jrnc rotat3
		jp rotat5

rotat3		ld a, consmsb		; test si ecart
		sub a, posmsb		; superieur  1/2 tour
		cpi a, 16h		; pour cons > pos
		jrnc relai
		jp rotat6
relai		jp rotat11

rotat4		jrnc rotat3

rotat5		ld a, posmsb		; test si ecart
		sub a, consmsb		; superieur  1/2 tour
		cpi a, 16h		; pour pos > cons
		jrnc rotat6
		jp rotat11

rotat6		ld a, posmsb		; gestion de la
		cpi a, 2Ch		; variable
		jrnc rotat7		; posmsb,lsb
		jp rotat10		; modulo 2D00h

rotat7		jrz rotat9
		
rotat8		ld a, posmsb
		subi a, 2Dh
		ld posmsb, a
		jp rotat10

rotat9		ld a, poslsb
		cpi a, 0E0h
		jrc rotat10
		jp rotat8

rotat10		ld a, poslsb		; incrementer posmsb,lsb
		addi a, 20h	
		jrnc sansret2
		inc posmsb
sansret2	ld poslsb, a
		call avance		; avancer d'un micro-pas
		ret

rotat11		ld a, posmsb
		jrz rotat12
		jp rotat13

rotat12		ld a, poslsb		; gestion de la
		cpi a, 20h		; variable posmsb,lsb
		jrnc rotat13		; modulo 2D00h
		ldi a, 2Dh
		add a, posmsb
		ld posmsb, a

rotat13		ld a, poslsb		; dcrmenter posmsb,lsb
		subi a, 20h
		jrnc sansret3
		dec posmsb
sansret3	ld poslsb, a
		call recul		; reculer d'un micro-pas
		ret

fois45		clr conslsb		; multiplication par 45
		clr consmsb		; de [ADR]
		ldi v,44
		ld a, adr
plusune		add a, adr
		jrnc sansret1
		inc consmsb
sansret1	dec v
		jrnz plusune
		ld conslsb, a
		ret

avance		inc x			; pointeur de donnees du
		ld a, x			; tableau des micro-pas
		cpi a, micropas.d+30
		jrnz avance1		; lecture modulo 30
		ldi x, micropas.d
avance1		ld a, (x)		; avance
		ld dra, a		; d'un micropas
		call tempo
		ret

recul		dec x			; pointeur de donnees du
		ld a, x			; tableau des micro-pas
		cpi a, micropas.d-1
		jrnz recul1		; lecture modulo 30
		ldi x, micropas.d+29
recul1		ld a, (x)		; recul
		ld dra, a		; d'un micro-pas
		call tempo
		ret

tempo		ldi v,30h		; tempo entre 2 ordres
tempo1		ldi wdr,watchtim	; de mouvement du MPAP
		dec v			; a ajuster en fonction de
		jrnz tempo1		; la frequence du quartz et
					; des caracteristiques du
					; moteur.
;Interruption du CAN
;===================

intadc		ldi adcr, 10h
		reti

;Vecteurs d'interruption
;=======================

		.org 0FF0h

adc		jp intadc

		.org 0FFEh

res		jp reset


