;=====================================================================
;=                  SERRURE ELECTRONIQUE (VERSION 1)                 =
;=====================================================================

;serrure electronique (code avec clavier decimal a 11 fils).
;code a 4 chiffres.

;Directives d'assemblage

		.title "serrure1"	;voir chapitre 01 concernant 
		.vers "st6215"		;les principales directives
		.romsize 2		;d'assemblage,
		.input "6215_reg.asm"	;les definitions de constantes,

;Constantes

watch		.equ 0FEh

;adresses registres

bufpia		.def 84h
val		.def 85h
memocode	.def 86h
memoclav	.def 8Ah
touche		.def 8Eh
boncode		.def 8Fh

;PROGRAMME PRINCIPAL
;===================

;Initialisation des entrees/sorties

		.org 880h	;espace memoire pour ST62T15

reset		ldi wdr,watch	;chargt chien de garde
		clr ddrb	;PB et PC en entrees
		clr orb		;avec resistances de
		clr drb		;rappel a +Vdd
		clr ddrc
		clr orc	
		clr drc	

		ldi ddra,0Fh	;Pa0,Pa1 Sort.push-pull	
		ldi ora,03h	;Pa2,Pa3 Sort. drain ouvert
		clr dra		;Pa7 Entree avec resistance de rappel

;Chargement du code standard

		ldi memocode, 4	
		ldi memocode+1, 3
		ldi memocode+2, 2
		ldi memocode+3, 1

;Corps du programme principal

debut		call scrut	;pour ce programme

		call clavier	;se referer a l'organigramme

		call test	;principal, pour lequel:

		jrr 0,boncode,debut
		jrr 7,dra,gest	;SCRUT='SAISIE D'UNE

retour		call scrut	;TOUCHE AU CLAVIER'

		call code

retest		ldi wdr,watch	;CLAVIER='ECRITURE
		ld A,drb	;DANS TABLE 'MEMOCLAV'
		cpi A,0FFh
		jrnz retour	;TEST='TEST CODE'

		ld A,drc
		andi A,0F0h	;CODE='ECRITURE
		cpi A,0F0h	;DANS TABLE MEMOCODE'
		jrz prg
		jp retour	;GESTION='GESTION

prg		jrs 7,dra,retest;DES SORTIES'
		jp debut

gest		call gestion
		jp debut	
	
;SOUS PROGRAMME : SAISIE D'UN CHIFFRE AU CLAVIER
;===============================================

scrut		ld A,drb
		ldi wdr,watch
		cpi a,0FFh
		jrnz scrut1
		ld A,drc
		andi A,0F0h
		cpi A,0F0h
		jrz scrut
		ldi touche, 01h	
		jp scrut2

scrut1		ldi touche, 00h

scrut2		ldi V,0FFh
		ld bufpia,A

scrut3		ld A,touche
		jrnz scrut4
		ld A,drb
		jp scrut5

scrut4		ld A,drc
		andi A,0F0h

scrut5		ldi wdr,watch
		cp A,bufpia
		jrz scrut6
		jp scrut

scrut6		dec V
		ld A,V
		jrz scrut7
		jp scrut3

scrut7		ld A,bufpia
		Com A
		ld bufpia,A
		ld A,touche
		jrnz scrut8
		clr val
		jp scrut9

scrut8		ldi val,08h
scrut9		ld A,bufpia
scratch		rlc A
		jrc scrut10
		inc val
		jp scratch

scrut10		ldi V,0FFh
scrut11		ld A,drb
		ldi wdr,watch
		cpi A,0FFh
		jrnz scrut10
		ld A,drc
		andi A,0F0h
		cpi A,0F0h
		jrz scrut12
		jp scrut10

scrut12		dec V
		ld A,V
		jrz scrut13
		jp scrut11

scrut13		Ret

;SOUS PROGRAMME: ECRITURE DANS TABLE MEMOCLAV
;============================================

clavier		ldi X,memoclav+2

clavier1	ld A,(X)
		inc X
		ld (X),A
		dec X
		ld A,X
		cpi A,memoclav
		jrz clavier2
		dec X
		jp clavier1

clavier2	ld A,val
		ld (X),A
		Ret

;SOUS PROGRAMME: TESTCODE
;========================

test		ldi X,memoclav+3
		ldi Y,memocode+3

test1		ld A,(Y)
		ld V,A
		ld A,(X)
		cp A,V
		jrz test2
		clr boncode
		Ret
test2		ldi A,memoclav
		cp A,X
		jrz test3
		dec X
		dec Y
		jp test1
test3		ldi boncode,01h
		ret

;SOUS PROGRAMME: ECRITURE DANS TABLE MEMOCODE
;============================================

code		ldi X,memocode+2

code1		ld A,(X)
		inc X
		ld (X),A
		dec X	;
		ldi A,memocode
		cp A,X
		jrz code2
		dec X
		jp code1

code2		ld A,val
		ld (X),A
		ret

;SOUS PROGRAMME: GESTION DES SORTIES
;===================================

gestion		ld A,dra
		andi A,01h
		jrz gestion1
		res 0,dra
		res 2,dra
		set 1,dra
		set 3,dra
		ret

gestion1	res 1,dra
		res 3,dra
		set 0,dra
		set 2,dra
		ret


;VECTEURS D'INTERRUPTION
;=======================

		.org 0FFCh

nmi		reti

		.org 0FFEh

res		jp reset

