;==================================================================
;=                SERRURE ELECTRONIQUE (version2)                 =
;==================================================================

;serrure electronique avec clavier analogique (a 2 fils).
;entree analogique en provenance du clavier : pc7
;visu des sorties bistables : pa1 et pa2 en drain ouvert (led)
;programmation d'un nouveau code par inter PRG : pa3 entree avec rappel

;Directives d'assemblage
;=======================

		.title "serrana"
		.vers "st6215"
		.input "6215_reg.asm"
	
;Constantes
;==========

watch		.equ 0FEh
antireb		.equ 7Fh
zero		.equ 8
un		.equ 25
deux		.equ 42
trois		.equ 59
quatre		.equ 76
cinq		.equ 93
six		.equ 110
sept		.equ 127
huit		.equ 144
neuf		.equ 161

;Adresses registres
;==================

buftouch	.def 84h
memocode	.def 86h
memoclav	.def 8Ah
boncode		.def 8Fh

;Programme principal
;===================

;Initialisation des entrees/sorties

		.org 880h		;espace memoire pour ST62T15

reset		ldi wdr,watch		;faire patienter le chien
		ldi ddra,0F7h		;pa1 et pa2 drain ouvert
		ldi ora,0F1h		;pa3 entree avec rappel
		ldi dra,0F7h
		ldi ddrb,0FFh		;pb drain ouvert 
		clr orb			;(non utilise)
		ldi ddrc,7fh
		ldi orc,0FFh		;pc7 entree ana
		ldi drc,0FFh
		ldi adcr,1Fh		;activation du CAN
		set 1,dra		;Mise a '0' des 
		set 2,dra		;sorties

;Chargement du code de mise sous tension

		ldi memocode, 4	
		ldi memocode+1, 3
		ldi memocode+2, 2
		ldi memocode+3, 1

;Corps du programme principal

debut		call saisie		;saisie stockee dans buftouch
		call clavier		;ecriture dans table memoclav
		call test		;comparer tables memoclav et
					; memocode
		jrr 0,boncode,debut	;si differentes, on recommence
		jrr 3,dra,gest		;si PRG=0, gestion des sorties

retour		call saisie		;sinon ecriture dans table
		call code		;memocode de la prochaine saisie
retest		ldi wdr,watch		;faire patienter le chien
		call analog		;touche actionnee?
		cpi a,161		;si oui, nouvelle ecriture
		jrc retour		;dans memocode
		jrs 3,dra,retest	;si non, PRG=1 attente 
		jp debut		;PRG=0 fin d'ecriture du code
gest		call gestion
		jp debut

;Saisie d'un chiffre au clavier; stockee dans buftouch
;=====================================================

saisie		call analog		;[adr] dans A
		ldi wdr,watch		;faire patienter le chien
		cpi a,161
		jrnc saisie		;pas de touche enfoncee
		call touche		;numero de touche dans W
		ld a,w
		ld buftouch,a		;numero de touche dans buftouch

		ldi v,antireb		;programme d'antirebonds

saisie1		call analog

		call touche

		ld a,w
		cp a,buftouch
		jrz saisie2
		jp saisie		;donnee instable, on recommence

saisie2		ldi wdr,watch		;faire patienter le chien
		dec v
		jrnz saisie1		;touche validee

saisie3		ldi v,antireb
		ldi wdr,watch		;faire patienter le chien

saisie4		call analog		;attente de touche relachee

		cpi a,161
		jrc saisie3

		ldi wdr,watch
		dec v
		jrnz saisie4

		ret

;conversion analogique et resultat dans A

analog		set 5,adcr		;declenche une acquisition
analog1		jrr 6,adcr,analog1	;attendre la fin de l'acquisition
		ld a,adr
		res 5,adcr		;prepare le CAN pour une
		ret			;prochaine acquisition

;conversion poids binaire de l'acquisition en numero de touche
;resultat dans w

touche		clr w			;num=0
		cpi a,zero
		jrc relais

		inc w			;num=1
		cpi a,un
		jrc relais

		inc w			;num=2
		cpi a,deux
		jrc relais

		inc w			;num=3
		cpi a,trois
		jrnc touche1

relais		jp touche2

touche1		inc w			;num=4
		cpi a,quatre
		jrc relais

		inc w			;num=5
		cpi a,cinq
		jrc relais

		inc w			;num=6
		cpi a,six
		jrc touche2

		inc w			;num=7
		cpi a,sept
		jrc touche2

		inc w			;num=8
		cpi a,huit
		jrc touche2

		inc w			;num=9

touche2		ret

;Ecriture dans table MEMOCLAV
;============================

clavier		ldi x,memoclav+2	;[memoclav+2] dans [memoclav+3]
clavier1	ld a,(x)	 
		inc x			;[memoclav+1] dans 
		ld (x),a	
		dec x			; memoclav+2, puis
		ld a,x	
		cpi a,memoclav		;[memoclav] dans 
		jrz clavier2	 
		dec x			;memoclav+1, enfin
		jp clavier1	 
clavier2	ld a,buftouch		;[buftouch] dans
		ld (x),a
		ret			;memoclav

;Testcode
;========

test		ldi x,memoclav+3	;pointer memoclav+3
		ldi y,memocode+3	;pointer memocode+3

test1		ld a,(y)		;comparer les contenus
		ld v,a			;des registres
		ld a,(x)		;pointes par
		cp a,v			;x et par y
		jrz test2		;"0" dans boncode
		clr boncode		;si contenus
		ret			;differents et retour

test2		ldi a,memoclav		;est-ce la fin de la
		cp a,x			;comparaison?
		jrz test3
		dec x			;non: pointer l'adresse 
		dec y			;suivante de chaque table
		jp test1		;et refaire le test

test3		ldi boncode,01h		;oui:"1" dans boncode
		ret			;et retour

;Ecriture dans table MEMOCODE
;============================

code		ldi x,memocode+2	;chargement de la table
code1		ld a,(x)		;memocode identique	
		inc x			;a celui de la table
		ld (x),a
		dec x			;memoclav
		ldi a,memocode
		cp a,x			;(sous-programme clavier)
		jrz code2
		dec x
		jp code1
code2		ld a,buftouch
		ld (x),a
		ret

;Gestion des sorties
;===================

gestion		jrs 1,dra,gestion1	;basculer le 
		res 2,dra		;niveau logique
		set 1,dra		;des deux sorties
		ret			;afin qu'elles

gestion1	res 1,dra		;restent toujours
		set 2,dra		;complementaires
		ret

;vecteurs d'interruption
;=======================

		.org 0FFCh

nmi		reti

		.org 0FFEh

res		jp reset
