;==========================================================
;=           TRANSMISSION PAR BOUCLE DE COURANT           =
;==========================================================

;Programme de transmission serie par boucle de courant
;du contenu de ADR (resultat d'une conversion analogique
;numerique). Signal emis sur broche Timer.


;Directives d'assemblage
;=======================

		.title "transbdc"
		.vers "st6215"
		.romsize 2
		.input "6215_reg.asm"

;Constantes
;==========

watch		.equ 0FEh
bitabit		.equ 0A6h		; ps2,ps1,ps0 = 001
niveau0		.equ 1Bh		; ----------- = 000
niveau1		.equ 64h		; ----------- = 000
motamot		.equ 0D2h		; ----------- = 100

;Registres
;=========

registre	.def 84h

Initialisations
;==============

		.org 880h

reset		ldi wdr, watch
		clr ddrc		; Port C: 4 entrees sans
		clr orc			; rappel ni interruption
		ldi drc, 0FFh		; dont pc4 pour le CAN

		ldi ddrb, 0FFh		; pour visu
		clr orb

		ldi ior, 10h		; autoriser interruption
		reti

;Programme principal
;===================

debut		ldi wdr, watch		; ligne au repos
		ldi tscr,10100000b	; '0' sur broche timer
		ldi tcr, motamot	; tempo SDM
		ldi tscr,00101100b	; envoi d'un niveau bas
					; pendant 5ms
		ldi wdr, watch		; on en profite pour faire
		call analog		; une acquisition

boucle1		jrr 7, tscr, boucle1	; test de fin de SDM

		ldi v, 08

suivant		ldi wdr, watch		; separateur de bit
		ldi tscr, 10100000b	; '0' sur broche timer
		ldi tcr, bitabit	; envoi d'un niveau bas
		ldi tscr,00101001b	; pendant 500us

boucle2		jrr 7, tscr, boucle2	; test de fin de SDB

		ldi wdr, watch		; emission d'un octet
		ldi tscr,10110000b	; '1' sur broche timer:

		jrs 7, registre, nivhaut

nivbas		ldi wdr, watch
		ldi tcr, niveau0	; pdt la duree d'emission
		ldi tscr,00101000b	; d'un 'zero' logique,

boucle3		jrr 7, tscr, boucle3	; test fin de NH

		jp test

nivhaut		ldi wdr, watch
		ldi tcr, niveau1	; ou de celle d'un 'un'
		ldi tscr, 00101000b	; logique

boucle4		jrr 7, tscr, boucle4

test		ldi wdr, watch
		dec v
		jrnz decall		; dernier bit de l'octet
		jp debut		; a emettre?

decall		ld a, registre		; preparer bit suivant
		sla a
		ld registre, a

		jp suivant

;Sous-programme d'acquisition analogique
;=======================================

analog		set 4, orc
		ldi adcr, 10110000b
		wait
		ld a, adr
		res 4, orc

		ld drb, a
		ld registre, a
		ret

;Interruption du CAN
;===================

intadc		ldi adcr, 10h
		reti


;Interruptions
;=============
		.org 0FF0h

adc		jp intadc

		.org 0FFEh

res		jp reset

